/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class RingBuffer<T>
implements Queue<T> {
    protected final int capacity;
    private final T[] refs;
    private int head = 0;
    private int tail = 0;
    protected int size = 0;

    public RingBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.refs = new Object[capacity];
    }

    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isFull() {
        return this.size == this.capacity;
    }

    @Override
    public boolean add(T ref) throws IllegalStateException {
        if (ref == null) {
            throw new NullPointerException();
        }
        this.beforeOffer(ref);
        if (this.size == this.capacity) {
            throw new IllegalStateException();
        }
        this.refs[this.head] = ref;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        return true;
    }

    @Override
    public boolean offer(T ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        this.beforeOffer(ref);
        if (this.size == this.capacity) {
            return false;
        }
        this.refs[this.head] = ref;
        this.head = (this.head + 1) % this.capacity;
        ++this.size;
        return true;
    }

    protected void beforeOffer(T ref) {
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T e : c) {
            this.add(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public final void clear(boolean clearRefs) {
        if (clearRefs) {
            while (this.size > 0) {
                this.refs[this.tail] = null;
                --this.size;
                this.tail = (this.tail + 1) % this.capacity;
            }
        }
        this.size = 0;
        this.tail = 0;
        this.head = 0;
    }

    final int getHeadIndex() {
        return this.head;
    }

    final int getTailIndex() {
        return this.tail;
    }

    @Override
    public Object[] toArray() {
        return this.toArray((TX[])new Object[this.size]);
    }

    @Override
    public <TX> TX[] toArray(TX[] a) {
        int n;
        TX[] r = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        int i = this.tail;
        for (n = 0; n < this.size; ++n) {
            T ref = this.refs[i];
            assert (ref != null);
            r[n] = ref;
            i = (i + 1) % this.capacity;
        }
        if (n < r.length) {
            r[n] = null;
        }
        return r;
    }

    public final T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException();
        }
        int i = (this.tail + index) % this.capacity;
        return this.refs[i];
    }

    protected final T _get(int i) {
        return this.refs[i];
    }

    T remove(int index) {
        int nexti;
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException();
        }
        int i = (this.tail + index) % this.capacity;
        T ref = this.refs[i];
        this.refs[i] = null;
        while ((nexti = (i + 1) % this.capacity) != this.head) {
            this.refs[i] = this.refs[nexti];
            i = nexti;
        }
        this.refs[i] = null;
        this.head = i;
        --this.size;
        return ref;
    }

    @Override
    public final T element() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.peek();
    }

    @Override
    public final T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.refs[this.tail];
    }

    @Override
    public final T poll() {
        if (this.size <= 0) {
            return null;
        }
        T ref = this.refs[this.tail];
        this.refs[this.tail] = null;
        --this.size;
        this.tail = (this.tail + 1) % this.capacity;
        return ref;
    }

    public boolean scanHead(int nscan, T ref) {
        if (nscan <= 0) {
            throw new IllegalArgumentException();
        }
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        int head = this.head;
        int count = this.size;
        for (int i = 0; i < nscan && count > 0; --count, ++i) {
            head = head == 0 ? this.capacity - 1 : head - 1;
            if (this.refs[head] != ref) continue;
            return true;
        }
        return false;
    }

    public final boolean scanTail(int nscan, T ref) {
        if (nscan <= 0) {
            throw new IllegalArgumentException();
        }
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        int i = this.tail;
        for (int n = 0; n < nscan; ++n) {
            if (ref == this.refs[i]) {
                return true;
            }
            i = (i + 1) % this.capacity;
        }
        return false;
    }

    @Override
    public T remove() throws NoSuchElementException {
        T ref = this.poll();
        if (ref == null) {
            throw new NoSuchElementException();
        }
        return ref;
    }

    @Override
    public boolean contains(Object ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        int i = this.tail;
        for (int n = 0; n < this.size; ++n) {
            if (ref == this.refs[i]) {
                return true;
            }
            i = (i + 1) % this.capacity;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            return true;
        }
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public boolean remove(Object ref) {
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            if (ref != itr.next()) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<T> itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    private class MyIterator
    implements Iterator<T> {
        private int next = 0;
        private int current = -1;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next < RingBuffer.this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ref = RingBuffer.this.get(this.next);
            this.current = this.next++;
            return ref;
        }

        @Override
        public void remove() {
            int i = this.current;
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            int tmp = RingBuffer.this.tail;
            RingBuffer.this.remove(i);
            this.next = i == tmp ? RingBuffer.this.tail : i;
        }
    }
}

