/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.sail.base.config.BaseSailSchema;
import org.eclipse.rdf4j.sail.config.AbstractSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

public abstract class BaseSailConfig
extends AbstractSailImplConfig {
    private String evalStratFactoryClassName;

    protected BaseSailConfig(String type) {
        super(type);
    }

    public String getEvaluationStrategyFactoryClassName() {
        return this.evalStratFactoryClassName;
    }

    public void setEvaluationStrategyFactoryClassName(String className) {
        this.evalStratFactoryClassName = className;
    }

    public EvaluationStrategyFactory getEvaluationStrategyFactory() throws SailConfigException {
        if (this.evalStratFactoryClassName == null) {
            return null;
        }
        try {
            return (EvaluationStrategyFactory)Thread.currentThread().getContextClassLoader().loadClass(this.evalStratFactoryClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SailConfigException((Throwable)e);
        }
    }

    public Resource export(Model graph) {
        Resource implNode = super.export(graph);
        if (this.evalStratFactoryClassName != null) {
            graph.setNamespace("sb", "http://www.openrdf.org/config/sail/base#");
            graph.add(implNode, BaseSailSchema.EVALUATION_STRATEGY_FACTORY, (Value)SimpleValueFactory.getInstance().createLiteral(this.evalStratFactoryClassName), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        try {
            Models.objectLiteral((Model)graph.filter(implNode, BaseSailSchema.EVALUATION_STRATEGY_FACTORY, null, new Resource[0])).ifPresent(factoryClassName -> this.setEvaluationStrategyFactoryClassName(factoryClassName.stringValue()));
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

