/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.IOUtils;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class FileUtil {
    private List<File> files = new ArrayList<File>();

    public static String readFileLocally(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static void writeFileLocally(String path, String content) {
        File file = new File(path);
        file.getParentFile().mkdirs();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(content);
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                throw new JPSRuntimeException(e.getMessage(), e);
            }
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        String string;
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, (OutputStream)outputStream);
            string = new String(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                outputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JPSRuntimeException(e.getMessage(), e);
            }
        }
        inputStream.close();
        outputStream.close();
        return string;
    }

    public static InputStream stringToInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes(Charset.forName("UTF-8")));
    }

    public static BufferedReader openSourceFile(String filePathPlusName) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePathPlusName), "UTF-8"));
    }

    public static List<List<String>> openCSVSourceFile(String fileName) throws IOException {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        try (CSVReader csvReader = new CSVReader(new FileReader(fileName));){
            String[] values = null;
            while ((values = csvReader.readNext()) != null) {
                records.add(Arrays.asList(values));
            }
        }
        return records;
    }

    public static BufferedWriter openBufferedWriter(String filePathPlusName) throws IOException {
        return new BufferedWriter(new FileWriter(filePathPlusName));
    }

    public static void unzip(String zipFilePath, String destDir) {
        ZipFile zipFile = new ZipFile(zipFilePath);
        try {
            zipFile.extractAll(destDir);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
    }

    public List<File> getDirectoryFiles(File folder, List<String> fileExtensions) {
        if (folder != null && folder.isFile()) {
            for (String fileExtension : fileExtensions) {
                if (!folder.getName().endsWith(fileExtension)) continue;
                this.files.add(new File(folder.getAbsolutePath()));
            }
        }
        if (folder.isDirectory()) {
            String[] subFolders;
            for (String subFolder : subFolders = folder.list()) {
                this.getDirectoryFiles(new File(folder.getAbsolutePath().concat(File.separator).concat(subFolder)), fileExtensions);
            }
        }
        return this.files;
    }
}

