/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CompoundCRS;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.datum.GeodeticDatum;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.op.transformation.FrenchGeocentricNTF2RGF;
import org.cts.op.transformation.GridBasedTransformation;
import org.cts.op.transformation.NTv2GridShiftTransformation;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.RegistryManager;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class CRSTransformer {
    public static final String EPSG_4326 = "EPSG:4326";
    public static final String EPSG_3857 = "EPSG:3857";
    public static final String EPSG_25833 = "EPSG:25833";
    public static final String EPSG_28992 = "EPSG:28992";
    public static final String EPSG_3414 = "EPSG:3414";
    public static final String EPSG_2326 = "EPSG:2326";
    public static final String EPSG_32648 = "EPSG:32648";
    public static final String EPSG_32650 = "EPSG:32650";
    private static Logger logger;
    private static CRSFactory cRSFactory;
    private static Map<String, CoordinateReferenceSystem> crsMap;
    private static Map<String, Set<CoordinateOperation>> coordOpMap;

    private static synchronized CRSFactory getFactory() {
        if (cRSFactory == null) {
            cRSFactory = new CRSFactory();
            RegistryManager registryManager = cRSFactory.getRegistryManager();
            registryManager.addRegistry(new EPSGRegistry());
            logger = LogManager.getLogger(CRSTransformer.class);
        }
        return cRSFactory;
    }

    static double[] transformInternal(String sourceCRSName, String targetCRSName, double[] sourcePoint) throws IllegalCoordinateException, CoordinateOperationException, CRSException {
        GeodeticCRS sourceCRS = (GeodeticCRS)CRSTransformer.getCRS(sourceCRSName);
        GeodeticCRS targetCRS = (GeodeticCRS)CRSTransformer.getCRS(targetCRSName);
        Set<CoordinateOperation> ops = CRSTransformer.getCoordinateOperations(sourceCRS, targetCRS);
        if (sourceCRS.getDatum() == GeodeticDatum.WGS84 || targetCRS.getDatum() == GeodeticDatum.WGS84) {
            ops = CoordinateOperationFactory.excludeFilter(ops, FrenchGeocentricNTF2RGF.class);
            ops = CoordinateOperationFactory.excludeFilter(ops, NTv2GridShiftTransformation.class);
        } else if (sourceCRS.getIdentifier().getAuthorityName().equals("EPSG") && !(sourceCRS instanceof CompoundCRS) && !(targetCRS instanceof CompoundCRS)) {
            ops = CoordinateOperationFactory.excludeFilter(ops, GridBasedTransformation.class);
        }
        if (!ops.isEmpty()) {
            CoordinateOperation op = CoordinateOperationFactory.getMostPrecise(ops);
            double[] source = new double[sourcePoint.length];
            System.arraycopy(sourcePoint, 0, source, 0, sourcePoint.length);
            return op.transform(source);
        }
        String message = "No CRS transformation found from " + sourceCRS + " to " + targetCRS;
        logger.error(message);
        throw new RuntimeException(message);
    }

    public static double[] transform(String sourceCRSName, String targetCRSName, double ... sourcePoints) {
        double[] result = new double[sourcePoints.length];
        try {
            for (int i = 0; i < sourcePoints.length; i += 2) {
                double[] pointPoint = new double[]{sourcePoints[i], sourcePoints[i + 1]};
                double[] targetPoint = CRSTransformer.transformInternal(sourceCRSName, targetCRSName, pointPoint);
                result[i] = targetPoint[0];
                result[i + 1] = targetPoint[1];
            }
        }
        catch (IllegalCoordinateException | CRSException | CoordinateOperationException exc) {
            throw new JPSRuntimeException(exc.getMessage(), exc);
        }
        return result;
    }

    private static synchronized CoordinateReferenceSystem getCRS(String crsName) throws CRSException {
        if (crsMap.containsKey(crsName)) {
            return crsMap.get(crsName);
        }
        CoordinateReferenceSystem crs = CRSTransformer.getFactory().getCRS(crsName);
        crsMap.put(crsName, crs);
        return crs;
    }

    private static Set<CoordinateOperation> getCoordinateOperations(GeodeticCRS sourceCRS, GeodeticCRS targetCRS) throws CoordinateOperationException {
        String key = sourceCRS.getName() + "_" + targetCRS.getName();
        if (coordOpMap.containsKey(key)) {
            return coordOpMap.get(key);
        }
        Set<CoordinateOperation> ops = CoordinateOperationFactory.createCoordinateOperations(sourceCRS, targetCRS);
        coordOpMap.put(key, ops);
        return ops;
    }

    static {
        crsMap = new HashMap<String, CoordinateReferenceSystem>();
        coordOpMap = new HashMap<String, Set<CoordinateOperation>>();
    }
}

