/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.tools;

import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.TripleStoreClientInterface;

public class CloningTool {
    private static final Logger LOGGER = LogManager.getLogger(CloningTool.class);
    private static final int MAX_ATTEMPTS = 5;
    private final double defaultOverlapRatio = 0.1;
    private int stepSize = 500000;
    private int overlap = (int)((double)this.stepSize * 0.1);
    private boolean emptyTargetRequired = true;
    static ExprFactory exprFactory = new ExprFactory();

    public CloningTool() {
    }

    public CloningTool(int stepSize, int overlap) {
        this.stepSize = stepSize;
        this.overlap = overlap;
        if (!this.checkStepAndOverlap()) {
            this.cloneFailed("overlap cannot be larger than stepsize!", 0, 0);
        }
    }

    public void setStepsize(int stepSize) {
        this.stepSize = stepSize;
        this.overlap = (int)((double)stepSize * 0.1);
    }

    public void setStepsizeAndOverlap(int stepSize, int overlap) {
        this.stepSize = stepSize;
        this.overlap = overlap;
        if (!this.checkStepAndOverlap()) {
            this.cloneFailed("overlap cannot be larger than stepsize!", 0, 0);
        }
    }

    public void overrideEmptyTarget() {
        this.emptyTargetRequired = false;
        LOGGER.info("Warning: overriding empty target store requirement.");
    }

    public boolean checkStepAndOverlap() {
        return this.overlap < this.stepSize;
    }

    public void clone(TripleStoreClientInterface source, TripleStoreClientInterface target) {
        int targetCount;
        int originalTargetCount = targetCount = target.getTotalNumberOfTriples().intValue();
        if (this.emptyTargetRequired) {
            if (targetCount > 0) {
                this.cloneFailed("Target store is not empty!", targetCount, 0);
            }
        } else {
            LOGGER.info("Target store not empty, count=" + Integer.toString(originalTargetCount));
        }
        int sourceCount = source.getTotalNumberOfTriples();
        int sourceBlankCount = this.countBlanks(source);
        int sourceCountExBlanks = sourceCount - sourceBlankCount;
        LOGGER.info("Total source count: " + Integer.toString(sourceCount) + ", blanks: " + Integer.toString(sourceBlankCount));
        LOGGER.info("Starting clone...Step size: " + Integer.toString(this.stepSize) + ", overlap: " + Integer.toString(this.overlap));
        int attempts = 0;
        int nExpected = 0;
        int offset = 0;
        while (nExpected < sourceCountExBlanks) {
            int oldnExpected = nExpected;
            if (nExpected > 0) {
                offset = nExpected - this.overlap;
            }
            nExpected = Math.min(offset + this.stepSize, sourceCountExBlanks);
            this.performCloneStep(source, target, this.getSparqlConstructNoBlanks(this.stepSize, offset));
            targetCount = target.getTotalNumberOfTriples();
            if (targetCount - originalTargetCount < nExpected) {
                this.adjustOverlap(targetCount - originalTargetCount, nExpected, attempts);
                nExpected = oldnExpected;
                ++attempts;
                continue;
            }
            LOGGER.info("Cloned count: " + Integer.toString(targetCount - originalTargetCount) + ", expected count: " + Integer.toString(nExpected) + ", of " + Integer.toString(sourceCountExBlanks) + " (exludes triples with blank nodes).");
        }
        LOGGER.info("Cloning triples with blank nodes...");
        this.performCloneStep(source, target, this.getSparqlConstructBlanks());
        targetCount = target.getTotalNumberOfTriples();
        if (targetCount - originalTargetCount != sourceCount) {
            String reason = "Please clear the target store and try again.  Consider increasing the step size and overlap.";
            this.cloneFailed(reason, targetCount - originalTargetCount, nExpected);
        }
        LOGGER.info("Clone successful! Cloned " + Integer.toString(targetCount - originalTargetCount) + " of " + Integer.toString(sourceCount));
    }

    public void performCloneStep(TripleStoreClientInterface source, TripleStoreClientInterface target, String constructQuery) {
        Model model = source.executeConstruct(constructQuery);
        target.executeUpdate(this.getSparqlInsert(model));
    }

    public void adjustOverlap(int targetCount, int nExpected, int attempts) {
        this.overlap += Math.max((int)(0.1 * (double)this.stepSize), nExpected - targetCount);
        LOGGER.info("Cloned count: " + Integer.toString(targetCount) + " does not match expected count " + Integer.toString(nExpected) + ". Increasing overlap to " + Integer.toString(this.overlap) + " and retrying.");
        if (attempts >= 5 || this.overlap >= this.stepSize) {
            String reason = Integer.toString(attempts) + " attempt(s) to increase overlap...\n Please clear the target store! Consider increasing step size.";
            this.cloneFailed(reason, targetCount, nExpected);
        }
    }

    public void cloneFailed(String reason, int targetCount, int nExpected) {
        String errorMessage = "Cloning tool: clone failed...\nReason: " + reason + "\nParameters: stepSize=" + Integer.toString(this.stepSize) + ", overlap=" + Integer.toString(this.overlap) + ", target count=" + Integer.toString(targetCount) + ", expected count=" + Integer.toString(nExpected);
        LOGGER.error(errorMessage);
        throw new JPSRuntimeException(errorMessage);
    }

    private UpdateRequest getSparqlInsert(Model model) {
        UpdateBuilder builder = new UpdateBuilder().addInsert(model);
        return builder.buildRequest();
    }

    public String getSparqlConstructNoBlanks(int stepsize, int offset) {
        return "CONSTRUCT {?s ?p ?o}\nWHERE {?s ?p ?o.FILTER(  !isblank(?s) && !isblank(?o) )}\nLIMIT " + Integer.toString(stepsize) + " OFFSET " + Integer.toString(offset);
    }

    public String getSparqlConstructBlanks() {
        return "CONSTRUCT {?s ?p ?o}\nWHERE {?s ?p ?o.FILTER(  isblank(?s) || isblank(?o) )}";
    }

    public Integer countBlanks(TripleStoreClientInterface storeClient) {
        String query = "SELECT (COUNT(*) AS ?triples)WHERE { ?s ?p ?o.FILTER(  isblank(?s) || isblank(?o) )}";
        JSONArray results = storeClient.executeQuery(query);
        int triples = Integer.parseInt(results.getJSONObject(0).get("triples").toString());
        return triples;
    }
}

