/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.slurm.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import uk.ac.cam.cares.jps.base.slurm.job.Status;
import uk.ac.cam.cares.jps.base.slurm.job.Utils;

public class JobStatistics {
    private int jobsSubmitted = 0;
    private int jobsCompleted = 0;
    private int jobsCompleting = 0;
    private int jobsFailed = 0;
    private int jobsPending = 0;
    private int jobsPreempted = 0;
    private int jobsRunning = 0;
    private int jobsSuspended = 0;
    private int jobsStopped = 0;
    private int jobsErrorTerminated = 0;
    private int jobsNotStarted = 0;
    private File jobSpace;

    public JobStatistics(File jobSpace) throws IOException {
        File[] jobs;
        this.jobSpace = jobSpace;
        for (File job : jobs = jobSpace.listFiles()) {
            this.calculateAllStatistics(job);
        }
        this.setJobsSubmitted(this.getJobsCompleted() + this.getJobsCompleting() + this.getJobsFailed() + this.getJobsPending() + this.getJobsPreempted() + this.getJobsRunning() + this.getJobsSuspended() + this.getJobsStopped() + this.getJobsErrorTerminated() + this.getJobsNotStarted());
    }

    private void calculateAllStatistics(File job) throws IOException {
        if (job != null && job.isDirectory()) {
            File[] jobFiles;
            for (File jobFile : jobFiles = job.listFiles()) {
                this.calculateStatistics(jobFile);
            }
        }
    }

    private void calculateStatistics(File jobFile) throws IOException {
        if (!jobFile.isDirectory() && jobFile.getAbsolutePath().endsWith(Status.STATUS_FILE.getName())) {
            this.calculateStatistics(jobFile.getAbsolutePath());
        }
    }

    public void calculateStatistics(String statusFilePath) throws IOException {
        String line;
        BufferedReader statusFile = Utils.openSourceFile(statusFilePath);
        while ((line = statusFile.readLine()) != null) {
            if (!line.trim().startsWith(Status.ATTRIBUTE_JOB_STATUS.getName())) continue;
            if (line.contains(Status.STATUS_JOB_COMPLETED.getName())) {
                this.setJobsCompleted(this.getJobsCompleted() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_COMPLETING.getName())) {
                this.setJobsCompleting(this.getJobsCompleting() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_FAILED.getName())) {
                this.setJobsFailed(this.getJobsFailed() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_PENDING.getName())) {
                this.setJobsPending(this.getJobsPending() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_PREEMPTED.getName())) {
                this.setJobsPreempted(this.getJobsPreempted() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_RUNNING.getName())) {
                this.setJobsRunning(this.getJobsRunning() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_SUSPENDED.getName())) {
                this.setJobsSuspended(this.getJobsSuspended() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_STOPPED.getName())) {
                this.setJobsStopped(this.getJobsStopped() + 1);
                continue;
            }
            if (line.contains(Status.STATUS_JOB_ERROR_TERMINATED.getName())) {
                this.setJobsErrorTerminated(this.getJobsErrorTerminated() + 1);
                continue;
            }
            if (!line.contains(Status.STATUS_JOB_NOT_STARTED.getName())) continue;
            this.setJobsNotStarted(this.getJobsNotStarted() + 1);
        }
        statusFile.close();
    }

    public void setJobSpace(File jobSpace) {
        this.jobSpace = jobSpace;
    }

    public int getJobsSubmitted() {
        return this.jobsSubmitted;
    }

    public void setJobsSubmitted(int jobsSubmitted) {
        this.jobsSubmitted = jobsSubmitted;
    }

    public int getJobsRunning() {
        return this.jobsRunning;
    }

    public void setJobsRunning(int jobsRunning) {
        this.jobsRunning = jobsRunning;
    }

    public int getJobsCompleted() {
        return this.jobsCompleted;
    }

    public void setJobsCompleted(int jobsCompleted) {
        this.jobsCompleted = jobsCompleted;
    }

    public int getJobsErrorTerminated() {
        return this.jobsErrorTerminated;
    }

    public void setJobsErrorTerminated(int jobsErrorTerminated) {
        this.jobsErrorTerminated = jobsErrorTerminated;
    }

    public int getJobsNotStarted() {
        return this.jobsNotStarted;
    }

    public void setJobsNotStarted(int jobsNotStarted) {
        this.jobsNotStarted = jobsNotStarted;
    }

    public int getJobsCompleting() {
        return this.jobsCompleting;
    }

    public void setJobsCompleting(int jobsCompleting) {
        this.jobsCompleting = jobsCompleting;
    }

    public int getJobsFailed() {
        return this.jobsFailed;
    }

    public void setJobsFailed(int jobsFailed) {
        this.jobsFailed = jobsFailed;
    }

    public int getJobsPending() {
        return this.jobsPending;
    }

    public void setJobsPending(int jobsPending) {
        this.jobsPending = jobsPending;
    }

    public int getJobsPreempted() {
        return this.jobsPreempted;
    }

    public void setJobsPreempted(int jobsPreempted) {
        this.jobsPreempted = jobsPreempted;
    }

    public int getJobsSuspended() {
        return this.jobsSuspended;
    }

    public void setJobsSuspended(int jobsSuspended) {
        this.jobsSuspended = jobsSuspended;
    }

    public int getJobsStopped() {
        return this.jobsStopped;
    }

    public void setJobsStopped(int jobsStopped) {
        this.jobsStopped = jobsStopped;
    }

    public String getHTMLHeader() {
        String htmlHead = "<!DOCTYPE html>";
        htmlHead = htmlHead.concat("<html>");
        htmlHead = htmlHead.concat("<head>");
        htmlHead = htmlHead.concat("<style>");
        htmlHead = htmlHead.concat("table, th, td {");
        htmlHead = htmlHead.concat("border: 1px solid black;");
        htmlHead = htmlHead.concat("border-collapse: collapse;");
        htmlHead = htmlHead.concat("}");
        htmlHead = htmlHead.concat("th, td {");
        htmlHead = htmlHead.concat("padding: 15px;");
        htmlHead = htmlHead.concat("text-align: left;");
        htmlHead = htmlHead.concat("}");
        htmlHead = htmlHead.concat("table#t01 {");
        htmlHead = htmlHead.concat("width: 100%;");
        htmlHead = htmlHead.concat("background-color: #f1f1c1;");
        htmlHead = htmlHead.concat("}");
        htmlHead = htmlHead.concat("</style>");
        htmlHead = htmlHead.concat(this.getResources());
        htmlHead = htmlHead.concat("</head>");
        return htmlHead;
    }

    private String getResources() {
        String resourcePath = this.pathToResource();
        String headerResource = "<meta charset=\"UTF-8\">";
        headerResource = headerResource.concat("<script src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js\"></script>");
        headerResource = headerResource.concat(this.getLink("<link rel=\"stylesheet\" type=\"text/css\" href=\"", resourcePath, "css/static/group/bootstrap.min.css\">"));
        headerResource = headerResource.concat(this.getLink("<link rel=\"stylesheet\" type=\"text/css\" href=\"", resourcePath, "css/index.css\">"));
        headerResource = headerResource.concat(this.getLink("<link rel=\"icon\" href=\"", resourcePath, "css/static/group/favicon.ico\">"));
        headerResource = headerResource.concat(this.getLink("<link rel=\"stylesheet\" type=\"text/css\" href=\"", resourcePath, "css/static/group/dftagent.css\">"));
        headerResource = headerResource.concat("<title>J-Park Simulator</title>");
        return headerResource;
    }

    public String getBodydivStart() {
        String resourcePath = this.pathToResource();
        String startDiv = "<div class=\"jumbotron text-center\" id=\"topBanner\">";
        startDiv = startDiv.concat("<a id=\"cares-banner\" href=\"http://www.cares.cam.ac.uk\">");
        startDiv = startDiv.concat("<img id=\"care-banner-img\" src=\"");
        startDiv = startDiv.concat(resourcePath.concat("images/cam_lang_negativ1%20NEW_0.png\">"));
        startDiv = startDiv.concat("</a>");
        startDiv = startDiv.concat("<h1 id=\"title\">A JPS Agent</h1>");
        startDiv = startDiv.concat("<p id=\"description\">");
        startDiv = startDiv.concat("An agent developed for performing simulations on HPC servers to create a living, continuously self-improving and growing Knowledge Graph of species serving the need for thermochemical data across disciplines.");
        startDiv = startDiv.concat("</p>");
        startDiv = startDiv.concat("</div>");
        return startDiv;
    }

    private String pathToResource() {
        return "/KineticsAgent/assets/";
    }

    private String getLink(String link, String hrefStartPath, String hrefEndPath) {
        String linkResource = link;
        linkResource = linkResource.concat(hrefStartPath);
        linkResource = linkResource.concat(hrefEndPath);
        return linkResource;
    }

    public String getStatisticsTableHeader(String headerText, String statisticsProperty, String statisticsValue, String tableWidth) {
        String tableHeader = "<h2>" + headerText + "</h2><br>";
        tableHeader = tableHeader + "<table style=\"width:" + tableWidth + "\">";
        tableHeader = tableHeader + "<tr>";
        tableHeader = tableHeader + "<th>" + statisticsProperty + "</th>";
        tableHeader = tableHeader + "<th>" + statisticsValue + "</th>";
        tableHeader = tableHeader + "</tr>";
        return tableHeader;
    }

    public String getStatisticsTableRow(String property, String value) {
        String tableRow = "<tr>";
        tableRow = tableRow + "<td>" + property + "</td>";
        tableRow = tableRow + "<td>" + value + "</td>";
        tableRow = tableRow + "</tr>";
        tableRow = tableRow + "<tr>";
        return tableRow;
    }
}

