/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.router;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.router.AgentRouter;

public class AgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(AgentCaller.class);

    public String getWithJson(String agentID, JSONObject jsonParameters) {
        String agentUrl = this.getAgentUrl(agentID);
        try {
            LOGGER.info("Execute HTTP GET with JSON parameters.");
            HttpGet request = Http.get(agentUrl, MediaType.APPLICATION_JSON.type, jsonParameters);
            return Http.execute(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public String postWithJson(String agentID, JSONObject jsonParameters) {
        LOGGER.info("Execute HTTP POST with JSON parameters.");
        return this.post(agentID, jsonParameters.toString(), MediaType.APPLICATION_JSON.type, MediaType.APPLICATION_JSON.type);
    }

    public String post(String agentID, String body, String contentType, String accept) {
        String agentUrl = this.getAgentUrl(agentID);
        try {
            LOGGER.info("Execute HTTP POST.");
            HttpPost request = Http.post(agentUrl, body, contentType, accept, new Object[0]);
            return Http.execute(request);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public String getAgentUrl(String agentID) {
        return AgentRouter.getInstance().get(agentID);
    }
}

