/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.fed;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.query.JenaHelper;
import uk.ac.cam.cares.jps.base.query.JenaResultSetFormatter;
import uk.ac.cam.cares.jps.base.query.fed.SimpleMultiIndex;

public class ServiceDescriptionIndexer {
    static final Logger LOGGER = LogManager.getLogger(ServiceDescriptionIndexer.class);
    private static final String INDEX_NAME = "SCHEMA";
    private List<ServiceDescriptionSummary> summaries = new ArrayList<ServiceDescriptionSummary>();
    private SimpleMultiIndex<String, PostingsListElement> index = new SimpleMultiIndex();

    private Map<String, Set<PostingsListElement>> getSchemaIndex() {
        return this.index.getIndex(INDEX_NAME);
    }

    public Set<String> getKeys() {
        return this.getSchemaIndex().keySet();
    }

    public Set<PostingsListElement> getPostingsList(String key) {
        return this.index.getPostingsList(INDEX_NAME, key);
    }

    public List<ServiceDescriptionSummary> getSummaries() {
        return this.summaries;
    }

    private static Map<String, Long> getNumberOfTriples(OntModel model, String sparql, String type) {
        ResultSet result = JenaHelper.query(model, sparql);
        JSONObject joOrig = JenaResultSetFormatter.convertToSimplifiedList(result);
        JSONArray list = joOrig.getJSONArray("results");
        Iterator<Object> it = list.iterator();
        HashMap<String, Long> map = new HashMap<String, Long>();
        while (it.hasNext()) {
            JSONObject current = (JSONObject)it.next();
            map.put(current.getString(type), current.getLong("ntriples"));
        }
        return map;
    }

    public static Map<String, Long> getNumberOfClassTriples(OntModel model) {
        String sparql = "SELECT * WHERE { \r\n\t?s <http://rdfs.org/ns/void#class> ?class . \r\n\t?s <http://rdfs.org/ns/void#triples> ?ntriples . \r\n}";
        return ServiceDescriptionIndexer.getNumberOfTriples(model, sparql, "class");
    }

    public static Map<String, Long> getNumberOfPropertyTriples(OntModel model) {
        String sparql = "SELECT * WHERE { \r\n\t?s <http://rdfs.org/ns/void#property> ?property . \r\n\t?s <http://rdfs.org/ns/void#triples> ?ntriples . \r\n}";
        return ServiceDescriptionIndexer.getNumberOfTriples(model, sparql, "property");
    }

    public void addServiceDescription(String ... dirFileorUrl) {
        for (String path : dirFileorUrl) {
            File file = new File(path);
            if (file.isDirectory()) {
                Collection<File> files = FileUtils.listFiles(file, null, true);
                for (File f : files) {
                    this.add(f.getAbsolutePath());
                }
                continue;
            }
            this.add(path);
        }
    }

    public static String queryServiceDescription(String url) {
        String accept = "application/rdf+xml";
        HttpGet request = Http.get(url, accept, new Object[0]);
        return Http.execute(request);
    }

    private void add(String path) {
        PostingsListElement elem;
        OntModel model = null;
        if (path.startsWith("http")) {
            String descr = ServiceDescriptionIndexer.queryServiceDescription(path);
            model = JenaHelper.createModel();
            JenaHelper.readFromString(descr, model);
        } else {
            model = JenaHelper.createModel(path);
        }
        ServiceDescriptionSummary summary = this.createSummary();
        this.fillSummary(summary, path, model);
        Map<String, Long> map = ServiceDescriptionIndexer.getNumberOfClassTriples(model);
        for (String key : map.keySet()) {
            elem = new PostingsListElement(summary.id, map.get(key));
            this.index.add(INDEX_NAME, key, elem);
        }
        map = ServiceDescriptionIndexer.getNumberOfPropertyTriples(model);
        for (String key : map.keySet()) {
            elem = new PostingsListElement(summary.id, map.get(key));
            this.index.add(INDEX_NAME, key, elem);
        }
        LOGGER.debug("Added service description=" + summary + " from path=" + path);
    }

    public void fillSummary(ServiceDescriptionSummary summary, String path, OntModel model) {
        summary.path = path;
        String sparql = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \r\nPREFIX sd: <http://www.w3.org/ns/sparql-service-description#>\r\nPREFIX void: <http://rdfs.org/ns/void#>\r\nSELECT * WHERE {\r\n  ?dataset rdf:type sd:Dataset .\r\n  ?dataset sd:defaultGraph ?graph .\r\n  ?graph void:triples ?ntriples .\r\n  ?graph void:entities ?nentities .\r\n  ?graph void:properties ?nproperties .\r\n  ?graph void:classes ?nclasses .\r\n}";
        ResultSet result = JenaHelper.query(model, sparql);
        JSONObject jo = JenaResultSetFormatter.convertToSimplifiedList(result);
        JSONArray list = jo.getJSONArray("results");
        Iterator<Object> it = list.iterator();
        JSONObject current = (JSONObject)it.next();
        if (it.hasNext()) {
            throw new JPSRuntimeException("The query result set contains more than one row, service description=" + path);
        }
        Function<String, Long> get = s -> {
            if (current.has((String)s)) {
                return current.getLong((String)s);
            }
            return null;
        };
        summary.ntriples = get.apply("ntriples");
        summary.nentities = get.apply("nentities");
        summary.nproperties = get.apply("nproperties");
        summary.nclasses = get.apply("nclasses");
        sparql = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \r\nPREFIX sd: <http://www.w3.org/ns/sparql-service-description#>\r\nPREFIX void: <http://rdfs.org/ns/void#>\r\nSELECT * WHERE {\r\n  ?service sd:endpoint ?endpoint .\r\n}";
        result = JenaHelper.query(model, sparql);
        QuerySolution s2 = result.nextSolution();
        String endpointURL = s2.get("endpoint").asResource().getURI();
        if (endpointURL.startsWith("http://localhost:9999")) {
            int i = endpointURL.indexOf("namespace/");
            String namespace = endpointURL.substring(i, endpointURL.length());
            summary.endpointURL = "http://www.theworldavatar.com:83/citieskg/" + namespace;
            LOGGER.info("changed endpoint URL from " + endpointURL + " to " + summary.endpointURL);
        } else {
            summary.endpointURL = endpointURL;
        }
    }

    public synchronized ServiceDescriptionSummary createSummary() {
        int id = this.summaries.size();
        ServiceDescriptionSummary summary = new ServiceDescriptionSummary(id);
        this.summaries.add(summary);
        return summary;
    }

    public List<ServiceDescriptionSummary> conjunctiveQuery(List<String> keywords) {
        ArrayList<ServiceDescriptionSummary> result = new ArrayList<ServiceDescriptionSummary>();
        HashMap<Integer, Integer> mapId2Count = new HashMap<Integer, Integer>();
        for (String key : keywords) {
            Set<PostingsListElement> set = this.index.getPostingsList(INDEX_NAME, key);
            if (set == null) {
                LOGGER.warn("no postings list was found for key=" + key);
                break;
            }
            for (PostingsListElement elem : set) {
                int id = elem.id;
                if (mapId2Count.containsKey(id)) {
                    int count = (Integer)mapId2Count.get(id) + 1;
                    mapId2Count.put(id, count);
                    continue;
                }
                mapId2Count.put(id, 1);
            }
        }
        for (Integer id : mapId2Count.keySet()) {
            int count = (Integer)mapId2Count.get(id);
            if (count != keywords.size()) continue;
            ServiceDescriptionSummary summary = this.getSummaries().get(id);
            result.add(summary);
        }
        return result;
    }

    public List<String> getEndpointUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        for (ServiceDescriptionSummary summary : this.getSummaries()) {
            urls.add(summary.endpointURL);
        }
        return urls;
    }

    public class PostingsListElement
    implements Comparable<PostingsListElement> {
        public Integer id = null;
        public Long tripleNumber = null;

        public PostingsListElement(Integer id, Long number) {
            this.id = id;
            this.tripleNumber = number;
        }

        @Override
        public int compareTo(PostingsListElement element) {
            return this.id.compareTo(element.id);
        }
    }

    public class ServiceDescriptionSummary {
        public Integer id = null;
        public String path = null;
        public String endpointURL = null;
        public Long ntriples = null;
        public Long nentities = null;
        public Long nproperties = null;
        public Long nclasses = null;

        public ServiceDescriptionSummary(int id) {
            this.id = id;
        }

        public String toString() {
            return "Summary[#t=" + this.ntriples + ",#e=" + this.nentities + ",#c=" + this.nclasses + ",#p=" + this.nproperties + ",url=" + this.endpointURL + "]";
        }
    }
}

