/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;

public class JenaResultSetFormatter {
    public static String convertToCSV(ResultSet resultSet) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsCSV((OutputStream)os, resultSet);
        return new String(os.toByteArray());
    }

    public static String convertToJSONW3CStandard(ResultSet resultSet) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ResultSetFormatter.outputAsJSON((OutputStream)os, resultSet);
        return new String(os.toByteArray());
    }

    public static JSONObject convertToSimplifiedList(ResultSet resultSet) {
        String json = JenaResultSetFormatter.convertToJSONW3CStandard(resultSet);
        return JenaResultSetFormatter.convertToSimplifiedList(json);
    }

    public static JSONObject convertToSimplifiedList(String resultJSONW3CStandard) {
        JSONArray joarray = JenaResultSetFormatter.convertToSimplifiedJsonArray(resultJSONW3CStandard);
        JSONObject result = new JSONObject();
        result.put("results", joarray);
        return result;
    }

    public static JSONArray convertToSimplifiedJsonArray(String resultJSONW3CStandard) {
        JSONArray joarray = new JSONArray();
        JSONObject jo = new JSONObject(resultJSONW3CStandard);
        JSONArray array = jo.getJSONObject("results").getJSONArray("bindings");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject row = array.getJSONObject(i);
            JSONObject simplifiedRow = new JSONObject();
            for (String current : row.keySet()) {
                String value = row.getJSONObject(current).getString("value");
                simplifiedRow.put(current, value);
            }
            joarray.put(simplifiedRow);
        }
        return joarray;
    }

    public static List<String[]> convertToListofStringArrays(String resultJSONW3CStandard, String ... keys) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        JSONObject jo = JenaResultSetFormatter.convertToSimplifiedList(resultJSONW3CStandard);
        JSONArray ja = jo.getJSONArray("results");
        for (int i = 0; i < ja.length(); ++i) {
            String[] array = new String[keys.length];
            JSONObject row = ja.getJSONObject(i);
            for (int j = 0; j < keys.length; ++j) {
                String value;
                array[j] = value = row.optString(keys[j], null);
            }
            result.add(array);
        }
        return result;
    }

    public static List<String[]> convertToListofStringArraysWithKeys(String resultJSONW3CStandard, String[] keys) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        JSONArray ja = new JSONArray(new JSONObject(resultJSONW3CStandard).getString("results"));
        for (int i = 0; i < ja.length(); ++i) {
            String[] array = new String[keys.length];
            JSONObject row = ja.getJSONObject(i);
            for (int j = 0; j < keys.length; ++j) {
                String value;
                array[j] = value = row.optString(keys[j], null);
            }
            result.add(array);
        }
        return result;
    }

    public static String[] getKeys(String resultJSONW3CStandard) {
        JSONObject jo = new JSONObject(resultJSONW3CStandard);
        JSONArray ja = jo.getJSONObject("head").getJSONArray("vars");
        String[] result = new String[ja.length()];
        for (int i = 0; i < ja.length(); ++i) {
            result[i] = ja.getString(i);
        }
        return result;
    }

    public String createJSONfromCSV(List<String[]> csvgroup, String[] headertype) {
        JSONStringer jsonStringer = new JSONStringer();
        jsonStringer.object().key("head").object().key("vars").array();
        for (int x = 0; x < csvgroup.get(0).length; ++x) {
            jsonStringer.value(csvgroup.get(0)[x]);
        }
        jsonStringer.endArray().endObject().key("results").object().key("bindings").array();
        for (int y = 1; y < csvgroup.size(); ++y) {
            jsonStringer.object().key(csvgroup.get(0)[0]).object().key("type").value(headertype[0]).key("value").value(csvgroup.get(y)[0]);
            for (int h = 1; h < csvgroup.get(0).length; ++h) {
                jsonStringer.endObject().key(csvgroup.get(0)[h]).object().key("type").value(headertype[h]).key("value").value(csvgroup.get(y)[h]);
            }
            jsonStringer.endObject().endObject();
        }
        jsonStringer.endArray().endObject().endObject();
        return jsonStringer.toString();
    }
}

