/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.config;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;

public class KeyValueMap {
    private static final Logger LOGGER = LogManager.getLogger(KeyValueMap.class);
    private static KeyValueMap instance = null;
    public static Map<String, String> map;
    private static String propertiesFile;
    private static String testPropertiesFile;
    private static String FILE_DOES_NOT_EXIST;
    private static String KEY_DOES_NOT_EXIST;
    private static String NO_NULL_KEY_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyValueMap getInstance() {
        if (instance != null) return instance;
        Class<KeyValueMap> clazz = KeyValueMap.class;
        synchronized (KeyValueMap.class) {
            if (instance != null) return instance;
            instance = new KeyValueMap();
            instance.init(instance.runningForTest(propertiesFile));
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private KeyValueMap() {
        map = new ConcurrentHashMap<String, String>();
    }

    public String get(String key) {
        String value = "";
        try {
            value = map.get(key);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(NO_NULL_KEY_VALUE);
        }
        if (value == null) {
            value = KEY_DOES_NOT_EXIST;
        }
        return value;
    }

    public String put(String key, String value) {
        String oldValue = "";
        try {
            oldValue = map.put(key, value);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(NO_NULL_KEY_VALUE);
        }
        return oldValue;
    }

    private void init(Boolean runningForTest) {
        if (runningForTest.booleanValue()) {
            this.loadProperties(testPropertiesFile);
        } else {
            this.loadProperties(propertiesFile);
        }
    }

    private Boolean runningForTest(String propertiesFile) {
        Boolean runningForTest = false;
        try {
            this.loadProperties(propertiesFile);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(FILE_DOES_NOT_EXIST);
        }
        try {
            runningForTest = Boolean.valueOf(map.get("test"));
        }
        catch (Exception e) {
            throw new JPSRuntimeException(KEY_DOES_NOT_EXIST);
        }
        return runningForTest;
    }

    private void loadProperties(String propertiesFile) {
        LOGGER.info("loading key-value pairs from " + propertiesFile);
        try (InputStream fin = KeyValueMap.class.getResourceAsStream(propertiesFile);){
            Properties props = new Properties();
            props.load(fin);
            Set<String> keys = props.stringPropertyNames();
            for (String key : keys) {
                String value = props.getProperty(key);
                this.put(key, value);
                LOGGER.info(key + " = " + value);
            }
        }
        catch (Exception e) {
            throw new JPSRuntimeException(FILE_DOES_NOT_EXIST);
        }
    }

    public static String getProperty(String propertiesFile, String key) {
        String value;
        Properties props = new Properties();
        try (InputStream fin = KeyValueMap.class.getResourceAsStream(propertiesFile);){
            props.load(fin);
        }
        catch (Exception e) {
            LOGGER.info("properties was not loaded ");
            throw new JPSRuntimeException(FILE_DOES_NOT_EXIST);
        }
        try {
            value = props.getProperty(key);
        }
        catch (Exception e) {
            throw new JPSRuntimeException(NO_NULL_KEY_VALUE);
        }
        if (value == null) {
            value = KEY_DOES_NOT_EXIST;
        }
        return value;
    }

    static {
        propertiesFile = "/jps.properties";
        testPropertiesFile = "/jpstest.properties";
        FILE_DOES_NOT_EXIST = "Properties file does not exist.";
        KEY_DOES_NOT_EXIST = "No such key in properties file.";
        NO_NULL_KEY_VALUE = "Null keys and values are not allowed.";
    }
}

