/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElementList;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.xml.sax.Attributes;

class StartRDF
extends AbstractState
implements State {
    StartRDF(RDFParser parser) {
        super(parser);
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) {
        this.parser.verify(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceIRI) || !"RDF".equals(localName), "Expecting rdf:RDF element.");
        String value = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (value == null) {
            LOGGER.info("Notice: root element does not have an xml:base. Relative IRIs will be resolved against {}", (Object)this.parser.getBaseIRI());
        }
        this.parser.getRDFConsumer().logicalURI(this.parser.getBaseIRI());
        this.parser.pushState(new NodeElementList(this.parser));
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.parser.verify(this.notBlank(data, start, length), "Expecting rdf:rdf element instead of character content.");
    }
}

