/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ResourceOrLiteralElement
extends AbstractState
implements State {
    protected final NodeElement nodeElement;
    @Nullable
    protected String propertyIRI;
    @Nullable
    protected String reificationID;
    @Nullable
    protected String datatype;
    @Nullable
    protected StringBuilder text;
    @Nullable
    protected NodeElement innerNode;

    ResourceOrLiteralElement(NodeElement nodeElement, RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    protected String propertyIRI() {
        return (String)OWLAPIPreconditions.verifyNotNull((Object)this.propertyIRI);
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.text == null) {
            this.propertyIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
            this.reificationID = this.nodeElement.getReificationID(atts);
            this.datatype = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            this.text = new StringBuilder();
        } else {
            this.parser.verify(this.notBlank((StringBuilder)OWLAPIPreconditions.verifyNotNull((Object)this.text)), "Text was seen and new node is started.");
            this.parser.verify(this.datatype != null, "rdf:datatype specified on a node with resource value.");
            this.innerNode = new NodeElement(this.parser);
            this.parser.pushState(this.innerNode);
            ((State)OWLAPIPreconditions.verifyNotNull((Object)this.parser.state)).startElement(namespaceIRI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        if (this.innerNode != null) {
            this.parser.statementWithResourceValue(this.nodeElement.subjectIRI(), this.propertyIRI(), ((NodeElement)OWLAPIPreconditions.verifyNotNull((Object)this.innerNode)).subjectIRI(), this.reificationID);
        } else {
            this.parser.statementWithLiteralValue(this.nodeElement.subjectIRI(), this.propertyIRI(), ((StringBuilder)OWLAPIPreconditions.verifyNotNull((Object)this.text)).toString(), this.datatype, this.reificationID);
        }
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        if (this.innerNode != null) {
            this.parser.verify(this.notBlank(data, start, length), "Cannot answer characters when object properties are expected.");
        } else {
            ((StringBuilder)OWLAPIPreconditions.verifyNotNull((Object)this.text)).append(data, start, length);
        }
    }
}

