/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.factplusplusad;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.factplusplusad.SigAccessor;
import uk.ac.manchester.cs.factplusplusad.Signature;
import uk.ac.manchester.cs.factplusplusad.TopEquivalenceEvaluator;

class BotEquivalenceEvaluator
extends SigAccessor
implements OWLObjectVisitor {
    boolean isBotEq = false;
    TopEquivalenceEvaluator topEval;

    public BotEquivalenceEvaluator(Signature s) {
        super(s);
    }

    boolean isTopEquivalent(OWLObject expr) {
        return this.topEval.isTopEquivalent(expr);
    }

    private boolean isBotDistinct(OWLObject c) {
        if (this.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype;
    }

    private boolean isCardLargerThan(OWLObject c, int n) {
        OWLDatatype dt;
        if (n == 0) {
            return this.isBotDistinct(c);
        }
        if (c instanceof OWLDataRange && this.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype && (OWL2Datatype.XSD_STRING.matches((OWLEntity)(dt = ((OWLDatatype)c).asOWLDatatype())) || OWL2Datatype.XSD_DATE_TIME.matches((OWLEntity)dt) || OWL2Datatype.XSD_DATE_TIME_STAMP.matches((OWLEntity)dt));
    }

    private boolean isMaxBotEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return this.isBotEquivalent((OWLObject)r) && this.isCardLargerThan((OWLObject)c, n);
    }

    private boolean isMinBotEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return n > 0 && (this.isBotEquivalent((OWLObject)r) || this.isBotEquivalent((OWLObject)c));
    }

    void setTopEval(TopEquivalenceEvaluator eval) {
        this.topEval = eval;
    }

    boolean isBotEquivalent(OWLObject expr) {
        if (expr.isBottomEntity()) {
            return true;
        }
        if (expr.isTopEntity()) {
            return false;
        }
        expr.accept((OWLObjectVisitor)this);
        return this.isBotEq;
    }

    public void visit(OWLClass expr) {
        this.isBotEq = !this.topCLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLObjectComplementOf expr) {
        this.isBotEq = this.isTopEquivalent((OWLObject)expr.getOperand());
    }

    public void visit(OWLObjectIntersectionOf expr) {
        this.isBotEq = expr.operands().anyMatch(this::isBotEquivalent);
    }

    public void visit(OWLObjectUnionOf expr) {
        this.isBotEq = !expr.operands().anyMatch(p -> !this.isBotEquivalent((OWLObject)p));
    }

    public void visit(OWLObjectOneOf expr) {
        this.isBotEq = expr.individuals().count() == 0L;
    }

    public void visit(OWLObjectHasSelf expr) {
        this.isBotEq = this.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectHasValue expr) {
        this.isBotEq = this.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom expr) {
        this.isBotEq = this.isMinBotEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom expr) {
        this.isBotEq = this.isTopEquivalent((OWLObject)expr.getProperty()) && this.isBotEquivalent(expr.getFiller());
    }

    public void visit(OWLObjectMinCardinality expr) {
        this.isBotEq = this.isMinBotEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectMaxCardinality expr) {
        this.isBotEq = this.isMaxBotEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectExactCardinality expr) {
        int n = expr.getCardinality();
        this.isBotEq = this.isMinBotEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) || this.isMaxBotEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataHasValue expr) {
        this.isBotEq = this.isBotEquivalent((OWLObject)expr.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom expr) {
        this.isBotEq = this.isMinBotEquivalent(1, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataAllValuesFrom expr) {
        this.isBotEq = this.isTopEquivalent((OWLObject)expr.getProperty()) && !this.isTopEquivalent(expr.getFiller());
    }

    public void visit(OWLDataMinCardinality expr) {
        this.isBotEq = this.isMinBotEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataMaxCardinality expr) {
        this.isBotEq = this.isMaxBotEquivalent(expr.getCardinality(), (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLDataExactCardinality expr) {
        int n = expr.getCardinality();
        this.isBotEq = this.isMinBotEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller()) || this.isMaxBotEquivalent(n, (OWLPropertyExpression)expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    public void visit(OWLObjectProperty expr) {
        this.isBotEq = !this.topRLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLObjectInverseOf expr) {
        this.isBotEq = this.isBotEquivalent((OWLObject)expr.getInverseProperty());
    }

    public void visit(OWLSubPropertyChainOfAxiom expr) {
        this.isBotEq = true;
        for (OWLObjectPropertyExpression p : expr.getPropertyChain()) {
            if (!this.isBotEquivalent((OWLObject)p)) continue;
            return;
        }
        this.isBotEq = false;
    }

    public void visit(OWLDataProperty expr) {
        if (expr.isTopEntity()) {
            this.isBotEq = false;
            return;
        }
        if (expr.isBottomEntity()) {
            this.isBotEq = true;
            return;
        }
        this.isBotEq = !this.topRLocal() && this.nc((OWLEntity)expr);
    }

    public void visit(OWLDatatype node) {
        this.isBotEq = node.isBottomEntity();
    }

    public void visit(OWLLiteral node) {
        this.isBotEq = false;
    }

    public void visit(OWLDatatypeRestriction o) {
        this.isBotEq = false;
    }

    public void visit(OWLDataComplementOf node) {
        this.isBotEq = this.isTopEquivalent((OWLObject)node.getDataRange());
    }

    public void visit(OWLDataOneOf node) {
        this.isBotEq = node.values().count() == 0L;
    }

    public void visit(OWLDataIntersectionOf expr) {
        if (expr.operands().anyMatch(this::isBotEquivalent)) {
            return;
        }
        this.isBotEq = false;
    }

    public void visit(OWLDataUnionOf expr) {
        if (expr.operands().anyMatch(p -> !this.isBotEquivalent((OWLObject)p))) {
            return;
        }
        this.isBotEq = true;
    }
}

