/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.AutoCloseHttpClient;
import com.bigdata.rdf.sail.webapp.client.IHttpClientFactory;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class DefaultHttpClientFactory
implements IHttpClientFactory {
    private static final Logger log = Logger.getLogger(DefaultHttpClientFactory.class);

    @Override
    public HttpClient newInstance() {
        String sslKeystorePath = System.getProperty(Options.SSL_KEYSTORE_PATH, Options.DEFAULT_SSL_KEYSTORE_PATH);
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.SSL_KEYSTORE_PATH + "=" + sslKeystorePath));
        }
        SslContextFactory sslFactory = sslKeystorePath == null ? new SslContextFactory(true) : new SslContextFactory(sslKeystorePath);
        AutoCloseHttpClient cm = new AutoCloseHttpClient(sslFactory);
        try {
            boolean followRedirects = Boolean.valueOf(System.getProperty(Options.FOLLOW_REDIRECTS, "true"));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.FOLLOW_REDIRECTS + "=" + followRedirects));
            }
            if (followRedirects) {
                cm.setFollowRedirects(true);
            }
            int bufferSize = Integer.valueOf(System.getProperty(Options.REQUEST_BUFFER_SIZE, Integer.toString(16384)));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.REQUEST_BUFFER_SIZE + "=" + bufferSize));
            }
            cm.setRequestBufferSize(bufferSize);
            bufferSize = Integer.parseInt(System.getProperty(Options.RESPONSE_BUFFER_SIZE, Integer.toString(16384)));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.RESPONSE_BUFFER_SIZE + "=" + bufferSize));
            }
            cm.setResponseBufferSize(bufferSize);
            cm.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start HttpClient", e);
        }
        return cm;
    }

    public static interface Options {
        public static final String SSL_KEYSTORE_PATH = DefaultHttpClientFactory.class.getName() + ".SSLKeystorePath";
        public static final String DEFAULT_SSL_KEYSTORE_PATH = null;
        public static final String FOLLOW_REDIRECTS = DefaultHttpClientFactory.class.getName() + ".followRedirects";
        public static final String DEFAULT_FOLLOW_REDIRECTS = "true";
        public static final String RESPONSE_BUFFER_SIZE = DefaultHttpClientFactory.class.getName() + ".responseBufferSize";
        public static final int DEFAULT_RESPONSE_BUFFER_SIZE = 16384;
        public static final String REQUEST_BUFFER_SIZE = DefaultHttpClientFactory.class.getName() + ".requestBufferSize";
        public static final int DEFAULT_REQUEST_BUFFER_SIZE = 16384;
    }
}

