/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.UUID;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;

public class BigdataSailRemoteRepository
implements Repository {
    private volatile boolean open = true;
    private final RemoteRepositoryManager our_mgr;
    private final RemoteRepository remoteRepository;
    private final ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    @Deprecated
    public BigdataSailRemoteRepository(String sparqlEndpointURL) {
        if (sparqlEndpointURL == null) {
            throw new IllegalArgumentException();
        }
        this.our_mgr = new RemoteRepositoryManager(sparqlEndpointURL, false);
        this.remoteRepository = this.our_mgr.getRepositoryForURL(sparqlEndpointURL);
    }

    public BigdataSailRemoteRepository(RemoteRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        this.our_mgr = null;
        this.remoteRepository = repo;
    }

    public synchronized void shutDown() throws RepositoryException {
        if (this.our_mgr != null) {
            try {
                this.our_mgr.close();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        this.open = false;
    }

    public BigdataSailRemoteRepositoryConnection getConnection() throws RepositoryException {
        return new BigdataSailRemoteRepositoryConnection(this);
    }

    public void initialize() throws RepositoryException {
        if (!this.open) {
            throw new RepositoryException("Can not re-initialize");
        }
    }

    public boolean isInitialized() {
        return this.open;
    }

    public boolean isWritable() throws RepositoryException {
        return this.open;
    }

    public void setDataDir(File dataDir) {
        throw new UnsupportedOperationException();
    }

    public File getDataDir() {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void cancel(UUID queryId) throws Exception {
        this.our_mgr.cancel(queryId);
    }

    public Collection<RunningQuery> showQueries() throws Exception {
        return this.our_mgr.showQueries();
    }
}

