/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TaskCounters {
    public final AtomicLong taskSubmitCount = new AtomicLong();
    public final AtomicLong taskCompleteCount = new AtomicLong();
    public final AtomicLong taskFailCount = new AtomicLong();
    public final AtomicLong taskSuccessCount = new AtomicLong();
    public final AtomicLong lastArrivalNanoTime = new AtomicLong();
    public final AtomicLong interArrivalNanoTime = new AtomicLong();
    public final AtomicLong queueWaitingNanoTime = new AtomicLong();
    public final AtomicLong serviceNanoTime = new AtomicLong();
    public final AtomicLong checkpointNanoTime = new AtomicLong();
    public final AtomicLong queuingNanoTime = new AtomicLong();

    public String toString() {
        return this.getClass().getSimpleName() + "{#submit=" + this.taskSubmitCount + ",#complete=" + this.taskCompleteCount + ",#fail=" + this.taskFailCount + ",#success=" + this.taskSuccessCount + ",#queueWaitingTime=" + this.queueWaitingNanoTime + ",#serviceTime=" + this.serviceNanoTime + ",#queuingTime=" + this.queuingNanoTime + "}";
    }

    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("Task Submit Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TaskCounters.this.taskSubmitCount.get());
            }
        });
        counterSet.addCounter("Task Complete Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TaskCounters.this.taskCompleteCount.get());
            }
        });
        counterSet.addCounter("Task Failed Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TaskCounters.this.taskFailCount.get());
            }
        });
        counterSet.addCounter("Task Success Count", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TaskCounters.this.taskSuccessCount.get());
            }
        });
        counterSet.addCounter("Inter Arrival Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis(TaskCounters.this.interArrivalNanoTime.get()));
            }
        });
        counterSet.addCounter("Queue Waiting Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis(TaskCounters.this.queueWaitingNanoTime.get()));
            }
        });
        counterSet.addCounter("Service Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis(TaskCounters.this.serviceNanoTime.get()));
            }
        });
        counterSet.addCounter("Checkpoint Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis(TaskCounters.this.checkpointNanoTime.get()));
            }
        });
        counterSet.addCounter("Queuing Time", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(TimeUnit.NANOSECONDS.toMillis(TaskCounters.this.queuingNanoTime.get()));
            }
        });
        return counterSet;
    }
}

