/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.util.concurrent.Computable;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public abstract class Memoizer<A, V>
implements Computable<A, V> {
    protected final ConcurrentMap<A, Future<V>> cache = new ConcurrentHashMap<A, Future<V>>();
    private final Computable<A, V> c;

    public Memoizer(Computable<A, V> c) {
        this.c = c;
    }

    @Override
    public V compute(final A arg) throws InterruptedException {
        while (true) {
            Callable eval;
            FutureTask ft;
            FutureTask f = (FutureTask)this.cache.get(arg);
            boolean willRun = false;
            if (f == null && (f = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask(eval = new Callable<V>(){

                @Override
                public V call() throws InterruptedException {
                    return Memoizer.this.c.compute(arg);
                }
            }))) == null) {
                willRun = true;
                f = ft;
                ft.run();
            }
            try {
                return f.get();
            }
            catch (CancellationException e) {
                this.cache.remove(arg, f);
                continue;
            }
            catch (InterruptedException e) {
                InterruptedException e2 = new InterruptedException("Interrupted: willRun=" + willRun);
                e2.initCause(e);
                throw e2;
            }
            catch (ExecutionException e) {
                if (!willRun) {
                    this.cache.remove(arg, f);
                    continue;
                }
                throw Memoizer.launderThrowable(e.getCause());
            }
            break;
        }
    }

    private static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }
}

