/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util.concurrent;

import com.bigdata.util.concurrent.ExecutionExceptions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ExecutionHelper<T> {
    private final ExecutorService service;
    private final long timeout;
    private final TimeUnit unit;

    public ExecutionHelper(ExecutorService service) {
        this(service, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public ExecutionHelper(ExecutorService service, long timeout, TimeUnit unit) {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.service = service;
        this.timeout = timeout;
        this.unit = unit;
    }

    public void submitTasks(List<Callable<T>> tasks) throws InterruptedException, ExecutionExceptions {
        if (tasks.isEmpty()) {
            return;
        }
        boolean interrupted = false;
        LinkedList<ExecutionException> causes = null;
        try {
            List<Future<T>> futures = this.service.invokeAll(tasks, this.timeout, this.unit);
            for (Future<T> f : futures) {
                try {
                    f.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                catch (CancellationException ex) {
                    interrupted = true;
                }
                catch (ExecutionException ex) {
                    if (causes == null) {
                        causes = new LinkedList<ExecutionException>();
                    }
                    causes.add(ex);
                }
            }
        }
        catch (InterruptedException ex) {
            interrupted = true;
        }
        catch (RejectedExecutionException ex) {
            if (this.service.isShutdown()) {
                interrupted = true;
            }
            throw ex;
        }
        if (interrupted) {
            throw new InterruptedException("Terminated by interrupt");
        }
        if (causes != null) {
            throw new ExecutionExceptions(causes);
        }
    }
}

