/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ChunkedArraysIterator<E>
implements IChunkedOrderedIterator<E> {
    private boolean open = true;
    private ICloseableIterator<E[]> bufferIt;
    private E[] buffer;
    private final IKeyOrder<E> keyOrder;
    private int i = 0;

    public ChunkedArraysIterator(ICloseableIterator<E[]> a) {
        this(a, null);
    }

    public ChunkedArraysIterator(ICloseableIterator<E[]> a, IKeyOrder<E> keyOrder) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        this.bufferIt = a;
        this.keyOrder = keyOrder;
    }

    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        if (this.buffer == null) {
            return this.bufferIt.hasNext();
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.buffer == null) {
            this.buffer = (Object[])this.bufferIt.next();
        }
        E e = this.buffer[this.i++];
        if (this.i == this.buffer.length) {
            this.buffer = null;
            this.i = 0;
        }
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E[] nextChunk() {
        Object[] ret;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.buffer == null) {
            ret = this.buffer = (Object[])this.bufferIt.next();
        } else if (this.i == 0) {
            ret = this.buffer;
        } else {
            int remaining = this.buffer.length - this.i;
            ret = (Object[])Array.newInstance(this.buffer.getClass().getComponentType(), remaining);
            System.arraycopy(this.buffer, this.i, ret, 0, remaining);
        }
        this.buffer = null;
        this.i = 0;
        return ret;
    }

    @Override
    public IKeyOrder<E> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public E[] nextChunk(IKeyOrder<E> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        E[] chunk = this.nextChunk();
        if (!keyOrder.equals(this.getKeyOrder())) {
            Arrays.sort(chunk, 0, chunk.length, keyOrder.getComparator());
        }
        return chunk;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.bufferIt.close();
        this.open = false;
        this.buffer = null;
        this.i = 0;
    }
}

