/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.striterator;

import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public abstract class AbstractChunkedResolverator<E, F, S>
implements ICloseableIterator<F> {
    private static final Logger log = Logger.getLogger(AbstractChunkedResolverator.class);
    private final IChunkedOrderedIterator<E> src;
    protected final S state;
    private int lastIndex = -1;
    private F[] chunk = null;
    private volatile boolean open = true;
    private final BlockingBuffer<F[]> buffer;
    private IAsynchronousIterator<F[]> resolvedItr;

    public AbstractChunkedResolverator(S state, IChunkedOrderedIterator<E> src, BlockingBuffer<F[]> buffer) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.state = state;
        this.src = src;
        this.buffer = buffer;
    }

    public synchronized AbstractChunkedResolverator<E, F, S> start(ExecutorService service) {
        if (this.resolvedItr != null) {
            throw new IllegalStateException();
        }
        FutureTask<Long> ft = new FutureTask<Long>(new ChunkConsumerTask());
        this.buffer.setFuture(ft);
        this.resolvedItr = this.buffer.iterator();
        service.execute(ft);
        return this;
    }

    protected abstract F[] resolveChunk(E[] var1);

    public boolean hasNext() {
        if (this.open && this._hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    private boolean _hasNext() {
        if (this.resolvedItr == null) {
            throw new IllegalStateException();
        }
        if (this.lastIndex != -1 && this.chunk != null && this.lastIndex + 1 < this.chunk.length) {
            return true;
        }
        return this.resolvedItr.hasNext();
    }

    public F next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.lastIndex == -1 || this.chunk != null && this.lastIndex + 1 == this.chunk.length) {
            this.chunk = (Object[])this.resolvedItr.next();
            this.lastIndex = -1;
            if (log.isDebugEnabled()) {
                log.debug((Object)("nextChunk ready: size=" + this.chunk.length + ", chunk=" + Arrays.toString(this.chunk)));
            }
        }
        F f = this.chunk[++this.lastIndex];
        if (log.isDebugEnabled()) {
            log.debug((Object)("lastIndex=" + this.lastIndex + ", chunk.length=" + this.chunk.length + ", visting=" + f));
        }
        return f;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.open) {
            this.open = false;
            if (log.isInfoEnabled()) {
                log.info((Object)("lastIndex=" + this.lastIndex + ", chunkSize=" + (this.chunk != null ? "" + this.chunk.length : "N/A")));
            }
            this.src.close();
            this.buffer.close();
            this.resolvedItr.close();
            this.chunk = null;
        }
    }

    private class ChunkConsumerTask
    implements Callable<Long> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start");
                }
                long begin = System.currentTimeMillis();
                long nchunks = 0L;
                long nelements = 0L;
                while (AbstractChunkedResolverator.this.buffer.isOpen() && AbstractChunkedResolverator.this.src.hasNext()) {
                    F[] converted;
                    E[] chunk = AbstractChunkedResolverator.this.src.nextChunk();
                    if (!AbstractChunkedResolverator.this.buffer.isOpen()) break;
                    try {
                        converted = AbstractChunkedResolverator.this.resolveChunk(chunk);
                    }
                    catch (Throwable t) {
                        if (InnerCause.isInnerCause((Throwable)t, InterruptedException.class) || InnerCause.isInnerCause((Throwable)t, ClosedByInterruptException.class)) {
                            AbstractChunkedResolverator.this.buffer.close();
                            break;
                        }
                        throw new RuntimeException(t);
                    }
                    AbstractChunkedResolverator.this.buffer.add(converted);
                    ++nchunks;
                    nelements += (long)chunk.length;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("nchunks=" + nchunks + ", chunkSize=" + chunk.length));
                }
                long elapsed = System.currentTimeMillis() - begin;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Finished: nchunks=" + nchunks + ", nelements=" + nelements + ", elapsed=" + elapsed + "ms, sink.open=" + AbstractChunkedResolverator.this.buffer.isOpen()));
                }
                Long l = nelements;
                return l;
            }
            finally {
                try {
                    AbstractChunkedResolverator.this.src.close();
                }
                finally {
                    AbstractChunkedResolverator.this.buffer.close();
                }
            }
        }
    }
}

