/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.RelationSchema;
import com.bigdata.service.ndx.IClientIndex;
import com.bigdata.sparse.AtomicRowDelete;
import com.bigdata.sparse.AtomicRowFilter;
import com.bigdata.sparse.AtomicRowRead;
import com.bigdata.sparse.AtomicRowWriteRead;
import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.IPrecondition;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.NameChecker;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SingleColumnFilter;
import com.bigdata.sparse.TPS;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SparseRowStore
implements IRowStoreConstants {
    protected static final Logger log = Logger.getLogger(SparseRowStore.class);
    static final String UTF8 = "UTF-8";
    private final IIndex ndx;
    static final transient boolean schemaNameUnicodeClean = Boolean.valueOf(System.getProperty(Options.SCHEMA_NAME_UNICODE_CLEAN, "true"));
    static final transient boolean primaryKeyUnicodeClean = Boolean.valueOf(System.getProperty(Options.PRIMARY_KEY_UNICODE_CLEAN, "true"));

    public IIndex getIndex() {
        return this.ndx;
    }

    public SparseRowStore(IIndex ndx) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        this.ndx = ndx;
    }

    static final void assertArgs(Schema schema, Object primaryKey, long fromTime, long toTime) {
        if (schema == null) {
            throw new IllegalArgumentException("schema");
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException("primaryKey");
        }
        if (fromTime == Long.MIN_VALUE) {
            throw new IllegalArgumentException("fromTime MAY NOT be 'CURRENT_ROW'");
        }
        if (fromTime < 1L) {
            throw new IllegalArgumentException("fromTime less than MIN_TIMESTAMP");
        }
        if (toTime != Long.MIN_VALUE && fromTime >= toTime) {
            throw new IllegalArgumentException("from/to time out of order");
        }
    }

    static final void assertWriteTime(long writeTime) {
        if (writeTime == -1L) {
            return;
        }
        if (writeTime == -2L) {
            return;
        }
        if (writeTime < 1L) {
            throw new IllegalArgumentException();
        }
    }

    static final void assertPropertyNames(Map<String, Object> propertySet) {
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        for (String col : propertySet.keySet()) {
            NameChecker.assertColumnName(col);
        }
    }

    public Object get(Schema schema, Object primaryKey, String name) {
        TPS tps = (TPS)this.read(schema, primaryKey, 1L, Long.MIN_VALUE, new SingleColumnFilter(name));
        if (tps == null) {
            return null;
        }
        return tps.get(name).getValue();
    }

    public Map<String, Object> read(Schema schema, Object primaryKey) {
        TPS tps = (TPS)this.read(schema, primaryKey, 1L, Long.MIN_VALUE, null);
        if (tps == null) {
            return null;
        }
        return tps.asMap();
    }

    public Map<String, Object> read(Schema schema, Object primaryKey, INameFilter filter) {
        TPS tps = (TPS)this.read(schema, primaryKey, 1L, Long.MIN_VALUE, filter);
        if (tps == null) {
            return null;
        }
        return tps.asMap();
    }

    public ITPS read(Schema schema, Object primaryKey, long fromTime, long toTime, INameFilter filter) {
        SparseRowStore.assertArgs(schema, primaryKey, fromTime, toTime);
        if (log.isInfoEnabled()) {
            String ts = "N/A";
            if (this.getIndex() instanceof IClientIndex) {
                ts = TimestampUtility.toString(((IClientIndex)this.getIndex()).getTimestamp());
            } else if (this.getIndex() instanceof AbstractBTree) {
                ts = TimestampUtility.toString(((AbstractBTree)this.getIndex()).getLastCommitTime());
            }
            log.info((Object)("ts=" + ts + ", schema=" + schema.getName() + ", primaryKey=" + primaryKey + ", fromTime=" + fromTime + ", toTime=" + toTime + ", filter=" + (filter == null ? "N/A" : filter.getClass().getName())));
        }
        AtomicRowRead proc = new AtomicRowRead(schema, primaryKey, fromTime, toTime, filter);
        byte[] key = schema.fromKey(this.ndx.getIndexMetadata().getKeyBuilder(), primaryKey).getKey();
        return this.ndx.submit(key, proc);
    }

    public Map<String, Object> write(Schema schema, Map<String, Object> propertySet) {
        return this.write(schema, propertySet, -2L, null, null).asMap();
    }

    public Map<String, Object> write(Schema schema, Map<String, Object> propertySet, long writeTime) {
        return this.write(schema, propertySet, writeTime, null, null).asMap();
    }

    public TPS write(Schema schema, Map<String, Object> propertySet, long writeTime, INameFilter filter, IPrecondition precondition) {
        return this.write(schema, propertySet, 1L, Long.MIN_VALUE, writeTime, filter, precondition);
    }

    public TPS write(Schema schema, Map<String, Object> propertySet, long fromTime, long toTime, long writeTime, INameFilter filter, IPrecondition precondition) {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        Object primaryKey = propertySet.get(schema.getPrimaryKeyName());
        SparseRowStore.assertArgs(schema, primaryKey, fromTime, toTime);
        if (log.isInfoEnabled()) {
            log.info((Object)("schema=" + schema.getName() + ", primaryKey=" + primaryKey + ", timestamp=" + writeTime + ", filter=" + (filter == null ? "N/A" : filter.getClass().getName()) + ", precondition=" + (precondition == null ? "N/A" : precondition.getClass().getName())));
        }
        AtomicRowWriteRead proc = new AtomicRowWriteRead(schema, propertySet, fromTime, toTime, writeTime, filter, precondition);
        byte[] key = schema.fromKey(this.ndx.getIndexMetadata().getKeyBuilder(), primaryKey).getKey();
        return this.ndx.submit(key, proc);
    }

    public ITPS delete(Schema schema, Object primaryKey) {
        return this.delete(schema, primaryKey, 1L, Long.MIN_VALUE, -2L, null);
    }

    public ITPS delete(Schema schema, Object primaryKey, long fromTime, long toTime, long writeTime, INameFilter filter) {
        SparseRowStore.assertArgs(schema, primaryKey, fromTime, toTime);
        if (log.isInfoEnabled()) {
            log.info((Object)("schema=" + schema + ", primaryKey=" + primaryKey + ", timestamp=" + writeTime + ", filter=" + (filter == null ? "N/A" : filter.getClass().getName())));
        }
        AtomicRowDelete proc = new AtomicRowDelete(schema, primaryKey, fromTime, toTime, writeTime, filter);
        byte[] key = schema.fromKey(this.ndx.getIndexMetadata().getKeyBuilder(), primaryKey).getKey();
        return this.ndx.submit(key, proc);
    }

    public Iterator<? extends ITPS> rangeIterator(Schema schema) {
        return this.rangeIterator(schema, null, null, 0, 1L, Long.MIN_VALUE, null);
    }

    public Iterator<? extends ITPS> rangeIterator(Schema schema, Object fromKey, Object toKey) {
        return this.rangeIterator(schema, fromKey, toKey, 0, 1L, Long.MIN_VALUE, null);
    }

    public Iterator<? extends ITPS> rangeIterator(Schema schema, Object fromKey, Object toKey, INameFilter filter) {
        return this.rangeIterator(schema, fromKey, toKey, 0, 1L, Long.MIN_VALUE, filter);
    }

    public Iterator<? extends ITPS> rangeIterator(Schema schema, Object fromKey, Object toKey, int capacity, long fromTime, long toTime, INameFilter nameFilter) {
        boolean fixedLengthSuccessor;
        SparseRowStore.assertArgs(schema, Boolean.TRUE, fromTime, toTime);
        if (log.isInfoEnabled()) {
            log.info((Object)("schema=" + schema + ", fromKey=" + fromKey + ", toKey=" + toKey + ", capacity=" + capacity + ", fromTime=" + fromTime + ", toTime=" + toTime + ", filter=" + (nameFilter == null ? "N/A" : nameFilter.getClass().getName())));
        }
        IKeyBuilder keyBuilder = this.ndx.getIndexMetadata().getKeyBuilder();
        if (fromKey != null) {
            fromKey = schema.fromKey(keyBuilder, fromKey).getKey();
        }
        if (toKey != null) {
            toKey = schema.fromKey(keyBuilder, toKey).getKey();
        }
        int flags = 0xB | ((fixedLengthSuccessor = schema.getPrimaryKeyType().isFixedLength()) ? 128 : 0);
        return new Striterator((Iterator)this.ndx.rangeIterator((byte[])fromKey, (byte[])toKey, capacity, flags, new AtomicRowFilter(schema, fromTime, toTime, nameFilter))).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                ITuple tuple = (ITuple)obj;
                if (log.isInfoEnabled()) {
                    log.info((Object)("resolving TPS: " + tuple.getVisitCount()));
                }
                return tuple.getObject();
            }
        });
    }

    public List<String> getNamespaces(long tx) {
        LinkedList<String> namespaces = new LinkedList<String>();
        Iterator<? extends ITPS> itr = this.rangeIterator(RelationSchema.INSTANCE);
        while (itr.hasNext()) {
            ITPS tps = itr.next();
            String namespace = (String)tps.getPrimaryKey();
            String className = (String)tps.get(RelationSchema.CLASS).getValue();
            if (className == null) continue;
            try {
                Class<?> cls = Class.forName(className);
                if (!AbstractTripleStore.class.isAssignableFrom(cls)) continue;
                namespaces.add(namespace);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return namespaces;
    }

    public static interface Options {
        public static final String SCHEMA_NAME_UNICODE_CLEAN = Schema.class.getName() + ".schemaName.unicodeClean";
        public static final String DEFAULT_SCHEMA_NAME_UNICODE_CLEAN = "true";
        public static final String PRIMARY_KEY_UNICODE_CLEAN = Schema.class.getName() + ".primaryKey.unicodeClean";
        public static final String DEFAULT_PRIMARY_KEY_UNICODE_CLEAN = "true";
    }
}

