/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.proxy;

import com.bigdata.io.IStreamSerializer;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.service.proxy.IRemoteChunk;
import com.bigdata.service.proxy.IRemoteChunkedIterator;
import com.bigdata.service.proxy.RemoteChunk;
import com.bigdata.striterator.IKeyOrder;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RemoteChunkedIterator<E>
implements IRemoteChunkedIterator<E> {
    protected static final transient Logger log = Logger.getLogger(RemoteChunkedIterator.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final IAsynchronousIterator<E[]> sourceIterator;
    private final IStreamSerializer<E[]> serializer;
    private final IKeyOrder<E> keyOrder;
    volatile transient boolean open = true;
    private transient long nchunks = 0L;

    public RemoteChunkedIterator(IAsynchronousIterator<E[]> sourceIterator, IStreamSerializer<E[]> serializer, IKeyOrder<E> keyOrder) {
        if (sourceIterator == null) {
            throw new IllegalArgumentException();
        }
        if (serializer == null) {
            throw new IllegalArgumentException();
        }
        this.sourceIterator = sourceIterator;
        this.serializer = serializer;
        this.keyOrder = keyOrder;
        if (DEBUG) {
            log.debug((Object)("sourceIterator=" + sourceIterator + ", serializer=" + serializer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.open) {
            if (INFO) {
                log.info((Object)"Closing iterator.");
            }
            try {
                this.sourceIterator.close();
            }
            finally {
                this.open = false;
            }
        }
    }

    @Override
    public IRemoteChunk<E> nextChunk() throws IOException {
        RemoteChunk<Object> chunk;
        if (!this.sourceIterator.hasNext()) {
            if (INFO) {
                log.info((Object)("nchunks=" + this.nchunks + " : source is exhausted"));
            }
            chunk = new RemoteChunk<E>(true, this.serializer, this.keyOrder, null);
        } else {
            boolean sourceExhausted;
            Object[] a = (Object[])this.sourceIterator.next();
            boolean bl = sourceExhausted = !this.sourceIterator.hasNext();
            if (INFO) {
                log.info((Object)("nchunks=" + this.nchunks + ", elementsInChunk=" + a.length + ", sourceExhausted=" + sourceExhausted));
            }
            chunk = new RemoteChunk<Object>(sourceExhausted, this.serializer, this.keyOrder, a);
        }
        ++this.nchunks;
        return chunk;
    }
}

