/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.impl.GeoSpatialUtility;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;

public interface IGeoSpatialQuery {
    public GeoSpatial.GeoFunction getSearchFunction();

    public URI getSearchDatatype();

    public IConstant<?> getSubject();

    public TermNode getPredicate();

    public TermNode getContext();

    public GeoSpatialUtility.PointLatLon getSpatialCircleCenter();

    public Double getSpatialCircleRadius();

    public GeoSpatialUtility.PointLatLon getSpatialRectangleSouthWest();

    public GeoSpatialUtility.PointLatLon getSpatialRectangleNorthEast();

    public ICoordinate.UNITS getSpatialUnit();

    public Long getTimeStart();

    public Long getTimeEnd();

    public Long getCoordSystem();

    public Map<String, LowerAndUpperValue> getCustomFieldsConstraints();

    public IVariable<?> getLocationVar();

    public IVariable<?> getTimeVar();

    public IVariable<?> getLatVar();

    public IVariable<?> getLonVar();

    public IVariable<?> getCoordSystemVar();

    public IVariable<?> getCustomFieldsVar();

    public IVariable<?> getLocationAndTimeVar();

    public IVariable<?> getLiteralVar();

    public IVariable<?> getDistanceVar();

    public IBindingSet getIncomingBindings();

    public LowerAndUpperBound getLowerAndUpperBound();

    public List<IGeoSpatialQuery> normalize();

    public boolean isNormalized();

    public boolean isSatisfiable();

    public GeoSpatialDatatypeConfiguration getDatatypeConfig();

    public static class LowerAndUpperValue {
        public final Object lowerValue;
        public final Object upperValue;

        public LowerAndUpperValue(Object lowerValue, Object upperValue) {
            this.lowerValue = lowerValue;
            this.upperValue = upperValue;
        }
    }

    public static class LowerAndUpperBound {
        private final Object[] lowerBound;
        private final Object[] upperBound;

        public LowerAndUpperBound(Object[] lowerBound, Object[] upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public Object[] getLowerBound() {
            return this.lowerBound;
        }

        public Object[] getUpperBound() {
            return this.upperBound;
        }
    }
}

