/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.geospatial;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;

public class GeoSpatialDefaultLiteralSerializer
implements IGeoSpatialLiteralSerializer {
    private static final long serialVersionUID = 1L;
    private static final String COMPONENT_SEPARATOR = "#";

    @Override
    public String[] toComponents(String literalString) {
        if (literalString == null) {
            return new String[0];
        }
        return literalString.split(COMPONENT_SEPARATOR);
    }

    @Override
    public String fromComponents(Object[] components) {
        if (components == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < components.length; ++i) {
            if (i > 0) {
                buf.append(COMPONENT_SEPARATOR);
            }
            buf.append(components[i]);
        }
        return buf.toString();
    }

    @Override
    public IV<?, ?> serializeLocation(BigdataValueFactory vf, Object latitude, Object longitude) {
        return this.toSeparatedString(vf, latitude, longitude);
    }

    @Override
    public IV<?, ?> serializeLocationAndTime(BigdataValueFactory vf, Object latitude, Object longitude, Object time) {
        return this.toSeparatedString(vf, latitude, longitude, time);
    }

    @Override
    public IV<?, ?> serializeTime(BigdataValueFactory vf, Object time) {
        return new XSDNumericIV((Long)time);
    }

    @Override
    public IV<?, ?> serializeLatitude(BigdataValueFactory vf, Object latitude) {
        if (latitude instanceof Double) {
            return new XSDNumericIV((Double)latitude);
        }
        if (latitude instanceof Long) {
            return new XSDNumericIV(((Long)latitude).doubleValue());
        }
        throw new GeoSpatialSearchException("Latitude value expected to be either Double or Long");
    }

    @Override
    public IV<?, ?> serializeLongitude(BigdataValueFactory vf, Object longitude) {
        if (longitude instanceof Double) {
            return new XSDNumericIV((Double)longitude);
        }
        if (longitude instanceof Long) {
            return new XSDNumericIV(((Long)longitude).doubleValue());
        }
        throw new GeoSpatialSearchException("Longitude value expected to be either Double or Long");
    }

    @Override
    public IV<?, ?> serializeCoordSystem(BigdataValueFactory vf, Object coordinateSystem) {
        return this.toSeparatedString(vf, coordinateSystem);
    }

    @Override
    public IV<?, ?> serializeCustomFields(BigdataValueFactory vf, Object ... customFields) {
        return this.toSeparatedString(vf, customFields);
    }

    @Override
    public IV<?, ?> serializeDistance(BigdataValueFactory vf, Double distance, ICoordinate.UNITS unit) {
        return new XSDNumericIV((double)Math.round(distance * 100.0) / 100.0);
    }

    protected IV<?, ?> toSeparatedString(BigdataValueFactory vf, Object ... args) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buf.append(COMPONENT_SEPARATOR);
            }
            buf.append(args[i].toString());
        }
        return DummyConstantNode.toDummyIV(vf.createLiteral(buf.toString()));
    }
}

