/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import java.util.UUID;

public class ServiceScore
implements Comparable<ServiceScore> {
    public final String hostname;
    public final UUID serviceUUID;
    public final String serviceName;
    public final double rawScore;
    public double score;
    public int rank = -1;
    public double drank = -1.0;

    public ServiceScore(String hostname, UUID serviceUUID, String serviceName) {
        this(hostname, serviceUUID, serviceName, 0.0);
    }

    public ServiceScore(String hostname, UUID serviceUUID, String serviceName, double rawScore) {
        if (hostname == null) {
            throw new IllegalArgumentException();
        }
        if (serviceUUID == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        this.hostname = hostname;
        this.serviceUUID = serviceUUID;
        this.serviceName = serviceName;
        this.rawScore = rawScore;
    }

    public String toString() {
        return "ServiceScore{hostname=" + this.hostname + ", serviceUUID=" + this.serviceUUID + ", serviceName=" + this.serviceName + ", rawScore=" + this.rawScore + ", score=" + this.score + ", rank=" + this.rank + ", drank=" + this.drank + "}";
    }

    @Override
    public int compareTo(ServiceScore arg0) {
        if (this.rawScore < arg0.rawScore) {
            return -1;
        }
        if (this.rawScore > arg0.rawScore) {
            return 1;
        }
        return this.serviceUUID.compareTo(arg0.serviceUUID);
    }

    public static double normalize(double rawScore, double totalRawScore) {
        if (totalRawScore == 0.0) {
            return 0.0;
        }
        return rawScore / totalRawScore;
    }
}

