/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.Banner;
import com.bigdata.bop.engine.IQueryPeer;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.FederatedQueryEngine;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.ResultSet;
import com.bigdata.btree.proc.IIndexProcedure;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.journal.AbstractLocalTransactionManager;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.DropIndexTask;
import com.bigdata.journal.IConcurrencyManager;
import com.bigdata.journal.IDistributedTransactionService;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.IResourceManager;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.IndexProcedureTask;
import com.bigdata.journal.JournalTransactionService;
import com.bigdata.journal.RegisterIndexTask;
import com.bigdata.journal.RunState;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.Tx;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.IBlock;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.StoreManager;
import com.bigdata.service.AbstractService;
import com.bigdata.service.DefaultServiceFederationDelegate;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.IDataServiceCallable;
import com.bigdata.service.IFederationCallable;
import com.bigdata.service.IMetadataService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.ISession;
import com.bigdata.service.Session;
import cutthecrap.utils.striterators.IFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public abstract class DataService
extends AbstractService
implements IDataService,
IServiceShutdown,
ISession {
    protected static final Logger log = Logger.getLogger(DataService.class);
    private final ReadBlockCounters readBlockApiCounters = new ReadBlockCounters();
    private ResourceManager resourceManager;
    private ConcurrencyManager concurrencyManager;
    private DataServiceTransactionManager localTransactionManager;
    private final AtomicReference<FederatedQueryEngine> queryEngine = new AtomicReference();
    private final Properties properties;
    private final Session session = new Session();

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public IQueryPeer getQueryEngine() {
        return this.queryEngine.get();
    }

    public ConcurrencyManager getConcurrencyManager() {
        return this.concurrencyManager;
    }

    public ILocalTransactionManager getLocalTransactionManager() {
        return this.localTransactionManager;
    }

    protected IResourceManager newResourceManager(Properties properties) {
        return new ResourceManager(properties){

            @Override
            public IBigdataFederation<?> getFederation() {
                return DataService.this.getFederation();
            }

            @Override
            public DataService getDataService() {
                return DataService.this;
            }

            @Override
            public UUID getDataServiceUUID() {
                return DataService.this.getServiceUUID();
            }
        };
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    protected DataService(Properties properties) {
        Banner.banner();
        this.properties = (Properties)properties.clone();
    }

    @Override
    public boolean isOpen() {
        ConcurrencyManager tmp = this.concurrencyManager;
        return tmp != null && tmp.isOpen();
    }

    @Override
    public synchronized DataService start() {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        this.resourceManager = (ResourceManager)this.newResourceManager(this.properties);
        this.localTransactionManager = new DataServiceTransactionManager();
        this.concurrencyManager = new ConcurrencyManager(this.properties, this.localTransactionManager, this.resourceManager);
        if (this.resourceManager instanceof ResourceManager) {
            this.resourceManager.setConcurrencyManager(this.concurrencyManager);
        }
        this.getFederation().getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                DataService dataService = DataService.this;
                dataService.getResourceManager().awaitRunning();
                FederatedQueryEngine queryEngine = new FederatedQueryEngine(dataService);
                queryEngine.init();
                dataService.queryEngine.set(queryEngine);
                if (log.isInfoEnabled()) {
                    log.info((Object)"Setup query engine.");
                }
            }
        });
        return this;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        QueryEngine queryEngine = this.queryEngine.get();
        if (queryEngine != null) {
            queryEngine.shutdown();
        }
        if (this.concurrencyManager != null) {
            this.concurrencyManager.shutdown();
        }
        if (this.localTransactionManager != null) {
            this.localTransactionManager.shutdown();
        }
        if (this.resourceManager != null) {
            this.resourceManager.shutdown();
        }
        super.shutdown();
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        QueryEngine queryEngine = this.queryEngine.get();
        if (queryEngine != null) {
            queryEngine.shutdownNow();
        }
        if (this.concurrencyManager != null) {
            this.concurrencyManager.shutdownNow();
        }
        if (this.localTransactionManager != null) {
            this.localTransactionManager.shutdownNow();
        }
        if (this.resourceManager != null) {
            this.resourceManager.shutdownNow();
        }
        super.shutdownNow();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.resourceManager.deleteResources();
        File file = this.getHTTPDURLFile();
        if (file.exists()) {
            file.delete();
        }
    }

    protected File getHTTPDURLFile() {
        return new File(this.getResourceManager().getDataDir(), "httpd.url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReleaseTime(long releaseTime) {
        this.setupLoggingContext();
        try {
            this.getResourceManager().setReleaseTime(releaseTime);
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long singlePhaseCommit(long tx) throws ExecutionException, InterruptedException, IOException {
        this.setupLoggingContext();
        try {
            if (TimestampUtility.isReadOnly(tx)) {
                throw new IllegalArgumentException();
            }
            Tx localState = (Tx)this.getLocalTransactionManager().getTx(tx);
            if (localState == null) {
                throw new IllegalStateException();
            }
            StoreManager.ManagedJournal journal = this.getResourceManager().getLiveJournal();
            localState.lock.lock();
            try {
                if (localState.isEmptyWriteSet()) {
                    localState.setRunState(RunState.Committed);
                    ((DataServiceTransactionManager)journal.getLocalTransactionManager()).deactivateTx(localState);
                    long l = 0L;
                    return l;
                }
            }
            finally {
                localState.lock.unlock();
            }
            ConcurrencyManager concurrencyManager = this.getConcurrencyManager();
            JournalTransactionService.SinglePhaseCommit task = new JournalTransactionService.SinglePhaseCommit((IConcurrencyManager)concurrencyManager, journal.getLocalTransactionManager(), localState);
            try {
                concurrencyManager.submit(task).get();
                localState.lock.lock();
                try {
                    localState.setRunState(RunState.Committed);
                    ((DataServiceTransactionManager)journal.getLocalTransactionManager()).deactivateTx(localState);
                }
                finally {
                    localState.lock.unlock();
                }
            }
            catch (Throwable t) {
                localState.lock.lock();
                try {
                    localState.setRunState(RunState.Aborted);
                    ((DataServiceTransactionManager)journal.getLocalTransactionManager()).deactivateTx(localState);
                    throw new RuntimeException(t);
                }
                catch (Throwable throwable) {
                    localState.lock.unlock();
                    throw throwable;
                }
            }
            long l = task.getCommitTime();
            return l;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(long tx, long revisionTime) throws ExecutionException, InterruptedException, IOException {
        this.setupLoggingContext();
        try {
            if (TimestampUtility.isReadOnly(tx)) {
                throw new IllegalArgumentException();
            }
            Tx state = (Tx)this.getLocalTransactionManager().getTx(tx);
            if (state == null) {
                throw new IllegalStateException();
            }
            this.concurrencyManager.submit(new DistributedCommitTask(this.concurrencyManager, this.resourceManager, this.getServiceUUID(), state, revisionTime)).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(long tx) throws IOException {
        this.setupLoggingContext();
        try {
            Tx localState = (Tx)this.getLocalTransactionManager().getTx(tx);
            if (localState == null) {
                throw new IllegalArgumentException();
            }
            localState.lock.lock();
            try {
                localState.setRunState(RunState.Aborted);
            }
            finally {
                localState.lock.unlock();
            }
        }
        finally {
            this.clearLoggingContext();
        }
    }

    public static final String getIndexPartitionName(String name, int partitionId) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (partitionId == -1) {
            return name;
        }
        return name + "#" + partitionId;
    }

    @Override
    public Class getServiceIface() {
        Class serviceIface = this instanceof IMetadataService ? IMetadataService.class : IDataService.class;
        return serviceIface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerIndex(String name, IndexMetadata metadata) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            if (metadata == null) {
                throw new IllegalArgumentException();
            }
            RegisterIndexTask task = new RegisterIndexTask((IConcurrencyManager)this.concurrencyManager, name, metadata);
            this.concurrencyManager.submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(String name) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            DropIndexTask task = new DropIndexTask(this.concurrencyManager, name);
            this.concurrencyManager.submit(task).get();
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexMetadata getIndexMetadata(String name, long timestamp) throws IOException, InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            long startTime = timestamp == 0L ? -1L : timestamp;
            GetIndexMetadataTask task = new GetIndexMetadataTask(this.concurrencyManager, startTime, name);
            IndexMetadata indexMetadata = this.concurrencyManager.submit(task).get();
            return indexMetadata;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(long tx, String name, IIndexProcedure<T> proc) {
        this.setupLoggingContext();
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (proc == null) {
                throw new IllegalArgumentException();
            }
            long timestamp = tx == 0L && proc.isReadOnly() ? -1L : tx;
            IndexProcedureTask<T> task = new IndexProcedureTask<T>(this.concurrencyManager, timestamp, name, proc);
            if (task instanceof IFederationCallable) {
                ((IFederationCallable)((Object)task)).setFederation(this.getFederation());
            }
            if (task instanceof IDataServiceCallable) {
                ((IDataServiceCallable)((Object)task)).setDataService(this);
            }
            FutureTask<T> futureTask = this.concurrencyManager.submit(task);
            return futureTask;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<? extends Object> submit(Callable<? extends Object> task) {
        this.setupLoggingContext();
        try {
            if (task == null) {
                throw new IllegalArgumentException();
            }
            if (task instanceof IFederationCallable) {
                ((IFederationCallable)((Object)task)).setFederation(this.getFederation());
            }
            if (task instanceof IDataServiceCallable) {
                ((IDataServiceCallable)((Object)task)).setDataService(this);
            }
            Future<? extends Object> future = this.getFederation().getExecutorService().submit(task);
            return future;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet rangeIterator(long tx, String name, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) throws InterruptedException, ExecutionException {
        this.setupLoggingContext();
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            boolean readOnly = (flags & 8) != 0 || filter == null && (flags & 0x10) == 0;
            long timestamp = tx;
            if (timestamp == 0L && readOnly) {
                timestamp = -1L;
            }
            RangeIteratorTask task = new RangeIteratorTask(this.concurrencyManager, timestamp, name, fromKey, toKey, capacity, flags, filter);
            ResultSet resultSet = this.concurrencyManager.submit(task).get();
            return resultSet;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBlock readBlock(IResourceMetadata resource, final long addr) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        this.setupLoggingContext();
        long begin = System.nanoTime();
        try {
            final IRawStore store = this.resourceManager.openStore(resource.getUUID());
            if (store == null) {
                log.warn((Object)("Resource not available: " + resource));
                ++this.readBlockApiCounters.readBlockErrorCount;
                throw new IllegalStateException("Resource not available");
            }
            final int byteCount = store.getByteCount(addr);
            IBlock iBlock = new IBlock(){

                @Override
                public long getAddress() {
                    return addr;
                }

                @Override
                public InputStream inputStream() {
                    ByteBuffer buf = store.read(addr);
                    ((DataService)DataService.this).readBlockApiCounters.readBlockBytes += (long)byteCount;
                    return new ByteBufferInputStream(buf);
                }

                @Override
                public int length() {
                    return byteCount;
                }
            };
            return iBlock;
        }
        finally {
            ++this.readBlockApiCounters.readBlockCount;
            this.readBlockApiCounters.readBlockNanos = System.nanoTime() - begin;
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceOverflow(boolean immediate, boolean compactingMerge) throws IOException, InterruptedException, ExecutionException {
        block7: {
            this.setupLoggingContext();
            try {
                if (!(this.resourceManager instanceof ResourceManager)) {
                    throw new UnsupportedOperationException();
                }
                final ForceOverflowTask task = new ForceOverflowTask(compactingMerge);
                log.warn((Object)("Will force overflow: immediate=" + immediate + ", compactingMerge=" + compactingMerge));
                if (immediate) {
                    this.getConcurrencyManager().submit(new AbstractTask<Void>((IConcurrencyManager)this.getConcurrencyManager(), 0L, new String[]{"__forceOverflow"}){

                        @Override
                        protected Void doTask() throws Exception {
                            this.getJournal().write(ByteBuffer.wrap(new byte[]{1}));
                            return (Void)task.call();
                        }
                    }).get();
                    break block7;
                }
                try {
                    task.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.clearLoggingContext();
            }
        }
    }

    @Override
    public boolean purgeOldResources(long timeout, boolean truncateJournal) throws InterruptedException {
        return this.getResourceManager().purgeOldResources(timeout, truncateJournal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAsynchronousOverflowCounter() throws IOException {
        this.setupLoggingContext();
        try {
            if (!(this.resourceManager instanceof ResourceManager)) {
                throw new UnsupportedOperationException();
            }
            long l = this.resourceManager.getAsynchronousOverflowCount();
            return l;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOverflowActive() throws IOException {
        this.setupLoggingContext();
        try {
            if (!(this.resourceManager instanceof ResourceManager)) {
                throw new UnsupportedOperationException();
            }
            boolean bl = this.resourceManager.isOverflowEnabled() && !this.resourceManager.isOverflowAllowed();
            return bl;
        }
        finally {
            this.clearLoggingContext();
        }
    }

    private class ForceOverflowTask
    implements Callable<Void> {
        private final boolean compactingMerge;

        public ForceOverflowTask(boolean compactingMerge) {
            this.compactingMerge = compactingMerge;
        }

        @Override
        public Void call() throws Exception {
            ResourceManager resourceManager = DataService.this.resourceManager;
            if (resourceManager.isOverflowAllowed()) {
                if (this.compactingMerge) {
                    resourceManager.compactingMerge.set(true);
                }
                resourceManager.forceOverflow.set(true);
            }
            return null;
        }
    }

    protected static class RangeIteratorTask
    extends AbstractTask<ResultSet> {
        private final byte[] fromKey;
        private final byte[] toKey;
        private final int capacity;
        private final int flags;
        private final IFilter filter;

        public RangeIteratorTask(ConcurrencyManager concurrencyManager, long startTime, String name, byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
            super((IConcurrencyManager)concurrencyManager, startTime, name);
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.capacity = capacity;
            this.flags = flags;
            this.filter = filter;
        }

        @Override
        public ResultSet doTask() throws Exception {
            ILocalBTreeView ndx = this.getIndex(this.getOnlyResource());
            int rangeCount = (int)ndx.rangeCount(this.fromKey, this.toKey);
            int limit = rangeCount > this.capacity ? this.capacity : rangeCount;
            ITupleIterator itr = ndx.rangeIterator(this.fromKey, this.toKey, limit, this.flags | 1, this.filter);
            return new ResultSet(ndx, this.capacity, this.flags, itr);
        }
    }

    public static class GetIndexMetadataTask
    extends AbstractTask<IndexMetadata> {
        public GetIndexMetadataTask(ConcurrencyManager concurrencyManager, long startTime, String name) {
            super((IConcurrencyManager)concurrencyManager, startTime, name);
        }

        @Override
        protected IndexMetadata doTask() throws Exception {
            return this.getIndex(this.getOnlyResource()).getIndexMetadata();
        }
    }

    private static class DistributedCommitTask
    extends AbstractTask<Void> {
        private final ResourceManager resourceManager;
        private UUID dataServiceUUID;
        private final Tx state;
        private final long revisionTime;
        private final long tx;

        public DistributedCommitTask(ConcurrencyManager concurrencyManager, ResourceManager resourceManager, UUID dataServiceUUID, Tx localState, long revisionTime) {
            super((IConcurrencyManager)concurrencyManager, 0L, localState.getDirtyResource());
            if (resourceManager == null) {
                throw new IllegalArgumentException();
            }
            if (localState == null) {
                throw new IllegalArgumentException();
            }
            if (revisionTime == 0L) {
                throw new IllegalArgumentException();
            }
            if (revisionTime <= localState.getStartTimestamp()) {
                throw new IllegalArgumentException();
            }
            this.resourceManager = resourceManager;
            this.dataServiceUUID = dataServiceUUID;
            this.state = localState;
            this.revisionTime = revisionTime;
            this.tx = localState.getStartTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doTask() throws Exception {
            IDistributedTransactionService txService = (IDistributedTransactionService)this.resourceManager.getLiveJournal().getLocalTransactionManager().getTransactionService();
            this.prepare();
            long commitTime = txService.prepared(this.tx, this.dataServiceUUID);
            this.lockJournal();
            try {
                this.commit(commitTime);
                boolean success = false;
                try {
                    success = txService.committed(this.tx, this.dataServiceUUID);
                }
                finally {
                    if (!success) {
                        this.rollback();
                    }
                }
            }
            finally {
                this.unlockJournal();
            }
            return null;
        }

        protected void prepare() {
            this.state.prepare(this.revisionTime);
        }

        protected void lockJournal() {
            throw new UnsupportedOperationException();
        }

        protected void unlockJournal() {
            throw new UnsupportedOperationException();
        }

        protected void commit(long commitTime) {
            throw new UnsupportedOperationException();
        }

        protected void rollback() {
            StoreManager.ManagedJournal journal = this.resourceManager.getLiveJournal();
            journal.rollback();
        }
    }

    public static interface IDataServiceCounters
    extends ConcurrencyManager.IConcurrencyManagerCounters,
    ResourceManager.IResourceManagerCounters {
        public static final String concurrencyManager = "Concurrency Manager";
        public static final String transactionManager = "Transaction Manager";
        public static final String resourceManager = "Resource Manager";
        public static final String queryEngine = "Query Engine";
    }

    public static class DataServiceFederationDelegate
    extends DefaultServiceFederationDelegate<DataService> {
        private final DataService dataService;

        public DataServiceFederationDelegate(DataService service) {
            super(service);
            this.dataService = service;
        }

        @Override
        public boolean isServiceReady() {
            if (!this.dataService.resourceManager.isOpen()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Store manager not open - will shutdown.");
                }
                this.dataService.shutdownNow();
                return false;
            }
            if (!this.dataService.resourceManager.isRunning()) {
                log.warn((Object)"Resource manager is not running yet.");
                return false;
            }
            return true;
        }

        @Override
        public void didStart() {
            super.didStart();
            this.setupCounters();
            this.logHttpdURL(this.dataService.getHTTPDURLFile());
        }

        protected void setupCounters() {
            if (this.getServiceUUID() == null) {
                throw new IllegalStateException("The ServiceUUID is not available yet");
            }
            if (!this.dataService.isOpen()) {
                log.warn((Object)"Service is not open.");
                return;
            }
            CounterSet serviceRoot = this.dataService.getFederation().getServiceCounterSet();
            serviceRoot.makePath("Resource Manager").attach(this.dataService.resourceManager.getCounters());
            serviceRoot.makePath("Concurrency Manager").attach(this.dataService.concurrencyManager.getCounters());
            serviceRoot.makePath("Transaction Manager").attach(this.dataService.localTransactionManager.getCounters());
            QueryEngine queryEngine = (QueryEngine)this.dataService.queryEngine.get();
            if (queryEngine != null) {
                serviceRoot.makePath("Query Engine").attach(queryEngine.getCounters());
            }
            CounterSet tmp = serviceRoot.makePath("Block API");
            tmp.addCounter("Blocks Read", new Instrument<Long>(){

                @Override
                public void sample() {
                    this.setValue(((DataService)((DataServiceFederationDelegate)DataServiceFederationDelegate.this).dataService).readBlockApiCounters.readBlockCount);
                }
            });
            tmp.addCounter("Blocks Read Per Second", new Instrument<Double>(){

                @Override
                public void sample() {
                    long secs = TimeUnit.SECONDS.convert(((DataService)((DataServiceFederationDelegate)DataServiceFederationDelegate.this).dataService).readBlockApiCounters.readBlockNanos, TimeUnit.NANOSECONDS);
                    double v = secs == 0L ? 0.0 : (double)(((DataService)((DataServiceFederationDelegate)DataServiceFederationDelegate.this).dataService).readBlockApiCounters.readBlockCount / secs);
                    this.setValue(v);
                }
            });
        }
    }

    public class DataServiceTransactionManager
    extends AbstractLocalTransactionManager {
        @Override
        public ITransactionService getTransactionService() {
            return DataService.this.getFederation().getTransactionService();
        }

        @Override
        public void deactivateTx(Tx localState) {
            super.deactivateTx(localState);
        }
    }

    protected static class ReadBlockCounters {
        long readBlockCount;
        long readBlockErrorCount;
        long readBlockBytes;
        long readBlockNanos;
    }

    public static interface Options
    extends com.bigdata.journal.Options,
    ConcurrencyManager.Options,
    ResourceManager.Options,
    AbstractStatisticsCollector.Options,
    IBigdataClient.Options {
    }
}

