/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITupleIterator;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.MetadataIndex;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.service.AbstractScaleOutFederation;
import com.bigdata.service.CacheOnceMetadataIndex;
import com.bigdata.service.NoCacheMetadataIndexView;
import cutthecrap.utils.striterators.IFilter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachingMetadataIndex
extends CacheOnceMetadataIndex {
    private final NoCacheMetadataIndexView delegate;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public CachingMetadataIndex(AbstractScaleOutFederation<?> fed, String name, long timestamp, MetadataIndex.MetadataIndexMetadata mdmd) {
        super(fed, name, timestamp, mdmd);
        this.delegate = new NoCacheMetadataIndexView(fed, name, timestamp, mdmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void staleLocator(PartitionLocator locator) {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        if (this.timestamp != 0L && this.timestamp != -1L) {
            throw new RuntimeException("Stale locator, but views should be consistent? timestamp=" + TimestampUtility.toString(this.timestamp));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)locator.toString());
        }
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.cacheLocators(locator.getLeftSeparatorKey(), locator.getRightSeparatorKey());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionLocator get(byte[] key) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            PartitionLocator partitionLocator = super.get(key);
            return partitionLocator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionLocator find(byte[] key) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            PartitionLocator partitionLocator = super.find(key);
            return partitionLocator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCount() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            long l = this.delegate.rangeCount();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCount(byte[] fromKey, byte[] toKey) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            long l = this.delegate.rangeCount(fromKey, toKey);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCountExact(byte[] fromKey, byte[] toKey) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            long l = this.delegate.rangeCountExact(fromKey, toKey);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ITupleIterator rangeIterator() {
        return this.delegate.rangeIterator(null, null);
    }

    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey) {
        return this.rangeIterator(fromKey, toKey, 0, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITupleIterator rangeIterator(byte[] fromKey, byte[] toKey, int capacity, int flags, IFilter filter) {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ITupleIterator iTupleIterator = this.delegate.rangeIterator(fromKey, toKey, capacity, flags, filter);
            return iTupleIterator;
        }
        finally {
            lock.unlock();
        }
    }
}

