/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.IRangeQuery;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.NamedLock;
import com.bigdata.util.NT;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public abstract class AbstractIndexCache<T extends IRangeQuery> {
    protected static final Logger log = Logger.getLogger(AbstractIndexCache.class);
    private final ConcurrentWeakValueCache<NT, T> indexCache;
    private final NamedLock<NT> indexCacheLock = new NamedLock();

    protected AbstractIndexCache(int capacity, long timeout) {
        this.indexCache = new ConcurrentWeakValueCacheWithTimeout(capacity, TimeUnit.MILLISECONDS.toNanos(timeout));
    }

    protected abstract T newView(String var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getIndex(String name, long timestamp) {
        NT nt;
        IRangeQuery ndx;
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + " @ " + timestamp));
        }
        if ((ndx = (IRangeQuery)this.indexCache.get((Object)(nt = new NT(name, timestamp)))) != null) {
            return (T)ndx;
        }
        Lock lock = this.indexCacheLock.acquireLock(nt);
        try {
            ndx = (IRangeQuery)this.indexCache.get((Object)nt);
            if (ndx == null) {
                ndx = this.newView(name, timestamp);
                if (ndx == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("name=" + name + " @ " + timestamp + " : no such index."));
                    }
                    T t = null;
                    return t;
                }
                this.indexCache.put((Object)nt, (Object)ndx);
                if (log.isInfoEnabled()) {
                    log.info((Object)("name=" + name + " @ " + timestamp + " : index exists."));
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)("name=" + name + " @ " + timestamp + " : cache hit."));
            }
            IRangeQuery iRangeQuery = ndx;
            return (T)iRangeQuery;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropIndexFromCache(String name) {
        ConcurrentWeakValueCache<NT, T> concurrentWeakValueCache = this.indexCache;
        synchronized (concurrentWeakValueCache) {
            Iterator itr = this.indexCache.entryIterator();
            while (itr.hasNext()) {
                long timestamp;
                NT nt;
                Map.Entry entry = (Map.Entry)itr.next();
                IRangeQuery ndx = (IRangeQuery)((WeakReference)entry.getValue()).get();
                if (ndx == null || !name.equals((nt = (NT)entry.getKey()).getName()) || (timestamp = nt.getTimestamp()) != 0L && timestamp != -1L) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("dropped from cache: " + name + " @ " + timestamp));
                }
                this.indexCache.remove(entry.getKey());
            }
        }
    }

    protected void shutdown() {
        this.indexCache.clear();
    }
}

