/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.IAnalyzerFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;

public class DefaultAnalyzerFactory
implements IAnalyzerFactory {
    private final FullTextIndex fullTextIndex;
    private Map<String, AnalyzerConstructor> analyzers;

    public DefaultAnalyzerFactory(FullTextIndex fullTextIndex) {
        if (fullTextIndex == null) {
            throw new IllegalArgumentException();
        }
        this.fullTextIndex = fullTextIndex;
    }

    @Override
    public Analyzer getAnalyzer(String languageCode, boolean filterStopwords) {
        IKeyBuilder keyBuilder = this.fullTextIndex.getKeyBuilder();
        Map<String, AnalyzerConstructor> map = this.getAnalyzers();
        AnalyzerConstructor ctor = null;
        if (languageCode == null) {
            Locale locale;
            Analyzer a;
            if (keyBuilder.isUnicodeSupported() && (a = this.getAnalyzer((locale = ((KeyBuilder)keyBuilder).getSortKeyGenerator().getLocale()).getLanguage(), filterStopwords)) != null) {
                return a;
            }
        } else {
            String code = languageCode;
            if (code.length() > 3) {
                code = code.substring(0, 2);
                ctor = map.get(languageCode);
            }
            if (ctor == null && code.length() > 2) {
                code = code.substring(0, 1);
                ctor = map.get(languageCode);
            }
        }
        if (ctor == null && (ctor = map.get("")) == null) {
            throw new IllegalStateException("No entry for empty string?");
        }
        Analyzer a = ctor.newInstance(filterStopwords);
        return a;
    }

    private synchronized Map<String, AnalyzerConstructor> getAnalyzers() {
        if (this.analyzers != null) {
            return this.analyzers;
        }
        this.analyzers = new HashMap<String, AnalyzerConstructor>();
        final CharArraySet emptyStopwords = CharArraySet.EMPTY_SET;
        AnalyzerConstructor a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new BrazilianAnalyzer() : new BrazilianAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("por", a);
        this.analyzers.put("pt", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new SmartChineseAnalyzer() : new SmartChineseAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("zho", a);
        this.analyzers.put("chi", a);
        this.analyzers.put("zh", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new CJKAnalyzer() : new CJKAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("jpn", a);
        this.analyzers.put("ja", a);
        this.analyzers.put("jpn", a);
        this.analyzers.put("kor", a);
        this.analyzers.put("ko", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new CzechAnalyzer() : new CzechAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("ces", a);
        this.analyzers.put("cze", a);
        this.analyzers.put("cs", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new DutchAnalyzer() : new DutchAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("dut", a);
        this.analyzers.put("nld", a);
        this.analyzers.put("nl", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new FrenchAnalyzer() : new FrenchAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("fra", a);
        this.analyzers.put("fre", a);
        this.analyzers.put("fr", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new GermanAnalyzer() : new GermanAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("deu", a);
        this.analyzers.put("ger", a);
        this.analyzers.put("de", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new GreekAnalyzer() : new GreekAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("gre", a);
        this.analyzers.put("ell", a);
        this.analyzers.put("el", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new RussianAnalyzer() : new RussianAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("rus", a);
        this.analyzers.put("ru", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return new ThaiAnalyzer();
            }
        };
        this.analyzers.put("tha", a);
        this.analyzers.put("th", a);
        a = new AnalyzerConstructor(){

            @Override
            public Analyzer newInstance(boolean filterStopwords) {
                return filterStopwords ? new StandardAnalyzer() : new StandardAnalyzer(emptyStopwords);
            }
        };
        this.analyzers.put("eng", a);
        this.analyzers.put("en", a);
        this.analyzers.put("", a);
        return this.analyzers;
    }

    private static abstract class AnalyzerConstructor {
        private AnalyzerConstructor() {
        }

        public abstract Analyzer newInstance(boolean var1);
    }
}

