/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.FullTextIndex;
import com.bigdata.search.IAnalyzerFactory;
import com.bigdata.search.NeedsConfiguringAnalyzerFactory;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;

public class ConfigurableAnalyzerFactory
implements IAnalyzerFactory {
    private static final transient Logger log = Logger.getLogger(ConfigurableAnalyzerFactory.class);
    IAnalyzerFactory delegate;
    static int loggerIdCounter = 0;

    public ConfigurableAnalyzerFactory(FullTextIndex<?> fullTextIndex) {
        this.delegate = new NeedsConfiguringAnalyzerFactory(this, fullTextIndex);
    }

    @Override
    public Analyzer getAnalyzer(String languageCode, boolean filterStopwords) {
        Analyzer unlogged = this.delegate.getAnalyzer(languageCode, filterStopwords);
        return unlogged;
    }

    public static interface AnalyzerOptions {
        public static final String ANALYZER_CLASS = "analyzerClass";
        public static final String LIKE = "like";
        public static final String STOPWORDS = "stopwords";
        public static final String STOPWORDS_VALUE_DEFAULT = "default";
        public static final String STOPWORDS_VALUE_NONE = "none";
        public static final String PATTERN = "pattern";
        public static final String WORD_BOUNDARY = "wordBoundary";
        public static final String SUB_WORD_BOUNDARY = "subWordBoundary";
        public static final String SOFT_HYPHENS = "softHyphens";
        public static final String ALWAYS_REMOVE_SOFT_HYPHENS = "alwaysRemoveSoftHyphens";
        public static final boolean DEFAULT_ALWAYS_REMOVE_SOFT_HYPHENS = false;
        public static final Pattern DEFAULT_SUB_WORD_BOUNDARY = Pattern.compile("(?!)");
    }

    public static interface Options {
        public static final String NATURAL_LANGUAGE_SUPPORT = ConfigurableAnalyzerFactory.class.getName() + ".naturalLanguageSupport";
        public static final String ANALYZER = ConfigurableAnalyzerFactory.class.getName() + ".analyzer.";
        public static final String DEFAULT_NATURAL_LANGUAGE_SUPPORT = "false";
    }
}

