/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Journal;
import com.bigdata.journal.RWStrategy;
import com.bigdata.rwstore.RWStore;
import java.io.File;
import java.util.Properties;

public class MetabitsUtil {
    static String getArg(String[] args, String arg, String def) {
        for (int p = 0; p < args.length; p += 2) {
            if (!arg.equals(args[p])) continue;
            return args[p + 1];
        }
        return def;
    }

    static Journal getStore(String storeFile) {
        Properties properties = new Properties();
        properties.setProperty(Journal.Options.FILE, storeFile);
        properties.setProperty(Journal.Options.BUFFER_MODE, BufferMode.DiskRW.toString());
        return new Journal(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String store = MetabitsUtil.getArg(args, "-store", null);
        if (store == null) {
            System.err.println("file must be specificed with -store");
            return;
        }
        File file = new File(store);
        if (!file.exists()) {
            System.err.println("Specified file '" + store + "' not found");
            return;
        }
        boolean usedemi = "true".equals(MetabitsUtil.getArg(args, "-usedemispace", "true"));
        try (Journal jnl = MetabitsUtil.getStore(store);){
            RWStore rws = ((RWStrategy)jnl.getBufferStrategy()).getStore();
            if (rws.ensureMetabitsDemispace(usedemi)) {
                jnl.commit();
            }
        }
    }
}

