/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.ICommitter;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rwstore.AllocBlock;
import com.bigdata.rwstore.Allocator;
import com.bigdata.rwstore.FixedOutputStream;
import com.bigdata.rwstore.RWStore;
import com.bigdata.rwstore.RWWriteCacheService;
import com.bigdata.rwstore.StorageStats;
import com.bigdata.rwstore.StorageTerminalError;
import com.bigdata.util.BytesUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class FixedAllocator
implements Allocator {
    private static final Logger log = Logger.getLogger(FixedAllocator.class);
    private static final boolean s_islogDebug = log.isDebugEnabled();
    private static final boolean s_islogTrace = log.isTraceEnabled();
    private final int cModAllocation = 65536;
    private final int cMinAllocation = 65536;
    volatile int m_freeBits;
    private volatile int m_freeTransients;
    FixedAllocator m_prevCommit;
    FixedAllocator m_nextCommit;
    private volatile int m_diskAddr = 0;
    private volatile int m_index;
    StorageStats.Bucket m_statsBucket = null;
    boolean m_smallSlotHighWaste = false;
    private ArrayList m_freeList;
    private volatile IAllocationContext m_context;
    private boolean m_sessionActive;
    boolean m_pendingContextCommit = false;
    final int m_size;
    private int m_startAddr = 0;
    private int m_endAddr = 0;
    int m_allocIndex = -1;
    private final int m_bitSize;
    private final int allocBlockRange;
    private final ArrayList<AllocBlock> m_allocBlocks;
    final RWStore m_store;
    private boolean m_freeWaiting = true;
    private AtomicInteger m_sessionFrees = new AtomicInteger(0);

    @Override
    public void setIndex(int index) {
        AllocBlock fb = this.m_allocBlocks.get(0);
        if (s_islogDebug) {
            log.debug((Object)("Restored index " + index + " with " + this.getStartAddr() + "[" + fb.m_live[0] + "] from " + this.m_diskAddr));
        }
        this.m_index = index;
    }

    @Override
    public long getStartAddr() {
        return RWStore.convertAddr(this.m_startAddr);
    }

    public int compareTo(Object o) {
        Allocator other = (Allocator)o;
        if (other.getStartAddr() == 0L) {
            return -1;
        }
        long val = this.getStartAddr() - other.getStartAddr();
        if (val == 0L) {
            throw new Error("Two allocators at same address");
        }
        return val < 0L ? -1 : 1;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int getDiskAddr() {
        return this.m_diskAddr;
    }

    @Override
    public void setDiskAddr(int addr) {
        if (this.m_index == -1) {
            throw new IllegalStateException("Attempt to set a storage addr for an invalid FixedAllcator");
        }
        this.m_diskAddr = addr;
    }

    public long getPhysicalAddress(int offset, boolean nocheck) {
        AllocBlock block = this.m_allocBlocks.get((offset -= 3) / this.allocBlockRange);
        int bit = offset % this.allocBlockRange;
        long paddr = RWStore.convertAddr(block.m_addr) + (long)this.m_size * (long)bit;
        if (nocheck || RWStore.tstBit(block.m_transients, bit)) {
            return paddr;
        }
        if (RWStore.tstBit(block.m_commit, bit)) {
            throw new IllegalStateException("Address committed but not set in transients");
        }
        this.m_store.showWriteCacheDebug(paddr);
        log.warn((Object)("Physical address " + paddr + " not accessible for Allocator of size " + this.m_size));
        return 0L;
    }

    @Override
    public int getPhysicalSize(int offset) {
        return this.m_size;
    }

    @Override
    public int getBlockSize() {
        return this.m_size;
    }

    @Override
    public void setFreeList(ArrayList list) {
        this.setFreeList(list, false);
    }

    public void setFreeList(ArrayList list, boolean force) {
        if (this.m_freeList != list) {
            this.m_freeList = list;
            this.m_freeWaiting = true;
        }
        if (this.m_pendingContextCommit || !this.hasFree()) {
            if (force) {
                throw new IllegalStateException("The allocator cannot be added to the free list, pendingContextCommit: " + this.m_pendingContextCommit + ", hasFree: " + this.hasFree());
            }
            return;
        }
        if (force || this.meetsSmallSlotThreshold()) {
            this.addToFreeList();
        }
    }

    void removeFromFreeList() {
        if (this.m_freeList != null) {
            this.m_freeList.remove(this);
            this.m_freeWaiting = true;
        }
    }

    boolean isUnlocked() {
        return this.m_context == null;
    }

    public void setAllocationContext(IAllocationContext context) {
        if (this.m_pendingContextCommit) {
            throw new IllegalStateException("Already pending commit");
        }
        if (s_islogDebug) {
            this.checkBits();
        }
        if (context == null && this.m_context != null) {
            for (AllocBlock allocBlock : this.m_allocBlocks) {
                allocBlock.deshadow();
            }
            this.m_store.addToCommit(this);
            this.m_pendingContextCommit = true;
        } else if (context != null && this.m_context == null) {
            for (AllocBlock allocBlock : this.m_allocBlocks) {
                allocBlock.shadow();
            }
        }
        this.m_context = context;
        if (s_islogDebug) {
            this.checkBits();
        }
    }

    public void abortAllocationContext(IAllocationContext context, RWWriteCacheService writeCacheService) {
        if (this.m_pendingContextCommit) {
            throw new IllegalStateException("Already pending commit");
        }
        if (this.m_context != null) {
            for (AllocBlock allocBlock : this.m_allocBlocks) {
                allocBlock.abortshadow(writeCacheService);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.m_freeBits = this.calcFreeBits();
        this.m_context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] write() {
        try {
            AllocBlock fb = this.m_allocBlocks.get(0);
            if (s_islogTrace) {
                log.trace((Object)("writing allocator " + this.m_index + " for " + this.getStartAddr() + " with " + fb.m_live[0]));
            }
            byte[] buf = new byte[1024];
            boolean protectTransients = this.m_sessionActive || this.m_store.isSessionProtected();
            try (DataOutputStream str = new DataOutputStream(new FixedOutputStream(buf));){
                str.writeInt(this.m_size);
                assert (this.m_sessionActive || this.m_freeTransients == this.transientbits());
                for (AllocBlock block : this.m_allocBlocks) {
                    str.writeInt(block.m_addr);
                    for (int i = 0; i < this.m_bitSize; ++i) {
                        str.writeInt(block.m_live[i]);
                    }
                    if (protectTransients) continue;
                    assert (this.m_sessionFrees.intValue() == 0);
                    block.releaseCommitWrites(this.m_store.getWriteCacheService());
                }
                int chk = ChecksumUtility.getCHK().checksum(buf, str.size());
                str.writeInt(chk);
            }
            if (s_islogDebug) {
                this.checkBits();
            }
            return buf;
        }
        catch (IOException e) {
            throw new StorageTerminalError("Error on write", e);
        }
    }

    private int calcFreeBits() {
        int freeBits = 0;
        for (AllocBlock block : this.m_allocBlocks) {
            for (int i = 0; i < this.m_bitSize; ++i) {
                freeBits += 32 - Integer.bitCount(block.m_transients[i]);
            }
        }
        return freeBits;
    }

    private int calcLiveFreeBits() {
        int freeBits = 0;
        for (AllocBlock block : this.m_allocBlocks) {
            for (int i = 0; i < this.m_bitSize; ++i) {
                freeBits += 32 - Integer.bitCount(block.m_live[i]);
            }
        }
        return freeBits;
    }

    private boolean checkBits() {
        boolean ret;
        int calcFree = this.calcFreeBits();
        int calcLiveFree = this.calcLiveFreeBits();
        boolean bl = ret = this.m_freeBits == calcFree && this.m_freeBits + this.m_freeTransients == calcLiveFree;
        if (!ret) {
            throw new AssertionError((Object)("m_free: " + this.m_freeBits + ", calcFree: " + calcFree));
        }
        return ret;
    }

    @Override
    public void read(DataInputStream str) {
        try {
            this.m_freeBits = 0;
            Iterator<AllocBlock> iter = this.m_allocBlocks.iterator();
            int blockSize = this.m_bitSize * 32 * this.m_size;
            while (iter.hasNext()) {
                AllocBlock block = iter.next();
                block.m_addr = str.readInt();
                for (int i = 0; i < this.m_bitSize; ++i) {
                    block.m_live[i] = str.readInt();
                    if (block.m_live[i] == 0) {
                        this.m_freeBits += 32;
                        continue;
                    }
                    if (block.m_live[i] == -1) continue;
                    int anInt = block.m_live[i];
                    this.m_freeBits += 32 - Integer.bitCount(anInt);
                }
                block.m_transients = (int[])block.m_live.clone();
                block.m_commit = (int[])block.m_live.clone();
                if (this.m_startAddr == 0) {
                    this.m_startAddr = block.m_addr;
                }
                if (block.m_addr <= 0) continue;
                this.m_endAddr = block.m_addr + blockSize;
            }
        }
        catch (IOException e) {
            throw new StorageTerminalError("Error on read", e);
        }
    }

    FixedAllocator(RWStore store, int size) {
        this.m_store = store;
        this.m_size = size;
        this.m_bitSize = FixedAllocator.calcBitSize(true, size, 65536, 65536);
        this.allocBlockRange = 32 * this.m_bitSize;
        int numBlocks = 254 / (this.m_bitSize + 1);
        this.m_allocBlocks = new ArrayList(numBlocks);
        for (int i = 0; i < numBlocks; ++i) {
            this.m_allocBlocks.add(new AllocBlock(0, this.m_bitSize, this));
        }
        this.m_freeTransients = 0;
        this.m_freeBits = 32 * this.m_bitSize * numBlocks;
    }

    void resetAllocIndex() {
        this.resetAllocIndex(0);
    }

    void resetAllocIndex(int start) {
        this.m_allocIndex = start;
        if (this.m_size <= this.m_store.cSmallSlot) {
            for (int a = this.m_allocIndex / this.m_bitSize; a < this.m_allocBlocks.size(); ++a) {
                AllocBlock ab = this.m_allocBlocks.get(a);
                this.checkBlock(ab);
                for (int i = this.m_allocIndex % this.m_bitSize; i < this.m_bitSize; ++i) {
                    if (ab.m_transients[i] != -1 && (this.m_smallSlotHighWaste || Integer.bitCount(ab.m_commit[i]) < 16)) {
                        AllocBlock abr = this.m_allocBlocks.get(this.m_allocIndex / this.m_bitSize);
                        assert (abr == ab);
                        return;
                    }
                    ++this.m_allocIndex;
                }
            }
            if (start == 0) {
                this.removeFromFreeList();
            } else {
                this.resetAllocIndex(0);
            }
        }
    }

    public static int calcBitSize(boolean optDensity, int alloc, int minReserve, int modAllocation) {
        int nints;
        int intAllocation = 32 * alloc;
        int n = nints = optDensity ? 8 : 1;
        while (nints * intAllocation < minReserve) {
            ++nints;
        }
        while (nints * intAllocation % modAllocation != 0) {
            ++nints;
        }
        return nints;
    }

    @Override
    public String getStats(AtomicLong counter) {
        StringBuilder sb = new StringBuilder(this.getSummaryStats());
        for (AllocBlock block : this.m_allocBlocks) {
            if (block.m_addr == 0) break;
            sb.append(block.getStats(null) + "\r\n");
            if (counter == null) continue;
            counter.addAndGet((long)block.getAllocBits() * (long)this.m_size);
        }
        return sb.toString();
    }

    public String getSummaryStats() {
        return "Block size : " + this.m_size + " start : " + this.getStartAddr() + " free : " + this.m_freeBits + "\r\n";
    }

    @Override
    public boolean verify(int addr) {
        if (addr >= this.m_startAddr && addr < this.m_endAddr) {
            for (AllocBlock block : this.m_allocBlocks) {
                if (!block.verify(addr, this.m_size)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addressInRange(int addr) {
        if (addr >= this.m_startAddr && addr < this.m_endAddr) {
            for (AllocBlock block : this.m_allocBlocks) {
                if (!block.addressInRange(addr, this.m_size)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean free(int addr, int size) {
        return this.free(addr, size, false);
    }

    public boolean free(int addr, int size, boolean overideSession) {
        if (addr < 0) {
            int offset = (-addr & 0x1FFF) - 3;
            int nbits = 32 * this.m_bitSize;
            int block = offset / nbits;
            boolean tmp = this.m_sessionActive;
            boolean bl = this.m_sessionActive = tmp || this.m_store.isSessionProtected();
            if (tmp && !this.m_sessionActive) {
                throw new AssertionError();
            }
            try {
                if (s_islogDebug) {
                    this.checkBits();
                }
                if (this.m_allocBlocks.get(block).freeBit(offset % nbits, this.m_sessionActive && !overideSession)) {
                    ++this.m_freeBits;
                    this.checkFreeList();
                } else {
                    ++this.m_freeTransients;
                    if (this.m_sessionActive) assert (this.checkSessionFrees());
                }
                if (this.m_statsBucket != null) {
                    this.m_statsBucket.delete(size);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("IAE with address: " + addr + ", size: " + size + ", context: " + (this.m_context == null ? -1 : this.m_context.hashCode()), iae);
            }
            if (s_islogDebug) {
                this.checkBits();
            }
            return true;
        }
        if (addr >= this.m_startAddr && addr < this.m_endAddr) {
            for (AllocBlock block : this.m_allocBlocks) {
                if (!block.free(addr, this.m_size)) continue;
                ++this.m_freeTransients;
                if (s_islogDebug) {
                    this.checkBits();
                }
                return true;
            }
        }
        if (s_islogDebug) {
            this.checkBits();
        }
        return false;
    }

    private boolean checkSessionFrees() {
        int sessionFrees = this.m_sessionFrees.incrementAndGet();
        int sessionBits = 0;
        for (AllocBlock ab : this.m_allocBlocks) {
            sessionBits += ab.sessionBits();
        }
        return sessionFrees <= sessionBits;
    }

    private void checkFreeList() {
        if (this.m_freeWaiting && !this.m_pendingContextCommit && this.meetsSmallSlotThreshold()) {
            this.addToFreeList();
            this.resetAllocIndex(0);
        }
    }

    void addToFreeList() {
        assert (this.m_freeWaiting);
        this.m_freeWaiting = false;
        this.m_freeList.add(this);
        this.m_allocIndex = -1;
        if (s_islogDebug) {
            log.debug((Object)("Returning Allocator to FreeList - " + this.m_size));
        }
    }

    private boolean meetsSmallSlotThreshold() {
        if (this.m_freeBits < this.m_store.cDefaultFreeBitsThreshold) {
            return false;
        }
        if (this.m_size <= this.m_store.cSmallSlot) {
            boolean ret = this.m_freeBits > this.m_store.cSmallSlotThreshold;
            return ret;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int alloc(RWStore store, int size, IAllocationContext context) {
        try {
            if (size <= 0) {
                throw new IllegalArgumentException("Allocate requires positive size, got: " + size);
            }
            if (size > this.m_size) {
                throw new IllegalArgumentException("FixedAllocator with slots of " + this.m_size + " bytes requested allocation for " + size + " bytes");
            }
            if (this.m_freeBits == 0) {
                throw new IllegalStateException("Request to allocate from " + this.m_size + "byte slot FixedAllocator with zero bits free - should not be on the Free List");
            }
            int addr = -1;
            if (this.m_size <= this.m_store.cSmallSlot) {
                int n = this.allocFromIndex(size);
                return n;
            }
            Iterator<AllocBlock> iter = this.m_allocBlocks.iterator();
            int count = -1;
            while (addr == -1 && iter.hasNext()) {
                ++count;
                AllocBlock block = iter.next();
                this.checkBlock(block);
                addr = block.alloc(this.m_size);
            }
            if (addr != -1) {
                addr += 3;
                if (--this.m_freeBits == 0) {
                    if (s_islogTrace) {
                        log.trace((Object)"Remove from free list");
                    }
                    this.removeFromFreeList();
                    if (this.m_freeList.size() > 0 && s_islogDebug) {
                        FixedAllocator nxt = (FixedAllocator)this.m_freeList.get(0);
                        log.debug((Object)("Freelist head: " + nxt.getSummaryStats()));
                    }
                }
                int value = -((this.m_index << 13) + (addr += count * 32 * this.m_bitSize));
                if (this.m_statsBucket != null) {
                    this.m_statsBucket.allocate(size);
                }
                int n = value;
                return n;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("FixedAllocator returning null address, with freeBits: " + this.m_freeBits + "\n");
            for (AllocBlock ab : this.m_allocBlocks) {
                sb.append(ab.show() + "\n");
            }
            log.error((Object)sb);
            int n = 0;
            return n;
        }
        finally {
            if (s_islogDebug) {
                this.checkBits();
            }
        }
    }

    boolean checkBlock0() {
        return this.checkBlock(this.m_allocBlocks.get(0));
    }

    boolean checkBlock(AllocBlock block) {
        if (block.m_addr == 0) {
            int blockSize = 32 * this.m_bitSize;
            if (this.m_statsBucket != null) {
                this.m_statsBucket.addSlots(blockSize);
            }
            blockSize *= this.m_size;
            block.m_addr = this.grabAllocation(this.m_store, blockSize >>= 16);
            if (s_islogDebug) {
                log.debug((Object)("Allocation block at " + block.m_addr + " of " + (blockSize << 16) + " bytes"));
            }
            if (this.m_startAddr == 0) {
                this.m_startAddr = block.m_addr;
            }
            this.m_endAddr = block.m_addr - blockSize;
            return true;
        }
        return false;
    }

    int allocFromIndex(int size) {
        int calc;
        if (this.m_allocIndex == -1) {
            this.resetAllocIndex();
            if (this.m_allocIndex == -1) {
                throw new AssertionError((Object)("Unable to set AllocIndex with m_freeBits: " + this.m_freeBits));
            }
        }
        if (s_islogDebug) {
            this.checkBits();
        }
        if (s_islogDebug && this.m_freeBits != this.calcFreeBits()) {
            int calc2 = this.calcFreeBits();
            throw new AssertionError((Object)("m_freeBits != calcFreeBits() : " + this.m_freeBits + "!=" + calc2));
        }
        assert (this.m_freeBits == this.calcFreeBits());
        AllocBlock ab = this.m_allocBlocks.get(this.m_allocIndex / this.m_bitSize);
        if (ab.m_addr == 0) {
            throw new AssertionError((Object)("No allocation for AllocBlock with m_allocIndex: " + this.m_allocIndex));
        }
        int abblock = this.m_allocIndex % this.m_bitSize;
        assert (ab.m_transients[abblock] != -1);
        int bit = RWStore.fndBit(ab.m_transients[abblock]);
        assert (bit >= 0);
        --this.m_freeBits;
        int abit = abblock * 32 + bit;
        RWStore.setBit(ab.m_live, abit);
        RWStore.setBit(ab.m_transients, abit);
        int addr = -((this.m_index << 13) + this.m_allocIndex * 32 + (bit + 3));
        if (ab.m_transients[abblock] == -1) {
            this.resetAllocIndex(this.m_allocIndex + 1);
        }
        if (s_islogDebug && this.m_freeBits != (calc = this.calcFreeBits())) {
            throw new AssertionError((Object)("m_freeBits != calcFreeBits() : " + this.m_freeBits + "!=" + calc));
        }
        if (this.m_statsBucket != null) {
            this.m_statsBucket.allocate(size);
        }
        return addr;
    }

    protected int grabAllocation(RWStore store, int blockSize) {
        int ret = store.allocBlock(blockSize);
        return ret;
    }

    @Override
    public boolean hasFree() {
        return this.m_freeBits > 0;
    }

    @Override
    public void addAddresses(ArrayList addrs) {
        Iterator<AllocBlock> blocks = this.m_allocBlocks.iterator();
        int baseAddr = -(this.m_index << 16);
        while (blocks.hasNext()) {
            AllocBlock block = blocks.next();
            block.addAddresses(addrs, baseAddr);
            baseAddr -= 32 * this.m_bitSize;
        }
    }

    @Override
    public int getRawStartAddr() {
        return this.m_startAddr;
    }

    @Override
    public int getIndex() {
        return this.m_index;
    }

    @Override
    public void appendShortStats(StringBuilder str, RWStore.AllocationStats[] stats) {
        int si = -1;
        if (stats == null) {
            str.append("Index: " + this.m_index + ", " + this.m_size);
        } else {
            for (int i = 0; i < stats.length; ++i) {
                if ((long)this.m_size != stats[i].m_blockSize) continue;
                si = i;
                break;
            }
        }
        for (AllocBlock block : this.m_allocBlocks) {
            if (block.m_addr == 0) break;
            str.append(block.getStats(si == -1 ? null : stats[si]));
        }
        str.append("\n");
    }

    public int getAllocatedBlocks() {
        int allocated = 0;
        Iterator<AllocBlock> blocks = this.m_allocBlocks.iterator();
        while (blocks.hasNext() && blocks.next().m_addr != 0) {
            ++allocated;
        }
        return allocated;
    }

    public long getFileStorage() {
        long blockSize = 32L * (long)this.m_bitSize * (long)this.m_size;
        long allocated = this.getAllocatedBlocks();
        return allocated *= blockSize;
    }

    public long getAllocatedSlots() {
        int allocBlocks = this.getAllocatedBlocks();
        int xtraFree = this.m_allocBlocks.size() - allocBlocks;
        int freeBits = this.m_freeBits - (xtraFree *= 32 * this.m_bitSize);
        long alloted = allocBlocks * 32 * this.m_bitSize - freeBits;
        return alloted * (long)this.m_size;
    }

    @Override
    public boolean isAllocated(int offset) {
        int allocBlockRange = 32 * this.m_bitSize;
        AllocBlock block = this.m_allocBlocks.get((offset -= 3) / allocBlockRange);
        int bit = offset % allocBlockRange;
        return RWStore.tstBit(block.m_live, bit);
    }

    public boolean isCommitted(int offset) {
        int allocBlockRange = 32 * this.m_bitSize;
        AllocBlock block = this.m_allocBlocks.get((offset -= 3) / allocBlockRange);
        int bit = offset % allocBlockRange;
        return RWStore.tstBit(block.m_commit, bit);
    }

    protected final AllocBlock getBlockFromLocalOffset(int offset) {
        int allocBlockRange = 32 * this.m_bitSize;
        return this.m_allocBlocks.get((offset -= 3) / allocBlockRange);
    }

    @Override
    public boolean canImmediatelyFree(int addr, int size, IAllocationContext context) {
        int offset = -addr & 0x1FFF;
        boolean committed = this.isCommitted(offset);
        if (!this.m_pendingContextCommit && (context == this.m_context || this.m_context == null && !context.isIsolated())) {
            return !committed;
        }
        if (this.m_context != null) {
            if (!committed) {
                throw new IllegalStateException("Attempt to free address with invalid context");
            }
            return false;
        }
        return false;
    }

    public void setBucketStats(StorageStats.Bucket b) {
        this.m_statsBucket = b;
    }

    boolean reset(RWWriteCacheService cache, int nextAllocation) {
        boolean isolatedWrites = false;
        for (AllocBlock ab : this.m_allocBlocks) {
            if (ab.m_addr == 0) break;
            ab.reset(cache);
            boolean bl = isolatedWrites = isolatedWrites || ab.m_saveCommit != null;
            if (ab.m_addr > nextAllocation || ab.m_saveCommit != null) continue;
            assert (ab.freeBits() == ab.totalBits());
            ab.m_addr = 0;
        }
        this.m_freeTransients = this.transientbits();
        this.m_freeBits = this.calcFreeBits();
        this.m_allocIndex = -1;
        assert (this.calcSessionFrees());
        if (s_islogDebug) {
            this.checkBits();
        }
        return isolatedWrites;
    }

    private boolean calcSessionFrees() {
        int sessionBits = 0;
        for (AllocBlock ab : this.m_allocBlocks) {
            sessionBits += ab.sessionBits();
        }
        this.m_sessionFrees.set(sessionBits);
        return true;
    }

    void releaseSession(RWWriteCacheService cache) {
        if (this.m_context != null) {
            throw new IllegalStateException("Calling releaseSession on shadowed allocator");
        }
        if (this.m_sessionActive) {
            int start = this.m_sessionFrees.intValue();
            if (s_islogTrace) {
                log.trace((Object)("Allocator: #" + this.m_index + " releasing session protection"));
            }
            int releasedAllocations = 0;
            for (AllocBlock ab : this.m_allocBlocks) {
                releasedAllocations += ab.releaseSession(cache);
            }
            assert (!this.m_store.isSessionProtected()) : "releaseSession called with isSessionProtected: true";
            this.m_sessionActive = false;
            this.m_freeBits = this.freebits();
            int freebits = this.freebits();
            if (this.m_freeBits > freebits) {
                log.error((Object)("m_freeBits too high: " + this.m_freeBits + " > (calc): " + freebits));
            }
            this.m_freeTransients = this.transientbits();
            this.checkFreeList();
            if (start > releasedAllocations) {
                log.error((Object)("BAD! Allocator: " + this.hashCode() + ", size: " + this.m_size + " m_sessionFrees: " + this.m_sessionFrees.intValue() + " > released: " + releasedAllocations));
            }
            int end = this.m_sessionFrees.getAndSet(0);
            assert (start == end) : "SessionFrees concurrent modification: " + start + " != " + end;
        } else assert (this.m_sessionFrees.intValue() == 0) : "Session Inactive with sessionFrees: " + this.m_sessionFrees.intValue();
    }

    private int freebits() {
        int freeBits = 0;
        for (AllocBlock ab : this.m_allocBlocks) {
            freeBits += ab.freeBits();
        }
        return freeBits;
    }

    private int transientbits() {
        int freeBits = 0;
        for (AllocBlock ab : this.m_allocBlocks) {
            freeBits += ab.transientBits();
        }
        return freeBits;
    }

    @Override
    public long getPhysicalAddress(int offset) {
        return this.getPhysicalAddress(offset, false);
    }

    void setAddressExternal(int latchedAddr) {
        int offset = (-latchedAddr & 0x1FFF) - 3;
        int nbits = 32 * this.m_bitSize;
        int block = offset / nbits;
        int bit = offset % nbits;
        AllocBlock ab = this.m_allocBlocks.get(block);
        if (ab.m_addr == 0) {
            int blockSize = 32 * this.m_bitSize;
            blockSize *= this.m_size;
            ab.m_addr = this.grabAllocation(this.m_store, blockSize >>= 16);
            if (block == 0) {
                this.m_startAddr = ab.m_addr;
            }
        }
        ab.setBitExternal(bit);
        --this.m_freeBits;
    }

    public int getSlotSize() {
        return this.m_size;
    }

    public void computeDigest(Object snapshot, MessageDigest digest) {
        ByteBuffer bb = ByteBuffer.allocate(this.m_size);
        byte[] ba = this.m_index == 0 && s_islogDebug ? bb.array() : null;
        for (AllocBlock b : this.m_allocBlocks) {
            int bits = b.m_commit.length * 32;
            long startAddr = RWStore.convertAddr(b.m_addr);
            for (int i = 0; i < bits; ++i) {
                if (!RWStore.tstBit(b.m_commit, i)) continue;
                long paddr = startAddr + (long)(this.m_size * i);
                bb.position(0);
                this.m_store.readRaw(paddr, bb);
                digest.update(bb);
                if (ba == null) continue;
                log.debug((Object)BytesUtil.toHexString((byte[])ba));
            }
        }
        byte[] data = digest.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : data) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(b);
        }
        log.warn((Object)("ALLOCATOR[" + this.m_index + ":" + this.m_size + "] freeBits: " + this.freebits() + ", DIGEST:" + sb.toString()));
    }

    public void postCommit() {
        boolean protectTransients = this.m_sessionActive || this.m_store.isSessionProtected();
        for (AllocBlock b : this.m_allocBlocks) {
            b.m_commit = (int[])b.m_live.clone();
            if (!protectTransients) {
                b.m_transients = (int[])b.m_live.clone();
            }
            if (this.m_context != null) continue;
            b.m_commit = (int[])b.m_live.clone();
            if (b.m_saveCommit == null) continue;
            if (!this.m_pendingContextCommit) {
                throw new IllegalStateException("Unexpected m_saveCommit when no pending commit");
            }
            b.m_saveCommit = null;
            b.m_isoFrees = null;
        }
        if (this.m_pendingContextCommit) {
            this.m_pendingContextCommit = false;
            if (this.m_freeWaiting && this.meetsSmallSlotThreshold()) {
                this.addToFreeList();
            }
        }
        if (!protectTransients) {
            this.m_freeBits += this.m_freeTransients;
            if (this.m_freeWaiting && this.meetsSmallSlotThreshold()) {
                this.addToFreeList();
            }
            this.m_freeTransients = 0;
        }
        if (s_islogDebug) {
            this.checkBits();
        }
    }

    public int removeFreedWrites(FixedAllocator xfa, ConcurrentWeakValueCache<Long, ICommitter> externalCache) {
        int count = 0;
        for (int i = 0; i < this.m_allocBlocks.size(); ++i) {
            AllocBlock ab = this.m_allocBlocks.get(i);
            AllocBlock xab = xfa.m_allocBlocks.get(i);
            int blockBitOffset = 3 + i * xab.m_commit.length * 32;
            for (int b = 0; b < xab.m_commit.length; ++b) {
                int removed;
                if (xab.m_commit[b] == ab.m_commit[b] || (removed = xab.m_commit[b] & ~ab.m_commit[b]) == 0) continue;
                for (int bit = 0; bit < 32; ++bit) {
                    if ((removed & 1 << bit) == 0) continue;
                    int tstBit = blockBitOffset + b * 32 + bit;
                    if (!xfa.isCommitted(tstBit) || this.isCommitted(tstBit)) {
                        log.error((Object)("Bit problem: " + tstBit));
                    }
                    long paddr = xfa.getPhysicalAddress(tstBit);
                    if (s_islogTrace) {
                        log.trace((Object)("Checking address for removal: " + paddr));
                    }
                    ++count;
                    externalCache.remove((Object)paddr);
                }
            }
        }
        if (s_islogTrace) {
            log.trace((Object)("FA index: " + this.m_index + ", freed: " + count));
        }
        return count;
    }

    public boolean verifyAllocatedAddress(long addr) {
        int startAddr;
        if (s_islogTrace) {
            log.trace((Object)("Checking Allocator " + this.m_index + ", size: " + this.m_size));
        }
        Iterator<AllocBlock> blocks = this.m_allocBlocks.iterator();
        long range = this.m_size * this.m_bitSize * 32;
        while (blocks.hasNext() && (startAddr = blocks.next().m_addr) != 0) {
            long start = RWStore.convertAddr(startAddr);
            long end = start + range;
            if (s_islogTrace) {
                log.trace((Object)("Checking " + addr + " between " + start + " - " + end));
            }
            if (addr < start || addr >= end) continue;
            return true;
        }
        return false;
    }

    void snapshot(AbstractJournal.ISnapshotData tm) {
        if (this.m_diskAddr > 0) {
            tm.put(this.m_store.metaBit2Addr(this.m_diskAddr), this.commitData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] commitData() {
        try {
            byte[] buf = new byte[1024];
            try (DataOutputStream str = new DataOutputStream(new FixedOutputStream(buf));){
                str.writeInt(this.m_size);
                for (AllocBlock block : this.m_allocBlocks) {
                    str.writeInt(block.m_addr);
                    for (int i = 0; i < this.m_bitSize; ++i) {
                        str.writeInt(block.m_commit[i]);
                    }
                }
                int chk = ChecksumUtility.getCHK().checksum(buf, str.size());
                str.writeInt(chk);
            }
            return buf;
        }
        catch (IOException e) {
            throw new StorageTerminalError("Error on write", e);
        }
    }

    public void addToRegionMap(HashMap<Integer, FixedAllocator> map) {
        for (AllocBlock ab : this.m_allocBlocks) {
            FixedAllocator pa;
            if (ab.m_addr == 0 || (pa = map.put(ab.m_addr, this)) == null) continue;
            throw new IllegalStateException("Duplicate mapping Allocators, " + pa.m_index + ", " + this.m_index);
        }
    }
}

