/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.view.FusedView;
import com.bigdata.resources.OverflowSubtaskEnum;
import com.bigdata.service.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class BuildViewMetadata {
    public final long maxSumSegBytes;
    public final int nsources;
    public final int naccepted;
    public final boolean compactingMerge;
    public final int journalCount;
    public final int segmentCount;
    public final long sumEntryCount;
    public final long sumSegBytes;
    public final ILocalBTreeView acceptedView;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{nsources=" + this.nsources);
        sb.append(",naccepted=" + this.naccepted);
        sb.append(",compactingMerge=" + this.compactingMerge);
        sb.append(",journalCount=" + this.journalCount);
        sb.append(",segmentCount=" + this.segmentCount);
        sb.append(",sumEntryCount=" + this.sumEntryCount);
        sb.append(",sumSegBytes=" + this.sumSegBytes);
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildViewMetadata(ILocalBTreeView src, long maxSumSegBytes, Event parentEvent) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (maxSumSegBytes < 0L) {
            throw new IllegalArgumentException();
        }
        Event e = parentEvent.newSubEvent((Object)OverflowSubtaskEnum.ChooseView).start();
        try {
            this.maxSumSegBytes = maxSumSegBytes;
            AbstractBTree[] sources = src.getSources();
            this.nsources = sources.length;
            ArrayList<AbstractBTree> accepted = new ArrayList<AbstractBTree>(this.nsources);
            accepted.add(sources[0]);
            int journalCount = 1;
            int segmentCount = 0;
            long sumEntryCount = sources[0].getEntryCount();
            long sumSegBytes = 0L;
            for (int i = 1; i < sources.length; ++i) {
                long segBytes;
                AbstractBTree s = sources[i];
                long entryCount = s.getEntryCount();
                boolean isJournal = !(s instanceof IndexSegment);
                long l = segBytes = isJournal ? 0L : s.getStore().size();
                if (sumSegBytes + segBytes > maxSumSegBytes) break;
                sumEntryCount += entryCount;
                if (isJournal) {
                    ++journalCount;
                } else {
                    ++segmentCount;
                }
                sumSegBytes += segBytes;
                accepted.add(s);
            }
            this.journalCount = journalCount;
            this.segmentCount = segmentCount;
            this.sumEntryCount = sumEntryCount;
            this.sumSegBytes = sumSegBytes;
            this.compactingMerge = accepted.size() == sources.length;
            this.naccepted = accepted.size();
            this.acceptedView = this.naccepted == 1 ? (BTree)accepted.get(0) : new FusedView(accepted.toArray(new AbstractBTree[this.naccepted]));
            e.addDetails(this.getParams());
        }
        finally {
            e.end();
        }
    }

    public Map<String, Object> getParams() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("maxSumSegBytes", this.maxSumSegBytes);
        m.put("nsources", this.nsources);
        m.put("naccepted", this.naccepted);
        m.put("compactingMerge", this.compactingMerge);
        m.put("journalCount", this.journalCount);
        m.put("segmentCount", this.segmentCount);
        m.put("sumEntryCount", this.sumEntryCount);
        m.put("sumSegBytes", this.sumSegBytes);
        return m;
    }
}

