/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule;

import com.bigdata.relation.rule.ISlice;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;

public class Slice
implements ISlice,
Externalizable {
    private static final long serialVersionUID = 5396509164843609197L;
    private long offset;
    private long limit;
    private long last;
    public static final transient ISlice ALL = new Slice(0L, Long.MAX_VALUE);

    public Slice(long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException();
        }
        if (limit <= 0L) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.limit = limit;
        this.last = BigInteger.valueOf(offset).add(BigInteger.valueOf(limit)).min(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public long getLast() {
        return this.last;
    }

    public String toString() {
        return "Slice{offset=" + this.offset + ", limit=" + this.limit + ", last=" + this.last + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.offset = in.readLong();
        this.limit = in.readLong();
        this.last = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.offset);
        out.writeLong(this.limit);
        out.writeLong(this.last);
    }
}

