/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule;

import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IQueryOptions;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.QueryOptions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class Program
implements IProgram {
    private static final long serialVersionUID = 2774954504183880320L;
    protected static final transient Logger log = Logger.getLogger(Program.class);
    private final String name;
    private final boolean parallel;
    private final boolean closure;
    private final IQueryOptions queryOptions;
    private final List<IStep> steps = new LinkedList<IStep>();
    private static final transient int inc = 1;
    private static final transient String ws = "...............................................";

    public Program(String name, boolean parallel) {
        this(name, parallel, false, QueryOptions.NONE);
    }

    public Program(String name, boolean parallel, IQueryOptions queryOptions) {
        this(name, parallel, false, queryOptions);
    }

    protected Program(String name, boolean parallel, boolean closure) {
        this(name, parallel, closure, QueryOptions.NONE);
    }

    private Program(String name, boolean parallel, boolean closure, IQueryOptions queryOptions) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (queryOptions == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.parallel = parallel;
        this.closure = closure;
        this.queryOptions = queryOptions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final boolean isRule() {
        return false;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }

    @Override
    public boolean isClosure() {
        return this.closure;
    }

    @Override
    public IQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public int stepCount() {
        return this.steps.size();
    }

    @Override
    public Iterator<IStep> steps() {
        return this.steps.iterator();
    }

    @Override
    public IStep[] toArray() {
        return this.steps.toArray(new IStep[this.stepCount()]);
    }

    public void addStep(IStep step) {
        if (step == null) {
            throw new IllegalArgumentException();
        }
        if (step == this) {
            throw new IllegalArgumentException();
        }
        this.steps.add(step);
    }

    public void addSteps(Iterator<? extends IStep> steps) {
        if (steps == null) {
            throw new IllegalArgumentException();
        }
        while (steps.hasNext()) {
            this.addStep(steps.next());
        }
    }

    public void addClosureOf(IRule[] rules) {
        if (this.isParallel()) {
            throw new IllegalStateException("parallel program can not embed closure operations.");
        }
        if (rules == null) {
            throw new IllegalArgumentException();
        }
        if (rules.length == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("closure[");
        int i = 0;
        for (IRule r : rules) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(r.getName());
        }
        sb.append("]");
        String label = sb.toString();
        Program subProgram = new Program(label, true, true);
        subProgram.addSteps(Arrays.asList(rules).iterator());
        this.addStep(subProgram);
    }

    public void addClosureOf(IRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        this.addClosureOf(new IRule[]{rule});
    }

    protected StringBuilder toString(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(ws, 0, depth);
        sb.append(this.getClass().getSimpleName());
        sb.append("{ name=" + this.getName());
        sb.append(", parallel=" + this.isParallel());
        sb.append(", closure=" + this.isClosure());
        sb.append(", nsteps=" + this.stepCount());
        sb.append("}");
        for (IStep step : this.steps) {
            sb.append("\n");
            if (step.isRule()) {
                sb.append(ws, 0, depth + 1);
                sb.append(step.toString());
                continue;
            }
            sb.append((CharSequence)((Program)step).toString(depth + 1));
        }
        return sb;
    }

    @Override
    public String toString() {
        return this.toString(0).toString();
    }
}

