/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.accesspath;

import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import java.util.LinkedHashSet;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;

public class MultiplexBlockingBuffer<E> {
    private final IBlockingBuffer<E> b;
    private final ReentrantLock lock = new ReentrantLock();
    private final LinkedHashSet<IBlockingBuffer<E>> set = new LinkedHashSet();
    private int counter = 0;

    public MultiplexBlockingBuffer(IBlockingBuffer<E> b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        this.b = b;
    }

    public boolean isOpen() {
        return this.b.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlockingBuffer<E> newInstance() {
        this.lock.lock();
        try {
            if (!this.isOpen()) {
                throw new BufferClosedException();
            }
            InnerBlockingBuffer n = new InnerBlockingBuffer();
            if (!this.set.add(n)) {
                throw new AssertionError();
            }
            ++this.counter;
            InnerBlockingBuffer innerBlockingBuffer = n;
            return innerBlockingBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndCloseAll() {
        this.lock.lock();
        try {
            for (IBlockingBuffer iBlockingBuffer : this.set) {
                iBlockingBuffer.close();
            }
            assert (this.counter == 0);
            this.b.flush();
            this.b.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public IBlockingBuffer<E> getBackingBuffer() {
        return this.b;
    }

    private class InnerBlockingBuffer
    implements IBlockingBuffer<E> {
        private boolean innerBufferOpen = true;

        protected InnerBlockingBuffer() {
        }

        @Override
        public IAsynchronousIterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFuture(Future future) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(Throwable cause) {
            MultiplexBlockingBuffer.this.lock.lock();
            try {
                if (!this.innerBufferOpen) {
                    throw new BufferClosedException();
                }
                MultiplexBlockingBuffer.this.b.abort(cause);
            }
            finally {
                MultiplexBlockingBuffer.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            MultiplexBlockingBuffer.this.lock.lock();
            try {
                if (!this.innerBufferOpen) {
                    return;
                }
                this.innerBufferOpen = false;
                if (!MultiplexBlockingBuffer.this.set.remove(this)) {
                    throw new AssertionError();
                }
                MultiplexBlockingBuffer.this.counter--;
                if (MultiplexBlockingBuffer.this.counter == 0) {
                    MultiplexBlockingBuffer.this.b.flush();
                    MultiplexBlockingBuffer.this.b.close();
                }
            }
            finally {
                MultiplexBlockingBuffer.this.lock.unlock();
            }
        }

        @Override
        public Future getFuture() {
            return MultiplexBlockingBuffer.this.b.getFuture();
        }

        @Override
        public boolean isOpen() {
            return this.innerBufferOpen && MultiplexBlockingBuffer.this.b.isOpen();
        }

        @Override
        public long flush() {
            return 0L;
        }

        @Override
        public void add(E e) {
            if (!this.innerBufferOpen) {
                throw new BufferClosedException();
            }
            MultiplexBlockingBuffer.this.b.add(e);
        }

        @Override
        public boolean isEmpty() {
            return MultiplexBlockingBuffer.this.b.isEmpty();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return MultiplexBlockingBuffer.this.b.size();
        }
    }
}

