/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.engine.SolutionsLog;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.striterator.AbstractChunkedResolverator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class BigdataBindingSetResolverator
extends AbstractChunkedResolverator<IBindingSet, IBindingSet, AbstractTripleStore> {
    private static final Logger log = Logger.getLogger(BigdataBindingSetResolverator.class);
    private final UUID queryId;
    private final IVariable[] required;
    private final int termsChunkSize;
    private final int blobsChunkSize;

    public BigdataBindingSetResolverator(AbstractTripleStore db, IChunkedOrderedIterator<IBindingSet> src, UUID queryId, IVariable[] required, int chunkOfChunksCapacity, int chunkCapacity, long chunkTimeout, int termsChunkSize, int blobsChunkSize) {
        super(db, src, new BlockingBuffer<F[]>(chunkOfChunksCapacity, chunkCapacity, chunkTimeout, TimeUnit.MILLISECONDS));
        this.queryId = queryId;
        this.required = required;
        this.termsChunkSize = termsChunkSize;
        this.blobsChunkSize = blobsChunkSize;
    }

    public BigdataBindingSetResolverator start(ExecutorService service) {
        return (BigdataBindingSetResolverator)super.start(service);
    }

    protected IBindingSet[] resolveChunk(IBindingSet[] chunk) {
        return this.resolveChunk(((AbstractTripleStore)this.state).getLexiconRelation(), chunk);
    }

    private IBindingSet[] resolveChunk(LexiconRelation lex, IBindingSet[] chunk) {
        return BigdataBindingSetResolverator.resolveChunk(this.queryId, lex, chunk, this.required, this.termsChunkSize, this.blobsChunkSize);
    }

    private static IBindingSet[] resolveChunk(UUID queryId, LexiconRelation lex, IBindingSet[] chunk, IVariable<?>[] required, int termsChunkSize, int blobsChunkSize) {
        long begin = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fetched chunk: size=" + chunk.length + ", chunk=" + Arrays.toString(chunk)));
        }
        int initialCapacity = required == null ? chunk.length : (required.length == 0 ? 1 : chunk.length * required.length);
        HashSet ids = new HashSet(initialCapacity);
        IBindingSet[] arr$ = chunk;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IBindingSet solution;
            IBindingSet bindingSet = solution = arr$[i$];
            assert (bindingSet != null);
            if (required == null) {
                for (Map.Entry entry : bindingSet) {
                    IV iv = (IV)((IConstant)entry.getValue()).get();
                    if (iv == null) {
                        throw new RuntimeException("NULL? : var=" + entry.getKey() + ", " + bindingSet);
                    }
                    BigdataBindingSetResolverator.handleIV(iv, ids);
                }
                continue;
            }
            for (IVariable<?> v : required) {
                IConstant c = bindingSet.get(v);
                if (c == null) continue;
                IV iv = (IV)c.get();
                if (iv == null) {
                    throw new RuntimeException("NULL? : var=" + v + ", " + bindingSet);
                }
                BigdataBindingSetResolverator.handleIV(iv, ids);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving " + ids.size() + " IVs, required=" + Arrays.toString(required)));
        }
        Map<IV<?, ?>, BigdataValue> terms = lex.getTerms(ids, termsChunkSize, blobsChunkSize);
        Object[] chunk2 = new IBindingSet[chunk.length];
        int i = 0;
        for (IBindingSet e : chunk) {
            IBindingSet f = BigdataBindingSetResolverator.getBindingSet(e, required, terms);
            chunk2[i++] = f;
        }
        if (SolutionsLog.INFO) {
            SolutionsLog.log(queryId, null, -1, -1, (IBindingSet[])chunk2);
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved chunk: size=" + chunk2.length + ", chunk=" + Arrays.toString(chunk2)));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Resolved chunk: size=" + chunk2.length + ", elapsed=" + elapsed));
        }
        return chunk2;
    }

    private static void handleIV(IV<?, ?> iv, Collection<IV<?, ?>> ids) {
        if (iv instanceof SidIV) {
            BigdataBindingSetResolverator.handleSid((SidIV)iv, ids);
        }
        ids.add(iv);
    }

    private static void handleSid(SidIV<?> sid, Collection<IV<?, ?>> ids) {
        ISPO spo = sid.getInlineValue();
        BigdataBindingSetResolverator.handleIV(spo.s(), ids);
        BigdataBindingSetResolverator.handleIV(spo.p(), ids);
        BigdataBindingSetResolverator.handleIV(spo.o(), ids);
        if (spo.c() != null) {
            BigdataBindingSetResolverator.handleIV(spo.c(), ids);
        }
    }

    private static IBindingSet getBindingSet(IBindingSet solution, IVariable<?>[] required, Map<IV<?, ?>, BigdataValue> terms) {
        if (solution == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        IBindingSet bindingSet = required == null ? solution : solution.copy(required);
        for (Map.Entry entry : bindingSet) {
            IV iv;
            Object boundValue = ((IConstant)entry.getValue()).get();
            if (!(boundValue instanceof IV) || (iv = (IV)boundValue).hasValue()) continue;
            BigdataValue value = terms.get(iv);
            if (value == null) {
                throw new RuntimeException("Could not resolve: iv=" + iv);
            }
            bindingSet.set((IVariable)entry.getKey(), new Constant<BigdataValue>(value));
        }
        return bindingSet;
    }
}

