/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.ModifiedEnum;
import com.bigdata.rdf.spo.SPOIndexWriteProc;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.relation.accesspath.IElementFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public class SPOIndexWriter
implements Callable<Long> {
    private final ISPO[] stmts;
    private final int numStmts;
    private final IElementFilter<ISPO> filter;
    private final AtomicLong sortTime;
    private final AtomicLong insertTime;
    private final AtomicLong numWritten;
    private final Comparator<ISPO> comparator;
    private final IIndex ndx;
    private final boolean reportMutation;
    private final boolean primaryIndex;
    private final boolean quads;
    private final boolean sids;

    public SPOIndexWriter(SPORelation spoRelation, ISPO[] a, int numStmts, boolean clone, SPOKeyOrder keyOrder, boolean primaryIndex, IElementFilter<ISPO> filter, AtomicLong sortTime, AtomicLong insertTime, AtomicLong numWritten, boolean reportMutations) {
        if (spoRelation == null) {
            throw new IllegalArgumentException();
        }
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        this.primaryIndex = primaryIndex;
        this.filter = filter;
        if (clone) {
            this.stmts = new ISPO[numStmts];
            System.arraycopy(a, 0, this.stmts, 0, numStmts);
        } else {
            this.stmts = a;
        }
        this.numStmts = numStmts;
        this.sortTime = sortTime;
        this.insertTime = insertTime;
        this.numWritten = numWritten;
        this.comparator = keyOrder.getComparator();
        this.reportMutation = reportMutations;
        this.ndx = spoRelation.getIndex(keyOrder);
        assert (this.ndx != null);
        this.quads = keyOrder.getKeyArity() == 4;
        this.sids = spoRelation.getStatementIdentifiers();
    }

    @Override
    public Long call() throws Exception {
        long begin = System.currentTimeMillis();
        Arrays.sort(this.stmts, 0, this.numStmts, this.comparator);
        this.sortTime.addAndGet(System.currentTimeMillis() - begin);
        SPOTupleSerializer tupleSer = (SPOTupleSerializer)this.ndx.getIndexMetadata().getTupleSerializer();
        int numToAdd = 0;
        Object last = null;
        byte[][] keys = new byte[this.numStmts][];
        byte[][] vals = new byte[this.numStmts][];
        ISPO[] denseStmts = this.reportMutation ? new ISPO[this.numStmts] : null;
        for (int i = 0; i < this.numStmts; ++i) {
            ISPO spo = this.stmts[i];
            if (spo == null) {
                throw new IllegalArgumentException("null @ index=" + i);
            }
            if (!spo.isFullyBound()) {
                throw new IllegalArgumentException("Not fully bound: " + spo.toString());
            }
            if (this.quads) {
                if (spo.c() == null) {
                    throw new IllegalArgumentException("context not bound: " + spo);
                }
            } else if (!this.sids && spo.c() != null) {
                throw new IllegalArgumentException("context bound, but not quads or sids: " + spo);
            }
            if (this.filter != null && this.filter.isValid(spo) || last != null && last.equals(spo) && (!this.quads || last.c().equals(spo.c()))) continue;
            keys[numToAdd] = tupleSer.serializeKey(spo);
            vals[numToAdd] = tupleSer.serializeVal(spo);
            if (this.reportMutation) {
                denseStmts[numToAdd] = spo;
            }
            last = spo;
            ++numToAdd;
        }
        long _begin = System.currentTimeMillis();
        long writeCount = 0L;
        if (this.reportMutation) {
            AbstractKeyArrayIndexProcedure.ResultBitBufferHandler aggregator = new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(numToAdd, 2);
            this.ndx.submit(0, numToAdd, keys, vals, SPOIndexWriteProc.IndexWriteProcConstructor.REPORT_MUTATION, aggregator);
            AbstractKeyArrayIndexProcedure.ResultBitBuffer modified = aggregator.getResult();
            boolean[] bits = modified.getResult();
            ModifiedEnum[] m = ModifiedEnum.fromBooleans(bits, bits.length);
            for (int i = 0; i < numToAdd; ++i) {
                if (m[i] == ModifiedEnum.NONE) continue;
                denseStmts[i].setModified(m[i]);
                ++writeCount;
            }
        } else {
            LongAggregator aggregator = new LongAggregator();
            this.ndx.submit(0, numToAdd, keys, vals, SPOIndexWriteProc.IndexWriteProcConstructor.INSTANCE, aggregator);
            writeCount = aggregator.getResult();
        }
        this.insertTime.addAndGet(System.currentTimeMillis() - _begin);
        if (this.primaryIndex) {
            this.numWritten.addAndGet(writeCount);
        }
        return System.currentTimeMillis() - begin;
    }
}

