/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SPOArrayIterator
implements IChunkedOrderedIterator<ISPO> {
    private static final long MAX_CAPACITY = 10000000L;
    private boolean open = true;
    private AbstractTripleStore db;
    private final IKeyOrder<ISPO> keyOrder;
    private ISPO[] stmts;
    private int numStmts;
    private int i = 0;
    private ISPO current = null;

    public int getStatementCount() {
        return this.numStmts;
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.keyOrder;
    }

    public SPOArrayIterator(ISPO[] stmts, int numStmts) {
        this.db = null;
        this.keyOrder = null;
        this.stmts = stmts;
        this.numStmts = numStmts;
    }

    public SPOArrayIterator(AbstractTripleStore db, IAccessPath<ISPO> accessPath, int limit, IElementFilter<ISPO> filter) {
        if (accessPath == null) {
            throw new IllegalArgumentException();
        }
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.db = db;
        this.keyOrder = accessPath.getKeyOrder();
        long rangeCount = accessPath.rangeCount(false);
        if (rangeCount >= 10000000L) {
            throw new RuntimeException("Too many statements to read into memory: rangeCount=" + rangeCount + ", maxCapacity=" + 10000000L);
        }
        int n = (int)(limit > 0 ? Math.min(rangeCount, (long)limit) : rangeCount);
        this.stmts = new ISPO[n];
        IChunkedOrderedIterator<ISPO> itr = accessPath.iterator(0L, n, 0);
        int i = 0;
        while (itr.hasNext()) {
            ISPO spo = (ISPO)itr.next();
            this.stmts[i++] = spo;
        }
        this.numStmts = i;
    }

    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        assert (this.i <= this.numStmts);
        return this.i != this.numStmts;
    }

    @Override
    public ISPO next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.stmts[this.i++];
        return this.current;
    }

    @Override
    public void remove() {
        this.assertOpen();
        if (this.db == null) {
            throw new UnsupportedOperationException();
        }
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.db.removeStatements(new ISPO[]{this.current}, 1);
        this.current = null;
    }

    public ISPO[] array() {
        this.assertOpen();
        return this.stmts;
    }

    public ISPO[] nextChunk() {
        ISPO[] ret;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.i == 0 && this.numStmts == this.stmts.length) {
            ret = this.stmts;
        } else {
            int remaining = this.numStmts - this.i;
            ret = new ISPO[remaining];
            System.arraycopy(this.stmts, this.i, ret, 0, remaining);
        }
        this.i = this.numStmts;
        return ret;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (keyOrder != this.keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.db = null;
        this.stmts = null;
        this.current = null;
        this.numStmts = 0;
        this.i = 0;
    }

    private final void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException();
        }
    }
}

