/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;

public class AskOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSet = input.getBindingSets();
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (queryRoot.getQueryType() != QueryType.ASK) {
            return new QueryNodeWithBindingSet(queryRoot, bindingSet);
        }
        if (queryRoot.getGroupBy() != null && !queryRoot.getGroupBy().isEmpty()) {
            return new QueryNodeWithBindingSet(queryRoot, bindingSet);
        }
        if (queryRoot.getHaving() != null && !queryRoot.getHaving().isEmpty()) {
            return new QueryNodeWithBindingSet(queryRoot, bindingSet);
        }
        SliceNode slice = queryRoot.getSlice();
        if (slice == null) {
            slice = new SliceNode();
            queryRoot.setSlice(slice);
        }
        if (slice.getLimit() > 1L) {
            slice.setLimit(1L);
        }
        return new QueryNodeWithBindingSet(queryRoot, bindingSet);
    }
}

