/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.engine.StaticAnalysisStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class ASTRangeCountOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTRangeCountOptimizer.class);

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        List<StatementPatternNode> spNodes = group.getStatementPatterns();
        if (!spNodes.isEmpty()) {
            int nrExogeneousBindings = bSets == null ? 0 : bSets.length;
            this.attachRangeCounts(ctx, spNodes, ASTRangeCountOptimizer.getExogenousBindings(bSets), nrExogeneousBindings);
        }
    }

    protected void attachRangeCounts(AST2BOpContext ctx, List<StatementPatternNode> spNodes, IBindingSet exogenousBindings, int nrExogeneousBindings) {
        List futures;
        AbstractTripleStore db = ctx.getAbstractTripleStore();
        LinkedList<RangeCountTask> tasks = new LinkedList<RangeCountTask>();
        for (StatementPatternNode sp : spNodes) {
            if (sp.getProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY) != null) continue;
            tasks.add(new RangeCountTask(sp, ctx, exogenousBindings, nrExogeneousBindings));
        }
        try {
            futures = db.getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        LinkedList<Exception> causes = new LinkedList<Exception>();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                causes.add(e);
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                causes.add(e);
            }
        }
        if (!causes.isEmpty()) {
            if (causes.size() == 1) {
                throw new RuntimeException((Throwable)causes.get(0));
            }
            throw new RuntimeException("nerrors=" + causes.size(), new ExecutionExceptions(causes));
        }
    }

    protected void estimateCardinality(StatementPatternNode sp, AST2BOpContext ctx, IBindingSet exogenousBindings, int nrExogeneousBindings) {
        AtomicBoolean usesExogeneousBindings = new AtomicBoolean(false);
        IV s = ASTRangeCountOptimizer.getIV(sp.s(), exogenousBindings, usesExogeneousBindings);
        IV p = ASTRangeCountOptimizer.getIV(sp.p(), exogenousBindings, usesExogeneousBindings);
        IV o = ASTRangeCountOptimizer.getIV(sp.o(), exogenousBindings, usesExogeneousBindings);
        IV c = ASTRangeCountOptimizer.getIV(sp.c(), exogenousBindings, usesExogeneousBindings);
        int exogenousBindingsAdjustmentFactor = usesExogeneousBindings.get() ? Math.max(1, nrExogeneousBindings) : 1;
        this.estimateCardinalities(sp, s, p, o, c, ctx, exogenousBindingsAdjustmentFactor);
    }

    protected void estimateCardinalities(StatementPatternNode sp, IV<?, ?> s, IV<?, ?> p, IV<?, ?> o, IV<?, ?> c, AST2BOpContext ctx, int exogenousBindingsAdjustmentFactor) {
        AbstractTripleStore db = ctx.getAbstractTripleStore();
        RangeNode rangeNode = sp.getRange();
        RangeBOp range = rangeNode != null ? rangeNode.getRangeBOp() : null;
        IAccessPath<ISPO> ap = db.getAccessPath(s, p, o, c, range);
        StaticAnalysisStats saStats = ctx.getStaticAnalysisStats();
        long start = System.nanoTime();
        long cardinality = ap.rangeCount(false);
        saStats.registerRangeCountCall(System.nanoTime() - start);
        sp.setProperty(ASTStaticJoinOptimizer.Annotations.ESTIMATED_CARDINALITY, cardinality * (long)exogenousBindingsAdjustmentFactor);
        sp.setProperty(ASTStaticJoinOptimizer.Annotations.ORIGINAL_INDEX, ap.getKeyOrder());
    }

    protected static IV getIV(TermNode term, IBindingSet exogenousBindings, AtomicBoolean usesExogeneousBinding) {
        IConstant c;
        if (term != null && term.isVariable() && exogenousBindings != null && (c = exogenousBindings.get((IVariable)term.getValueExpression())) != null) {
            usesExogeneousBinding.set(true);
            return (IV)c.get();
        }
        if (term != null && term.isConstant()) {
            IV iv = (IV)((IConstant)term.getValueExpression()).get();
            if (iv == null) {
                throw new AssertionError((Object)"this optimizer cannot run with unknown IVs in statement patterns");
            }
            return iv;
        }
        return null;
    }

    private static IBindingSet getExogenousBindings(IBindingSet[] bindingSets) {
        if (bindingSets == null || bindingSets.length == 0) {
            return null;
        }
        return bindingSets[0];
    }

    private class RangeCountTask
    implements Callable<Void> {
        private final StatementPatternNode sp;
        private final AST2BOpContext ctx;
        private final IBindingSet exogenousBindings;
        private final int nrExogeneousBindings;

        public RangeCountTask(StatementPatternNode sp, AST2BOpContext ctx, IBindingSet exogenousBindings, int nrExogeneousBindings) {
            this.sp = sp;
            this.ctx = ctx;
            this.exogenousBindings = exogenousBindings;
            this.nrExogeneousBindings = nrExogeneousBindings;
        }

        @Override
        public Void call() throws Exception {
            ASTRangeCountOptimizer.this.estimateCardinality(this.sp, this.ctx, this.exogenousBindings, this.nrExogeneousBindings);
            return null;
        }
    }
}

