/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.PipelineJoin;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.constraints.RangeBOp;
import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTGeoSpatialSearchOptimizer;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.optimizers.ASTRangeOptimizer;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.ChunkConsumerIterator;
import com.bigdata.relation.accesspath.UnsynchronizedArrayBuffer;
import com.bigdata.service.geospatial.GeoSpatial;
import com.bigdata.service.geospatial.GeoSpatialConfig;
import com.bigdata.service.geospatial.GeoSpatialCounters;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import com.bigdata.service.geospatial.GeoSpatialDatatypeFieldConfiguration;
import com.bigdata.service.geospatial.GeoSpatialSearchException;
import com.bigdata.service.geospatial.IGeoSpatialLiteralSerializer;
import com.bigdata.service.geospatial.IGeoSpatialQuery;
import com.bigdata.service.geospatial.ZOrderIndexBigMinAdvancer;
import com.bigdata.service.geospatial.impl.GeoSpatialQuery;
import com.bigdata.service.geospatial.impl.GeoSpatialUtility;
import com.bigdata.util.concurrent.Haltable;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class GeoSpatialServiceFactory
extends AbstractServiceFactoryBase {
    private static final Logger log = Logger.getLogger(GeoSpatialServiceFactory.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public GeoSpatialServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public BigdataServiceCall create(ServiceCallCreateParams createParams) {
        if (createParams == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = createParams.getTripleStore();
        Properties props = store.getIndexManager() != null && store.getIndexManager() instanceof AbstractJournal ? ((AbstractJournal)store.getIndexManager()).getProperties() : null;
        GeoSpatialDefaults dflts = new GeoSpatialDefaults(props);
        ServiceNode serviceNode = createParams.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        Map<IVariable<?>, Map<URI, StatementPatternNode>> map = this.verifyGraphPattern(store, serviceNode.getGraphPattern());
        if (map == null) {
            throw new RuntimeException("Not a geospatial service request.");
        }
        if (map.size() != 1) {
            throw new RuntimeException("Multiple geospatial service requests may not be combined.");
        }
        Map.Entry<IVariable<?>, Map<URI, StatementPatternNode>> e = map.entrySet().iterator().next();
        IVariable<?> searchVar = e.getKey();
        Map<URI, StatementPatternNode> statementPatterns = e.getValue();
        this.validateSearch(searchVar, statementPatterns);
        Integer maxParallel = serviceNode.getQueryHintAsInteger(PipelineOp.Annotations.MAX_PARALLEL, 5);
        Integer minDatapointsPerTask = serviceNode.getQueryHintAsInteger(PipelineJoin.Annotations.MIN_DATAPOINTS_PER_TASK, 100000);
        Integer numTasksPerThread = serviceNode.getQueryHintAsInteger(PipelineJoin.Annotations.NUM_TASKS_PER_THREAD, 1);
        Integer threadLocalBufferCapacity = serviceNode.getQueryHintAsInteger(BufferAnnotations.CHUNK_CAPACITY, 100);
        Integer globalBufferChunkOfChunksCapacity = serviceNode.getQueryHintAsInteger(BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY, 5);
        if (DEBUG) {
            log.debug((Object)("maxParallel=" + maxParallel));
            log.debug((Object)("numTasksPerThread=" + numTasksPerThread));
            log.debug((Object)("threadLocalBufferCapacity=" + threadLocalBufferCapacity));
            log.debug((Object)("globalBufferChunkOfChunksCapacity=" + globalBufferChunkOfChunksCapacity));
        }
        if (!store.getLexiconRelation().getLexiconConfiguration().isGeoSpatial()) {
            throw new GeoSpatialSearchException("Geospatial is disabled. Please enable geospatial and reload your data.");
        }
        return new GeoSpatialServiceCall(searchVar, statementPatterns, this.getServiceOptions(), dflts, store, maxParallel, numTasksPerThread * maxParallel, minDatapointsPerTask, threadLocalBufferCapacity, globalBufferChunkOfChunksCapacity, createParams.getStats());
    }

    private Map<IVariable<?>, Map<URI, StatementPatternNode>> verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            LinkedHashMap<URI, StatementPatternNode> statementPatterns;
            BOp child = group.get(i);
            if (child instanceof GroupNodeBase) {
                throw new RuntimeException("Nested groups are not allowed.");
            }
            if (!(child instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)child;
            TermNode p = sp.p();
            if (!p.isConstant()) {
                throw new RuntimeException("Expecting geospatial predicate: " + sp);
            }
            URI uri = (URI)((ConstantNode)p).getValue();
            if (!uri.stringValue().startsWith("http://www.bigdata.com/rdf/geospatial#")) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            if (!ASTGeoSpatialSearchOptimizer.searchUris.contains(uri)) {
                throw new RuntimeException("Unknown geospatial magic predicate: " + uri);
            }
            TermNode s = sp.s();
            if (!s.isVariable()) {
                throw new RuntimeException("Subject of geospatial search pattern must not be a constant: " + sp);
            }
            IVariable<IV> searchVar = ((VarNode)s).getValueExpression();
            if (tmp == null) {
                tmp = new LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>>();
            }
            if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                tmp.put(searchVar, statementPatterns);
            }
            statementPatterns.put(uri, sp);
        }
        return tmp;
    }

    private void validateSearch(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (StatementPatternNode sp : statementPatterns.values()) {
            URI uri = (URI)sp.p().getValue();
            if (!uris.add(uri)) {
                throw new RuntimeException("Search predicate appears multiple times for same search variable: predicate=" + uri + ", searchVar=" + searchVar);
            }
            if (uri.equals((Object)GeoSpatial.PREDICATE) || uri.equals((Object)GeoSpatial.CONTEXT)) {
                this.assertObjectIsURI(sp);
                continue;
            }
            if (uri.equals((Object)GeoSpatial.LOCATION_VALUE) || uri.equals((Object)GeoSpatial.TIME_VALUE) || uri.equals((Object)GeoSpatial.LAT_VALUE) || uri.equals((Object)GeoSpatial.LON_VALUE) || uri.equals((Object)GeoSpatial.LITERAL_VALUE) || uri.equals((Object)GeoSpatial.COORD_SYSTEM_VALUE) || uri.equals((Object)GeoSpatial.CUSTOM_FIELDS_VALUES) || uri.equals((Object)GeoSpatial.LOCATION_AND_TIME_VALUE)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            if (uri.equals((Object)GeoSpatial.SEARCH_DATATYPE)) {
                this.assertObjectIsUriOrVariable(sp);
                continue;
            }
            this.assertObjectIsLiteralOrVariable(sp);
        }
    }

    private void assertObjectIsURI(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (o instanceof URI) {
            throw new IllegalArgumentException("Object is not a URI: " + sp);
        }
    }

    private void assertObjectIsUriOrVariable(StatementPatternNode sp) {
        boolean isNotVariable;
        TermNode o = sp.o();
        boolean isNotUri = !o.isConstant() || !(((ConstantNode)o).getValue() instanceof URI);
        boolean bl = isNotVariable = !o.isVariable();
        if (isNotUri && isNotVariable) {
            throw new IllegalArgumentException("Object is not uri or variable: " + sp);
        }
    }

    private void assertObjectIsLiteralOrVariable(StatementPatternNode sp) {
        boolean isNotVariable;
        TermNode o = sp.o();
        boolean isNotLiteral = !o.isConstant() || !(((ConstantNode)o).getValue() instanceof Literal);
        boolean bl = isNotVariable = !o.isVariable();
        if (isNotLiteral && isNotVariable) {
            throw new IllegalArgumentException("Object is not literal or variable: " + sp);
        }
    }

    private void assertObjectIsVariable(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isVariable()) {
            throw new IllegalArgumentException("Object is not a variable: " + sp);
        }
    }

    Collection<StatementPatternNode> getStatementPatterns(ServiceNode serviceNode) {
        ArrayList<StatementPatternNode> statementPatterns = new ArrayList<StatementPatternNode>();
        for (IGroupMemberNode child : serviceNode.getGraphPattern()) {
            if (child instanceof StatementPatternNode) {
                statementPatterns.add((StatementPatternNode)child);
                continue;
            }
            throw new GeoSpatialSearchException("Nested groups are not allowed.");
        }
        return statementPatterns;
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(ServiceNode serviceNode) {
        HashSet requiredBound = new HashSet();
        for (StatementPatternNode sp : this.getStatementPatterns(serviceNode)) {
            URI predicate = (URI)sp.p().getValue();
            IVariableOrConstant<IV> object = sp.o().getValueExpression();
            if (!(object instanceof IVariable) || !predicate.equals((Object)GeoSpatial.PREDICATE) && !predicate.equals((Object)GeoSpatial.SEARCH) && !predicate.equals((Object)GeoSpatial.SEARCH_DATATYPE) && !predicate.equals((Object)GeoSpatial.CONTEXT) && !predicate.equals((Object)GeoSpatial.SPATIAL_CIRCLE_CENTER) && !predicate.equals((Object)GeoSpatial.SPATIAL_CIRCLE_RADIUS) && !predicate.equals((Object)GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST) && !predicate.equals((Object)GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST) && !predicate.equals((Object)GeoSpatial.SPATIAL_UNIT) && !predicate.equals((Object)GeoSpatial.TIME_START) && !predicate.equals((Object)GeoSpatial.TIME_END) && !predicate.equals((Object)GeoSpatial.COORD_SYSTEM) && !predicate.equals((Object)GeoSpatial.CUSTOM_FIELDS) && !predicate.equals((Object)GeoSpatial.CUSTOM_FIELDS_LOWER_BOUNDS) && !predicate.equals((Object)GeoSpatial.CUSTOM_FIELDS_UPPER_BOUNDS)) continue;
            requiredBound.add((IVariable)object);
        }
        return requiredBound;
    }

    public static class GeoSpatialServiceCallConfiguration {
        private GeoSpatialDefaults defaults = null;
        private GeoSpatialConfig geoSpatialConfig = null;
        private TermNode searchFunction = null;
        private TermNode predicate = null;
        private TermNode searchDatatype = null;
        private TermNode context = null;
        private TermNode spatialCircleCenter = null;
        private TermNode spatialCircleRadius = null;
        private TermNode spatialRectangleSouthWest = null;
        private TermNode spatialRectangleNorthEast = null;
        private TermNode spatialUnit = null;
        private TermNode timeStart = null;
        private TermNode timeEnd = null;
        private TermNode coordSystem = null;
        private TermNode customFields = null;
        private TermNode customFieldsLowerBounds = null;
        private TermNode customFieldsUpperBounds = null;
        private IVariable<?> searchVar = null;
        private IVariable<?> locationVar = null;
        private IVariable<?> locationAndTimeVar = null;
        private IVariable<?> timeVar = null;
        private IVariable<?> latVar = null;
        private IVariable<?> lonVar = null;
        private IVariable<?> coordSystemVar = null;
        private IVariable<?> customFieldsVar = null;
        private IVariable<?> literalVar = null;
        private IVariable<?> distanceVar = null;

        public GeoSpatialServiceCallConfiguration(GeoSpatialDefaults defaults, GeoSpatialConfig geoSpatialConfig, IVariable<?> searchVar, Map<URI, StatementPatternNode> sps) {
            StatementPatternNode sp;
            this.geoSpatialConfig = geoSpatialConfig;
            this.defaults = defaults;
            this.searchVar = searchVar;
            if (sps.containsKey(GeoSpatial.SEARCH)) {
                this.searchFunction = sps.get(GeoSpatial.SEARCH).o();
            }
            if (sps.containsKey(GeoSpatial.PREDICATE)) {
                this.predicate = sps.get(GeoSpatial.PREDICATE).o();
            }
            if (sps.containsKey(GeoSpatial.SEARCH_DATATYPE)) {
                this.searchDatatype = sps.get(GeoSpatial.SEARCH_DATATYPE).o();
            }
            if (sps.containsKey(GeoSpatial.CONTEXT)) {
                this.context = sps.get(GeoSpatial.CONTEXT).o();
            }
            if (sps.containsKey(GeoSpatial.SPATIAL_CIRCLE_CENTER)) {
                this.spatialCircleCenter = sps.get(GeoSpatial.SPATIAL_CIRCLE_CENTER).o();
            }
            if (sps.containsKey(GeoSpatial.SPATIAL_CIRCLE_RADIUS)) {
                this.spatialCircleRadius = sps.get(GeoSpatial.SPATIAL_CIRCLE_RADIUS).o();
            }
            if (sps.containsKey(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST)) {
                this.spatialRectangleSouthWest = sps.get(GeoSpatial.SPATIAL_RECTANGLE_SOUTH_WEST).o();
            }
            if (sps.containsKey(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST)) {
                this.spatialRectangleNorthEast = sps.get(GeoSpatial.SPATIAL_RECTANGLE_NORTH_EAST).o();
            }
            if (sps.containsKey(GeoSpatial.SPATIAL_UNIT)) {
                this.spatialUnit = sps.get(GeoSpatial.SPATIAL_UNIT).o();
            }
            if (sps.containsKey(GeoSpatial.TIME_START)) {
                this.timeStart = sps.get(GeoSpatial.TIME_START).o();
            }
            if (sps.containsKey(GeoSpatial.TIME_END)) {
                this.timeEnd = sps.get(GeoSpatial.TIME_END).o();
            }
            if (sps.containsKey(GeoSpatial.COORD_SYSTEM)) {
                this.coordSystem = sps.get(GeoSpatial.COORD_SYSTEM).o();
            }
            if (sps.containsKey(GeoSpatial.CUSTOM_FIELDS)) {
                this.customFields = sps.get(GeoSpatial.CUSTOM_FIELDS).o();
            }
            if (sps.containsKey(GeoSpatial.CUSTOM_FIELDS_LOWER_BOUNDS)) {
                this.customFieldsLowerBounds = sps.get(GeoSpatial.CUSTOM_FIELDS_LOWER_BOUNDS).o();
            }
            if (sps.containsKey(GeoSpatial.CUSTOM_FIELDS_UPPER_BOUNDS)) {
                this.customFieldsUpperBounds = sps.get(GeoSpatial.CUSTOM_FIELDS_UPPER_BOUNDS).o();
            }
            if (sps.containsKey(GeoSpatial.LOCATION_VALUE)) {
                sp = sps.get(GeoSpatial.LOCATION_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("locationValue property must point to a variable");
                }
                this.locationVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.TIME_VALUE)) {
                sp = sps.get(GeoSpatial.TIME_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("timeValue property must point to a variable");
                }
                this.timeVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.LAT_VALUE)) {
                sp = sps.get(GeoSpatial.LAT_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("latValue property must point to a variable");
                }
                this.latVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.LON_VALUE)) {
                sp = sps.get(GeoSpatial.LON_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("lonValue property must point to a variable");
                }
                this.lonVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.COORD_SYSTEM_VALUE)) {
                sp = sps.get(GeoSpatial.COORD_SYSTEM_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("coordSystemValue property must point to a variable");
                }
                this.coordSystemVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.CUSTOM_FIELDS_VALUES)) {
                sp = sps.get(GeoSpatial.CUSTOM_FIELDS_VALUES);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("customFieldsValues property must point to a variable");
                }
                this.customFieldsVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.LOCATION_AND_TIME_VALUE)) {
                sp = sps.get(GeoSpatial.LOCATION_AND_TIME_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("locationAndTimeValue property must point to a variable");
                }
                this.locationAndTimeVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.LITERAL_VALUE)) {
                sp = sps.get(GeoSpatial.LITERAL_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("locationAndTimeValue property must point to a variable");
                }
                this.literalVar = (IVariable)sp.o().getValueExpression();
            }
            if (sps.containsKey(GeoSpatial.DISTANCE_VALUE)) {
                sp = sps.get(GeoSpatial.DISTANCE_VALUE);
                if (!sp.o().isVariable()) {
                    throw new GeoSpatialSearchException("distanceValue property must point to a variable");
                }
                this.distanceVar = (IVariable)sp.o().getValueExpression();
            }
        }

        public GeoSpatialQuery toGeoSpatialQuery(IBindingSet bs) {
            URI searchDatatypeUri = this.resolveSearchDatatype(this.searchDatatype, bs);
            GeoSpatial.GeoFunction searchFunction = this.resolveAsGeoFunction(this.searchFunction, bs);
            GeoSpatialUtility.PointLatLon spatialCircleCenter = this.resolveAsPoint(this.spatialCircleCenter, bs);
            Double spatialCircleRadius = this.resolveAsDouble(this.spatialCircleRadius, bs);
            GeoSpatialUtility.PointLatLon spatialRectangleUpperLeft = this.resolveAsPoint(this.spatialRectangleSouthWest, bs);
            GeoSpatialUtility.PointLatLon spatialRectangleLowerRight = this.resolveAsPoint(this.spatialRectangleNorthEast, bs);
            ICoordinate.UNITS spatialUnit = this.resolveAsSpatialDistanceUnit(this.spatialUnit, bs);
            Long coordSystem = this.resolveAsLong(this.coordSystem, bs);
            Long timeStart = this.resolveAsLong(this.timeStart, bs);
            Long timeEnd = this.resolveAsLong(this.timeEnd, bs);
            String[] customFields = this.resolveAsStringArr(this.customFields, bs);
            GeoSpatialDatatypeConfiguration datatypeConfig = this.geoSpatialConfig.getConfigurationForDatatype(searchDatatypeUri);
            if (datatypeConfig == null) {
                throw new GeoSpatialSearchException("Datatype " + searchDatatypeUri + " is not a registered geospatial " + "datatype. Query cannot be executed.");
            }
            GeoSpatialDatatypeFieldConfiguration.ValueType[] customFieldsVTs = new GeoSpatialDatatypeFieldConfiguration.ValueType[customFields.length];
            for (int i = 0; i < customFields.length; ++i) {
                GeoSpatialDatatypeFieldConfiguration.ValueType vt = datatypeConfig.getValueTypeOfCustomField(customFields[i]);
                if (vt == null) {
                    throw new GeoSpatialSearchException("Undefined custom field used in query: " + customFields[i]);
                }
                customFieldsVTs[i] = vt;
            }
            Object[] customFieldsLowerBounds = this.resolveAsLongDoubleArr(this.customFieldsLowerBounds, customFieldsVTs, bs);
            Object[] customFieldsUpperBounds = this.resolveAsLongDoubleArr(this.customFieldsUpperBounds, customFieldsVTs, bs);
            GeoSpatialQuery sq = new GeoSpatialQuery(this.geoSpatialConfig, searchFunction, searchDatatypeUri, bs.get(this.searchVar), this.predicate, this.context, spatialCircleCenter, spatialCircleRadius, spatialRectangleUpperLeft, spatialRectangleLowerRight, spatialUnit, timeStart, timeEnd, coordSystem, GeoSpatialQuery.toValidatedCustomFieldsConstraints(customFields, customFieldsLowerBounds, customFieldsUpperBounds), this.locationVar, this.timeVar, this.locationAndTimeVar, this.latVar, this.lonVar, this.coordSystemVar, this.customFieldsVar, this.literalVar, this.distanceVar, bs);
            return sq;
        }

        GeoSpatial.GeoFunction resolveAsGeoFunction(TermNode termNode, IBindingSet bs) {
            if (termNode == null) {
                return GeoSpatial.GeoFunction.UNDEFINED;
            }
            String geoFunctionStr = this.resolveAsString(termNode, bs);
            if (geoFunctionStr == null) {
                geoFunctionStr = this.defaults.getDefaultFunction();
            }
            if (geoFunctionStr != null && !geoFunctionStr.isEmpty()) {
                GeoSpatial.GeoFunction gf = GeoSpatial.GeoFunction.forName(geoFunctionStr);
                if (gf == null) {
                    throw new GeoSpatialSearchException("Geo function '" + geoFunctionStr + "' not known.");
                }
                return gf;
            }
            return GeoSpatial.GeoFunction.UNDEFINED;
        }

        ICoordinate.UNITS resolveAsSpatialDistanceUnit(TermNode termNode, IBindingSet bs) {
            String spatialUnitStr = this.resolveAsString(termNode, bs);
            if (spatialUnitStr == null) {
                spatialUnitStr = this.defaults.getDefaultSpatialDistanceUnit();
            }
            if (spatialUnitStr != null && !spatialUnitStr.isEmpty()) {
                ICoordinate.UNITS u = ICoordinate.UNITS.valueOf(spatialUnitStr);
                if (u == null) {
                    throw new GeoSpatialSearchException("Input could not be parsed as unit: '" + spatialUnitStr + "'.");
                }
                return u;
            }
            return GeoSpatial.Options.DEFAULT_GEO_SPATIAL_UNIT;
        }

        Double resolveAsDouble(TermNode termNode, IBindingSet bs) {
            String s = this.resolveAsString(termNode, bs);
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new GeoSpatialSearchException("Input could not be resolved as double value: '" + s + "'.");
            }
        }

        Long resolveAsLong(TermNode termNode, IBindingSet bs) {
            String s = this.resolveAsString(termNode, bs);
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new GeoSpatialSearchException("Input could not be resolved as long value: '" + s + "'.");
            }
        }

        Literal resolveAsLiteral(TermNode termNode, IBindingSet bs) {
            if (termNode == null) {
                return null;
            }
            if (termNode.isConstant()) {
                return (Literal)termNode.getValue();
            }
            if (bs == null) {
                return null;
            }
            IVariable var = (IVariable)termNode.getValueExpression();
            if (bs.isBound(var)) {
                Object bdVal;
                IConstant c = bs.get(var);
                if (c == null || c.get() == null) {
                    return null;
                }
                Object obj = c.get();
                if (obj instanceof TermId) {
                    return (TermId)obj;
                }
                if (obj instanceof IV && (bdVal = ((IV)obj).getValue()) != null) {
                    return (Literal)bdVal;
                }
                throw new GeoSpatialSearchException("Value for literal could not be retrieved.");
            }
            throw new GeoSpatialSearchException("Service magic variable unbound at runtime:" + var);
        }

        GeoSpatialUtility.PointLatLon resolveAsPoint(TermNode termNode, IBindingSet bs) {
            Literal lit = this.resolveAsLiteral(termNode, bs);
            if (lit == null || lit.stringValue().isEmpty()) {
                return null;
            }
            String pointAsStr = lit.stringValue();
            IGeoSpatialLiteralSerializer serializer = null;
            GeoSpatialDatatypeConfiguration pconfig = null;
            if (lit.getDatatype() != null && (pconfig = this.geoSpatialConfig.getConfigurationForDatatype(lit.getDatatype())).hasLat() && pconfig.hasLon()) {
                serializer = pconfig.getLiteralSerializer();
            }
            try {
                if (serializer == null) {
                    return new GeoSpatialUtility.PointLatLon(pointAsStr);
                }
                String[] comps = serializer.toComponents(pointAsStr);
                Double lat = Double.parseDouble(comps[pconfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE)]);
                Double lon = Double.parseDouble(comps[pconfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE)]);
                return new GeoSpatialUtility.PointLatLon(lat, lon);
            }
            catch (NumberFormatException e) {
                throw new GeoSpatialSearchException("Input could not be resolved as point: '" + pointAsStr + "'.");
            }
        }

        String resolveAsString(TermNode termNode, IBindingSet bs) {
            if (termNode == null) {
                return null;
            }
            if (termNode.isConstant()) {
                Literal lit = (Literal)termNode.getValue();
                return lit == null ? null : lit.stringValue();
            }
            if (bs == null) {
                return null;
            }
            IVariable var = (IVariable)termNode.getValueExpression();
            if (bs.isBound(var)) {
                Object bdVal;
                IConstant c = bs.get(var);
                if (c == null || c.get() == null) {
                    return null;
                }
                Object obj = c.get();
                if (obj instanceof TermId) {
                    return ((TermId)obj).stringValue();
                }
                if (obj instanceof IV && (bdVal = ((IV)obj).getValue()) != null) {
                    return bdVal.stringValue();
                }
                throw new GeoSpatialSearchException("Value for literal could not be retrieved.");
            }
            throw new GeoSpatialSearchException("Service magic variable unbound at runtime:" + var);
        }

        String[] resolveAsStringArr(TermNode termNode, IBindingSet bs) {
            String toSplit = this.resolveAsString(termNode, bs);
            if (toSplit == null) {
                return new String[0];
            }
            return toSplit.split("#");
        }

        Object[] resolveAsLongDoubleArr(TermNode termNode, GeoSpatialDatatypeFieldConfiguration.ValueType[] valueTypes, IBindingSet bs) {
            String[] stringArr = this.resolveAsStringArr(termNode, bs);
            if (stringArr.length != valueTypes.length) {
                throw new GeoSpatialSearchException("Magic predicates geo:customFields, geo:customFieldsLowerBounds, and geo:customFieldsUpperBounds must all be given and have same length.");
            }
            Object[] objArr = new Object[stringArr.length];
            block4: for (int i = 0; i < stringArr.length; ++i) {
                switch (valueTypes[i]) {
                    case DOUBLE: {
                        Number val = Double.valueOf(stringArr[i]);
                        objArr[i] = val;
                        continue block4;
                    }
                    case LONG: {
                        Number val = Long.valueOf(stringArr[i]);
                        objArr[i] = val;
                        continue block4;
                    }
                    default: {
                        throw new GeoSpatialSearchException("Unhandled value type: " + (Object)((Object)valueTypes[i]));
                    }
                }
            }
            return objArr;
        }

        URI resolveSearchDatatype(TermNode searchDatatype, IBindingSet bs) {
            if (searchDatatype == null) {
                URI datatype = this.geoSpatialConfig.getDefaultDatatype();
                if (datatype == null) {
                    throw new GeoSpatialSearchException("No default datatype set in configuration. Please specify the datatype that you want to query using magic predicate " + GeoSpatial.SEARCH_DATATYPE + ".");
                }
                return datatype;
            }
            if (searchDatatype.isConstant()) {
                URI uri = (URI)searchDatatype.getValue();
                if (uri == null && (uri = this.geoSpatialConfig.getDefaultDatatype()) == null) {
                    throw new GeoSpatialSearchException("No default datatype set in configuration. Please specify the datatype that you want to query using magic predicate " + GeoSpatial.SEARCH_DATATYPE + ".");
                }
                return uri;
            }
            if (bs == null) {
                return null;
            }
            IVariable var = (IVariable)searchDatatype.getValueExpression();
            if (bs.isBound(var)) {
                IConstant c = bs.get(var);
                if (c == null || c.get() == null || !(c.get() instanceof TermId)) {
                    return null;
                }
                TermId cAsTerm = (TermId)c.get();
                return (URI)cAsTerm.getValue();
            }
            throw new GeoSpatialSearchException("Service magic variable unbound at runtime:" + var);
        }
    }

    public static class AcceptAllSolutionsFilter
    extends GeoSpatialFilterBase {
        private static final long serialVersionUID = -314581671447912352L;

        public AcceptAllSolutionsFilter(GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            super(litExt, geoSpatialCounters);
        }

        @Override
        protected boolean isValidInternal(ITuple tuple) {
            return true;
        }
    }

    public static class GeoSpatialInCircleFilter
    extends GeoSpatialFilterBase {
        private static final long serialVersionUID = -346928614528045113L;
        private final double spatialPointLat;
        private final double spatialPointLon;
        private final Double distanceInMeters;
        private final int idxOfLat;
        private final int idxOfLon;
        final boolean latLonIndicesValid;

        public GeoSpatialInCircleFilter(GeoSpatialUtility.PointLatLon spatialPoint, Double distance, ICoordinate.UNITS unit, Long timeMin, Long timeMax, GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            super(litExt, geoSpatialCounters);
            this.spatialPointLat = spatialPoint.getLat();
            this.spatialPointLon = spatialPoint.getLon();
            this.distanceInMeters = CoordinateUtility.unitsToMeters(distance, unit);
            this.idxOfLat = this.datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE);
            this.idxOfLon = this.datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE);
            this.latLonIndicesValid = this.idxOfLat >= 0 && this.idxOfLon >= 0;
        }

        @Override
        protected boolean isValidInternal(ITuple tuple) {
            if (!this.latLonIndicesValid) {
                return false;
            }
            try {
                byte[] key = tuple.getKey();
                IV[] ivs = IVUtility.decode(key, this.objectPos + 1);
                IV oIV = ivs[this.objectPos];
                if (!(oIV instanceof LiteralExtensionIV)) {
                    throw new IllegalArgumentException("Invalid IV cannot be cast to LiteralExtensionIV");
                }
                LiteralExtensionIV lit = (LiteralExtensionIV)oIV;
                long[] longArr = this.litExt.asLongArray(lit);
                Object[] components = this.litExt.longArrAsComponentArr(longArr);
                double lat = (Double)components[this.idxOfLat];
                double lon = (Double)components[this.idxOfLon];
                return CoordinateUtility.distanceInMeters(lat, this.spatialPointLat, lon, this.spatialPointLon) <= this.distanceInMeters;
            }
            catch (Exception e) {
                if (INFO) {
                    log.info((Object)("Something went wrong extracting the object: " + e.getMessage() + "Rejecting unprocessable value."));
                }
                return false;
            }
        }
    }

    public static abstract class GeoSpatialFilterBase
    extends TupleFilter {
        private static final long serialVersionUID = 2271038531634362860L;
        protected final GeoSpatialLiteralExtension<BigdataValue> litExt;
        protected final GeoSpatialDatatypeConfiguration datatypeConfig;
        protected int objectPos = -1;
        Integer contextPos = null;
        BigdataURI context = null;
        GeoSpatialCounters geoSpatialCounters;

        public GeoSpatialFilterBase(GeoSpatialLiteralExtension<BigdataValue> litExt, GeoSpatialCounters geoSpatialCounters) {
            this.litExt = litExt;
            this.datatypeConfig = litExt.getDatatypeConfig();
            this.geoSpatialCounters = geoSpatialCounters;
        }

        public void addContextCheck(Integer contextPos, BigdataURI context) {
            this.contextPos = contextPos;
            this.context = context;
        }

        public void setObjectPos(int objectPos) {
            this.objectPos = objectPos;
        }

        public GeoSpatialLiteralExtension<BigdataValue> getGeoSpatialLiteralExtension() {
            return this.litExt;
        }

        protected final boolean isValid(ITuple tuple) {
            long filterStartTime = System.nanoTime();
            if (!this.contextIsValid(tuple)) {
                return false;
            }
            boolean isValid = this.isValidInternal(tuple);
            long filterEndTime = System.nanoTime();
            this.geoSpatialCounters.addFilterCalculationTime(filterEndTime - filterStartTime);
            return isValid;
        }

        private boolean contextIsValid(ITuple tuple) {
            if (this.contextPos == null || this.context == null) {
                return true;
            }
            byte[] key = tuple.getKey();
            IV[] ivs = IVUtility.decode(key, this.contextPos + 1);
            IV contextIV = ivs[this.contextPos];
            return contextIV.equals(this.context.getIV());
        }

        protected abstract boolean isValidInternal(ITuple var1);
    }

    public static class GeoSpatialDefaults {
        private final String defaultFunction;
        private final String defaultSpatialUnit;

        public GeoSpatialDefaults(Properties p) {
            this.defaultFunction = p.getProperty(GeoSpatial.Options.GEO_FUNCTION);
            this.defaultSpatialUnit = p.getProperty(GeoSpatial.Options.GEO_SPATIAL_UNIT);
        }

        public String getDefaultFunction() {
            return this.defaultFunction;
        }

        public String getDefaultSpatialDistanceUnit() {
            return this.defaultSpatialUnit;
        }
    }

    public static class GeoSpatialInputBindingsIterator
    implements ICloseableIterator<IBindingSet> {
        private final IBindingSet[] bindingSet;
        private final GeoSpatialServiceCallConfiguration gssConfig;
        final AbstractTripleStore kb;
        final GeoSpatialServiceCall serviceCall;
        int nextBindingSetItr = 0;
        ICloseableIterator<IBindingSet> curDelegate;

        public GeoSpatialInputBindingsIterator(IBindingSet[] bindingSet, GeoSpatialServiceCallConfiguration gssConfig, AbstractTripleStore kb, GeoSpatialServiceCall serviceCall) {
            this.bindingSet = bindingSet;
            this.gssConfig = gssConfig;
            this.kb = kb;
            this.serviceCall = serviceCall;
            this.init();
        }

        public boolean hasNext() {
            if (this.curDelegate == null) {
                return false;
            }
            if (this.curDelegate.hasNext()) {
                return true;
            }
            if (this.nextDelegate()) {
                return this.hasNext();
            }
            return false;
        }

        public IBindingSet next() {
            if (this.curDelegate == null) {
                return null;
            }
            if (this.curDelegate.hasNext()) {
                return (IBindingSet)this.curDelegate.next();
            }
            if (this.nextDelegate()) {
                return this.next();
            }
            return null;
        }

        private boolean nextDelegate() {
            if (this.bindingSet == null || this.nextBindingSetItr >= this.bindingSet.length) {
                this.curDelegate = null;
                return false;
            }
            IBindingSet bs = this.bindingSet[this.nextBindingSetItr++];
            GeoSpatialQuery sq = this.gssConfig.toGeoSpatialQuery(bs);
            this.curDelegate = this.serviceCall.search(sq, this.kb);
            return true;
        }

        private void init() {
            this.nextDelegate();
        }

        public void remove() {
            if (this.curDelegate != null) {
                this.curDelegate.remove();
            }
        }

        public void close() {
            if (this.curDelegate != null) {
                this.curDelegate.close();
            }
        }
    }

    private static class GeoSpatialServiceCall
    implements BigdataServiceCall {
        private final IServiceOptions serviceOptions;
        final GeoSpatialServiceCallConfiguration gssConfig;
        private IVariable<?>[] vars;
        private final AbstractTripleStore kb;
        private final GeoSpatialCounters geoSpatialCounters;
        private final int numTasks;
        private final int minDatapointsPerTask;
        private final int threadLocalBufferCapacity;
        private final int globalBufferChunkOfChunksCapacity;
        private final BaseJoinStats stats;
        private final Executor executor;

        public GeoSpatialServiceCall(IVariable<?> searchVar, Map<URI, StatementPatternNode> sps, IServiceOptions serviceOptions, GeoSpatialDefaults dflts, AbstractTripleStore kb, int maxParallel, int numTasks, int minDatapointsPerTask, int threadLocalBufferCapacity, int globalBufferChunkOfChunksCapacity, BaseJoinStats stats) {
            if (searchVar == null) {
                throw new IllegalArgumentException();
            }
            if (sps == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            if (kb == null) {
                throw new IllegalArgumentException();
            }
            this.serviceOptions = serviceOptions;
            this.gssConfig = new GeoSpatialServiceCallConfiguration(dflts, kb.getLexiconRelation().getLexiconConfiguration().getGeoSpatialConfig(), searchVar, sps);
            this.vars = new IVariable[]{searchVar};
            this.kb = kb;
            this.geoSpatialCounters = QueryEngineFactory.getInstance().getQueryController(kb.getIndexManager()).getGeoSpatialCounters();
            this.numTasks = numTasks;
            this.minDatapointsPerTask = minDatapointsPerTask;
            this.threadLocalBufferCapacity = threadLocalBufferCapacity;
            this.globalBufferChunkOfChunksCapacity = globalBufferChunkOfChunksCapacity;
            if (DEBUG) {
                log.debug((Object)("Number of threads used for execution: " + maxParallel));
            }
            this.executor = maxParallel <= 1 ? null : new LatchedExecutor(kb.getIndexManager().getExecutorService(), maxParallel);
            this.stats = stats;
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] incomingBs) {
            return new GeoSpatialInputBindingsIterator(incomingBs, this.gssConfig, this.kb, this);
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }

        public ICloseableIterator<IBindingSet> search(GeoSpatialQuery query, AbstractTripleStore kb) {
            BOpContextBase context = new BOpContextBase(QueryEngineFactory.getInstance().getQueryController(kb.getIndexManager()));
            this.geoSpatialCounters.registerGeoSpatialSearchRequest();
            GlobalAnnotations globals = new GlobalAnnotations(kb.getLexiconRelation().getNamespace(), kb.getSPORelation().getTimestamp());
            BigdataValueFactory vf = kb.getValueFactory();
            BlockingBuffer<IBindingSet[]> buffer = new BlockingBuffer<IBindingSet[]>(this.globalBufferChunkOfChunksCapacity);
            FutureTask<Void> ft = new FutureTask<Void>(new GeoSpatialServiceCallTask(buffer, query.normalize(), kb, this.vars, context, globals, vf, this.geoSpatialCounters, this.executor, this.numTasks, this.minDatapointsPerTask, this.threadLocalBufferCapacity, this.stats));
            buffer.setFuture(ft);
            kb.getIndexManager().getExecutorService().submit(ft);
            return new ChunkConsumerIterator<IBindingSet>(buffer.iterator());
        }

        private static Var<?> varFromIVar(IVariable<?> iVar) {
            return iVar == null ? null : Var.var(iVar.getName());
        }

        private static class GeoSpatialServiceCallResolver
        extends Resolver {
            private static final long serialVersionUID = 1L;
            private final Var<?> var;
            private final IBindingSet incomingBindingSet;
            private final Var<?> locationVar;
            private final Var<?> timeVar;
            private final Var<?> locationAndTimeVar;
            private final Var<?> latVar;
            private final Var<?> lonVar;
            private final Var<?> coordSystemVar;
            private final Var<?> customFieldsVar;
            private final Var<?> literalVar;
            private final Var<?> distanceVar;
            private final int subjectPos;
            private final int objectPos;
            private final int latIdx;
            private final int lonIdx;
            private final int timeIdx;
            private final int coordSystemIdx;
            private final int[] idxsOfCustomFields;
            private final CoordinateDD centerPoint;
            private final ICoordinate.UNITS unit;
            private final BigdataValueFactory vf;
            private final GeoSpatialLiteralExtension<BigdataValue> litExt;
            private final IGeoSpatialLiteralSerializer literalSerializer;
            final boolean requiresObjectDereferencing;
            private final int extractToPosition;

            public GeoSpatialServiceCallResolver(Var<?> var, IBindingSet incomingBindingSet, Var<?> locationVar, Var<?> timeVar, Var<?> locationAndTimeVar, Var<?> latVar, Var<?> lonVar, Var<?> coordSystemVar, Var<?> customFieldsVar, Var<?> literalVar, Var<?> distanceVar, int subjectPos, int objectPos, BigdataValueFactory vf, GeoSpatialLiteralExtension<BigdataValue> litExt, Set<String> customFieldStrings, CoordinateDD centerPoint, ICoordinate.UNITS unit) {
                this.var = var;
                this.incomingBindingSet = incomingBindingSet;
                this.locationVar = locationVar;
                this.timeVar = timeVar;
                this.locationAndTimeVar = locationAndTimeVar;
                this.latVar = latVar;
                this.lonVar = lonVar;
                this.coordSystemVar = coordSystemVar;
                this.customFieldsVar = customFieldsVar;
                this.literalVar = literalVar;
                this.distanceVar = distanceVar;
                this.subjectPos = subjectPos;
                this.objectPos = objectPos;
                this.vf = vf;
                this.litExt = litExt;
                this.centerPoint = centerPoint;
                this.unit = unit;
                this.literalSerializer = litExt.getDatatypeConfig().getLiteralSerializer();
                this.requiresObjectDereferencing = locationVar != null || timeVar != null || locationAndTimeVar != null || coordSystemVar != null || customFieldsVar != null || latVar != null || lonVar != null || literalVar != null || distanceVar != null;
                this.extractToPosition = this.requiresObjectDereferencing ? Math.max(objectPos, subjectPos) + 1 : subjectPos + 1;
                GeoSpatialDatatypeConfiguration datatypeConfig = litExt.getDatatypeConfig();
                this.latIdx = datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LATITUDE);
                this.lonIdx = datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.LONGITUDE);
                this.timeIdx = datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.TIME);
                this.coordSystemIdx = datatypeConfig.idxOfField(GeoSpatialDatatypeFieldConfiguration.ServiceMapping.COORD_SYSTEM);
                this.idxsOfCustomFields = datatypeConfig.idxsOfCustomFields(customFieldStrings);
            }

            protected IBindingSet resolve(Object obj) {
                byte[] key = ((ITuple)obj).getKey();
                IV[] ivs = IVUtility.decode(key, this.extractToPosition);
                IBindingSet bs = this.incomingBindingSet.clone();
                bs.set(this.var, new Constant<IV>(ivs[this.subjectPos]));
                if (this.requiresObjectDereferencing) {
                    Object[] componentArr = this.litExt.toComponentArray((LiteralExtensionIV)ivs[this.objectPos]);
                    if (this.locationVar != null) {
                        bs.set(this.locationVar, new Constant(this.literalSerializer.serializeLocation(this.vf, componentArr[this.latIdx], componentArr[this.lonIdx])));
                    }
                    if (this.locationAndTimeVar != null) {
                        bs.set(this.locationAndTimeVar, new Constant(this.literalSerializer.serializeLocationAndTime(this.vf, componentArr[this.latIdx], componentArr[this.lonIdx], componentArr[this.timeIdx])));
                    }
                    if (this.timeVar != null) {
                        bs.set(this.timeVar, new Constant(this.literalSerializer.serializeTime(this.vf, componentArr[this.timeIdx])));
                    }
                    if (this.latVar != null) {
                        bs.set(this.latVar, new Constant(this.literalSerializer.serializeLatitude(this.vf, componentArr[this.latIdx])));
                    }
                    if (this.lonVar != null) {
                        bs.set(this.lonVar, new Constant(this.literalSerializer.serializeLongitude(this.vf, componentArr[this.lonIdx])));
                    }
                    if (this.coordSystemVar != null) {
                        bs.set(this.coordSystemVar, new Constant(this.literalSerializer.serializeCoordSystem(this.vf, componentArr[this.coordSystemIdx])));
                    }
                    if (this.customFieldsVar != null) {
                        Object[] customFieldsValues = new Object[this.idxsOfCustomFields.length];
                        for (int i = 0; i < this.idxsOfCustomFields.length; ++i) {
                            customFieldsValues[i] = componentArr[this.idxsOfCustomFields[i]];
                        }
                        bs.set(this.customFieldsVar, new Constant(this.literalSerializer.serializeCustomFields(this.vf, customFieldsValues)));
                    }
                    if (this.literalVar != null) {
                        bs.set(this.literalVar, new Constant<IV>(DummyConstantNode.toDummyIV(this.vf.createLiteral(this.literalSerializer.fromComponents(componentArr), this.litExt.getDatatypeConfig().getUri()))));
                    }
                    if (this.distanceVar != null) {
                        Double curLatValue = componentArr[this.latIdx] instanceof Double ? ((Double)componentArr[this.latIdx]).doubleValue() : ((Long)componentArr[this.latIdx]).doubleValue();
                        Double curLonValue = componentArr[this.lonIdx] instanceof Double ? ((Double)componentArr[this.lonIdx]).doubleValue() : ((Long)componentArr[this.lonIdx]).doubleValue();
                        CoordinateDD cur = new CoordinateDD(curLatValue, curLonValue);
                        bs.set(this.distanceVar, new Constant(this.literalSerializer.serializeDistance(this.vf, this.centerPoint.distance(cur, this.unit), this.unit)));
                    }
                }
                return bs;
            }
        }

        private static class GeoSpatialServiceCallTask
        extends Haltable<Void>
        implements Callable<Void> {
            final BlockingBuffer<IBindingSet[]> buffer;
            private final Executor executor;
            private final List<IGeoSpatialQuery> queries;
            private final AbstractTripleStore kb;
            private final IVariable<?>[] vars;
            private final GeoSpatialCounters geoSpatialCounters;
            private final BOpContextBase context;
            private final GlobalAnnotations globals;
            private final BigdataValueFactory vf;
            private final GeoSpatialConfig geoSpatialConfig;
            private final int numTasks;
            private final int minDatapointsPerTask;
            private final int threadLocalBufferCapacity;
            private final BaseJoinStats stats;
            private final List<GeoSpatialServiceCallSubRangeTask> tasks;

            public GeoSpatialServiceCallTask(BlockingBuffer<IBindingSet[]> buffer, List<IGeoSpatialQuery> queries, AbstractTripleStore kb, IVariable<?>[] vars, BOpContextBase context, GlobalAnnotations globals, BigdataValueFactory vf, GeoSpatialCounters geoSpatialCounters, Executor executor, int numTasks, int minDatapointsPerTask, int threadLocalBufferCapacity, BaseJoinStats stats) {
                this.buffer = buffer;
                this.queries = queries;
                this.kb = kb;
                this.vars = vars;
                this.context = context;
                this.globals = globals;
                this.vf = vf;
                this.executor = executor;
                this.geoSpatialCounters = geoSpatialCounters;
                this.numTasks = numTasks;
                this.minDatapointsPerTask = minDatapointsPerTask;
                this.threadLocalBufferCapacity = threadLocalBufferCapacity;
                this.stats = stats;
                this.geoSpatialConfig = kb.getLexiconRelation().getLexiconConfiguration().getGeoSpatialConfig();
                this.tasks = this.getSubTasks();
                geoSpatialCounters.registerGeoSpatialServiceCallTask();
                geoSpatialCounters.registerGeoSpatialServiceCallSubRangeTasks(this.tasks.size());
            }

            protected List<GeoSpatialServiceCallSubRangeTask> getSubTasks() {
                LinkedList<GeoSpatialServiceCallSubRangeTask> subTasks = new LinkedList<GeoSpatialServiceCallSubRangeTask>();
                for (IGeoSpatialQuery query : this.queries) {
                    Object[] northEastComponents;
                    if (!query.isNormalized()) {
                        throw new IllegalArgumentException("Expected list of normalized query as input.");
                    }
                    Object[] southWestComponents = query.getLowerAndUpperBound().getLowerBound();
                    AccessPath<ISPO> accessPath = this.getAccessPath(southWestComponents, northEastComponents = query.getLowerAndUpperBound().getUpperBound(), query);
                    if (accessPath == null) continue;
                    long totalPointsInRange = accessPath.rangeCount(false);
                    this.stats.accessPathRangeCount.add(totalPointsInRange);
                    GeoSpatialDatatypeConfiguration datatypeConfig = this.geoSpatialConfig.getConfigurationForDatatype(query.getSearchDatatype());
                    if (datatypeConfig == null) {
                        throw new GeoSpatialSearchException("Invalid input paramater: search datatype unknown.");
                    }
                    GeoSpatialLiteralExtension<BigdataValue> litExt = new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation(), datatypeConfig);
                    SPOKeyOrder keyOrder = (SPOKeyOrder)accessPath.getKeyOrder();
                    int subjectPos = keyOrder.getPositionInIndex(0);
                    int objectPos = keyOrder.getPositionInIndex(2);
                    GeoSpatialSearchRange searchRange = new GeoSpatialSearchRange(datatypeConfig, litExt, southWestComponents, northEastComponents);
                    GeoSpatialSearchRangePartitioner partitioner = new GeoSpatialSearchRangePartitioner(searchRange);
                    for (GeoSpatialSearchRange partition : partitioner.partition(this.numTasks, totalPointsInRange, this.minDatapointsPerTask)) {
                        Object[] upperBorder;
                        Object[] lowerBorder = partition.getLowerBorderComponents();
                        GeoSpatialServiceCallSubRangeTask subTask = this.getSubTask(query, lowerBorder, upperBorder = partition.getUpperBorderComponents(), keyOrder, subjectPos, objectPos, this.stats);
                        if (subTask == null) continue;
                        subTasks.add(subTask);
                    }
                }
                return subTasks;
            }

            protected GeoSpatialServiceCallSubRangeTask getSubTask(IGeoSpatialQuery query, Object[] lowerBorder, Object[] upperBorder, SPOKeyOrder keyOrder, int subjectPos, int objectPos, BaseJoinStats stats) {
                AccessPath<ISPO> accessPath;
                GeoSpatialFilterBase filter;
                GeoSpatialDatatypeConfiguration datatypeConfig = query.getDatatypeConfig();
                GeoSpatialLiteralExtension<BigdataValue> litExt = new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation(), datatypeConfig);
                switch (query.getSearchFunction()) {
                    case IN_CIRCLE: {
                        filter = new GeoSpatialInCircleFilter(query.getSpatialCircleCenter(), query.getSpatialCircleRadius(), query.getSpatialUnit(), query.getTimeStart(), query.getTimeEnd(), new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation(), datatypeConfig), this.geoSpatialCounters);
                        break;
                    }
                    case IN_RECTANGLE: 
                    case UNDEFINED: {
                        filter = new AcceptAllSolutionsFilter(new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation(), datatypeConfig), this.geoSpatialCounters);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown geospatial search function.");
                    }
                }
                filter.setObjectPos(objectPos);
                TermNode ctxTermNode = query.getContext();
                if (ctxTermNode != null) {
                    BigdataValue ctx;
                    BigdataValue bigdataValue = ctx = ctxTermNode == null ? null : ctxTermNode.getValue();
                    if (ctx != null && !(ctx instanceof BigdataURI)) {
                        throw new IllegalArgumentException("Context in GeoSpatial search must be a URI");
                    }
                    filter.addContextCheck(keyOrder.getPositionInIndex(3), (BigdataURI)ctx);
                }
                if ((accessPath = this.getAccessPath(lowerBorder, upperBorder, query)) == null) {
                    return null;
                }
                byte[] lowerZOrderKey = litExt.toZOrderByteArray(lowerBorder);
                byte[] upperZOrderKey = litExt.toZOrderByteArray(upperBorder);
                ZOrderIndexBigMinAdvancer bigMinAdvancer = new ZOrderIndexBigMinAdvancer(lowerZOrderKey, upperZOrderKey, litExt, objectPos, this.geoSpatialCounters);
                Var locationVar = GeoSpatialServiceCall.varFromIVar(query.getLocationVar());
                Var timeVar = GeoSpatialServiceCall.varFromIVar(query.getTimeVar());
                Var latVar = GeoSpatialServiceCall.varFromIVar(query.getLatVar());
                Var lonVar = GeoSpatialServiceCall.varFromIVar(query.getLonVar());
                Var coordSystemVar = GeoSpatialServiceCall.varFromIVar(query.getCoordSystemVar());
                Var customFieldsVar = GeoSpatialServiceCall.varFromIVar(query.getCustomFieldsVar());
                Var locationAndTimeVar = GeoSpatialServiceCall.varFromIVar(query.getLocationAndTimeVar());
                Var literalVar = GeoSpatialServiceCall.varFromIVar(query.getLiteralVar());
                Var distanceVar = GeoSpatialServiceCall.varFromIVar(query.getDistanceVar());
                Var var = Var.var(this.vars[0].getName());
                IBindingSet incomingBindingSet = query.getIncomingBindings();
                GeoSpatialUtility.PointLatLon centerPoint = query.getSpatialCircleCenter();
                CoordinateDD centerPointDD = centerPoint == null ? null : new CoordinateDD(centerPoint.getLat(), centerPoint.getLon());
                GeoSpatialServiceCallResolver resolver = new GeoSpatialServiceCallResolver(var, incomingBindingSet, locationVar, timeVar, locationAndTimeVar, latVar, lonVar, coordSystemVar, customFieldsVar, literalVar, distanceVar, subjectPos, objectPos, this.vf, new GeoSpatialLiteralExtension<BigdataValue>(this.kb.getLexiconRelation(), datatypeConfig), query.getCustomFieldsConstraints().keySet(), centerPointDD, query.getSpatialUnit());
                return new GeoSpatialServiceCallSubRangeTask(this.buffer, accessPath, bigMinAdvancer, filter, resolver, this.threadLocalBufferCapacity, stats);
            }

            protected AccessPath<ISPO> getAccessPath(Object[] lowerBorderComponents, Object[] upperBorderComponents, IGeoSpatialQuery query) {
                GeoSpatialDatatypeConfiguration datatypeConfig = query.getDatatypeConfig();
                GeoSpatialLiteralExtension litExt = new GeoSpatialLiteralExtension(this.kb.getLexiconRelation(), datatypeConfig);
                Var<IV> oVar = Var.var();
                RangeNode range = new RangeNode(new VarNode(oVar), new ConstantNode(litExt.createIV(lowerBorderComponents)), new ConstantNode(litExt.createIV(upperBorderComponents)));
                RangeBOp rangeBop = ASTRangeOptimizer.toRangeBOp(this.context, range, this.globals);
                IConstant<?> constSubject = query.getSubject();
                TermNode s = constSubject == null ? new VarNode(this.vars[0].getName()) : new ConstantNode(constSubject);
                TermNode p = query.getPredicate();
                VarNode o = new VarNode(oVar);
                IPredicate pred = this.kb.getPredicate((Resource)((URI)s.getValue()), p == null ? null : (URI)p.getValue(), o.getValue(), null, null, rangeBop);
                if (pred == null) {
                    return null;
                }
                pred = (IPredicate)pred.setProperty(IPredicate.Annotations.TIMESTAMP, this.kb.getSPORelation().getTimestamp());
                IRelation relation = this.context.getRelation(pred);
                AccessPath accessPath = (AccessPath)this.context.getAccessPath(relation, pred);
                return accessPath;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                if (DEBUG) {
                    log.debug((Object)("Number of service call tasks to execute: " + this.tasks.size()));
                }
                if (this.executor == null || this.tasks.size() == 1) {
                    for (GeoSpatialServiceCallSubRangeTask task : this.tasks) {
                        task.call();
                    }
                    this.buffer.flush();
                    this.buffer.close();
                    return null;
                }
                LinkedList<FutureTask<Void>> futureTasks = new LinkedList<FutureTask<Void>>();
                for (GeoSpatialServiceCallSubRangeTask geoSpatialServiceCallSubRangeTask : this.tasks) {
                    FutureTask<Void> ft = new FutureTask<Void>(geoSpatialServiceCallSubRangeTask);
                    futureTasks.add(ft);
                }
                try {
                    for (FutureTask futureTask : futureTasks) {
                        this.halted();
                        this.executor.execute(futureTask);
                    }
                    for (FutureTask futureTask : futureTasks) {
                        if (this.isDone()) continue;
                        futureTask.get();
                    }
                }
                finally {
                    for (FutureTask futureTask : futureTasks) {
                        futureTask.cancel(true);
                    }
                }
                this.buffer.flush();
                this.buffer.close();
                return null;
            }

            public static class GeoSpatialSearchRange {
                final GeoSpatialDatatypeConfiguration datatypeConfig;
                final GeoSpatialLiteralExtension<BigdataValue> litExt;
                private final Object[] lowerBorderComponents;
                private final Object[] upperBorderComponents;

                public GeoSpatialSearchRange(GeoSpatialDatatypeConfiguration datatypeConfig, GeoSpatialLiteralExtension<BigdataValue> litExt, Object[] lowerBorderComponents, Object[] upperBorderComponents) {
                    this.datatypeConfig = datatypeConfig;
                    this.litExt = litExt;
                    this.lowerBorderComponents = lowerBorderComponents;
                    this.upperBorderComponents = upperBorderComponents;
                }

                public GeoSpatialLiteralExtension<BigdataValue> getLitExt() {
                    return this.litExt;
                }

                public GeoSpatialDatatypeConfiguration getDatatypeConfig() {
                    return this.datatypeConfig;
                }

                public Object[] getLowerBorderComponents() {
                    return this.lowerBorderComponents;
                }

                public Object[] getUpperBorderComponents() {
                    return this.upperBorderComponents;
                }
            }

            public static class GeoSpatialSearchRangePartitioner {
                private final GeoSpatialSearchRange geoSpatialSearchRange;

                public GeoSpatialSearchRangePartitioner(GeoSpatialSearchRange geoSpatialSearchRange) {
                    this.geoSpatialSearchRange = geoSpatialSearchRange;
                }

                public List<GeoSpatialSearchRange> partition(int numTasks, long totalPointsInRange, int minDatapointsPerTask) {
                    long breakPoint;
                    long upperComponentLongValue;
                    long lowerComponentLongValue;
                    ArrayList<GeoSpatialSearchRange> partitions = new ArrayList<GeoSpatialSearchRange>();
                    long numPartitions = this.computeNumberOfPartitions(numTasks, totalPointsInRange, minDatapointsPerTask);
                    GeoSpatialDatatypeConfiguration datatypeConfig = this.geoSpatialSearchRange.getDatatypeConfig();
                    int numDimensions = datatypeConfig.getNumDimensions();
                    Object[] lowerBorderComponents = this.geoSpatialSearchRange.getLowerBorderComponents();
                    Object[] upperBorderComponents = this.geoSpatialSearchRange.getUpperBorderComponents();
                    assert (numDimensions == lowerBorderComponents.length && numDimensions == upperBorderComponents.length);
                    GeoSpatialDatatypeFieldConfiguration fieldToPartitionOn = datatypeConfig.getFields().get(numDimensions - 1);
                    GeoSpatialDatatypeFieldConfiguration.ValueType vt = fieldToPartitionOn.getValueType();
                    switch (vt) {
                        case LONG: {
                            lowerComponentLongValue = (Long)lowerBorderComponents[numDimensions - 1];
                            upperComponentLongValue = (Long)upperBorderComponents[numDimensions - 1];
                            break;
                        }
                        case DOUBLE: {
                            lowerComponentLongValue = Double.valueOf((Double)lowerBorderComponents[numDimensions - 1] * (double)fieldToPartitionOn.getMultiplier()).longValue();
                            upperComponentLongValue = Double.valueOf((Double)upperBorderComponents[numDimensions - 1] * (double)fieldToPartitionOn.getMultiplier()).longValue();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
                        }
                    }
                    long diff = upperComponentLongValue - lowerComponentLongValue;
                    long dist = diff / numPartitions;
                    ArrayList<Long> breakPoints = new ArrayList<Long>();
                    long lastConsidered = -1L;
                    breakPoints.add(lowerComponentLongValue - 1L);
                    for (long i = 1L; i < numPartitions && lastConsidered != (breakPoint = lowerComponentLongValue + i * dist); ++i) {
                        if (breakPoint > lowerComponentLongValue && breakPoint < upperComponentLongValue) {
                            breakPoints.add(breakPoint);
                        }
                        lastConsidered = breakPoint;
                    }
                    breakPoints.add(upperComponentLongValue);
                    int finalPosition = lowerBorderComponents.length - 1;
                    for (int i = 0; i < breakPoints.size() - 1; ++i) {
                        Object[] breakpointLowerBorder = new Object[lowerBorderComponents.length];
                        Object[] breakpointUpperBorder = new Object[upperBorderComponents.length];
                        for (int j = 0; j < lowerBorderComponents.length - 1; ++j) {
                            breakpointLowerBorder[j] = lowerBorderComponents[j];
                            breakpointUpperBorder[j] = upperBorderComponents[j];
                        }
                        long startLongVal = (Long)breakPoints.get(i) + 1L;
                        long endLongVal = (Long)breakPoints.get(i + 1);
                        switch (vt) {
                            case LONG: {
                                breakpointLowerBorder[finalPosition] = startLongVal;
                                breakpointUpperBorder[finalPosition] = endLongVal;
                                break;
                            }
                            case DOUBLE: {
                                breakpointLowerBorder[finalPosition] = (double)startLongVal / (double)fieldToPartitionOn.getMultiplier();
                                breakpointUpperBorder[finalPosition] = (double)endLongVal / (double)fieldToPartitionOn.getMultiplier();
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unsupported value type: " + (Object)((Object)vt));
                            }
                        }
                        GeoSpatialSearchRange searchRange = new GeoSpatialSearchRange(this.geoSpatialSearchRange.getDatatypeConfig(), this.geoSpatialSearchRange.getLitExt(), breakpointLowerBorder, breakpointUpperBorder);
                        partitions.add(searchRange);
                    }
                    return partitions;
                }

                private long computeNumberOfPartitions(int numTasks, long totalPointsInRange, int minDatapointsPerTask) {
                    long maxTasksByDatapointRestriction = totalPointsInRange / (long)minDatapointsPerTask;
                    long desiredNumTasks = Math.max(numTasks, 1);
                    long nrSubRanges = Math.min(maxTasksByDatapointRestriction, desiredNumTasks);
                    return Math.max(1L, nrSubRanges);
                }
            }

            private static class GeoSpatialServiceCallSubRangeTask
            implements Callable<Void> {
                private final UnsynchronizedArrayBuffer<IBindingSet> localBuffer;
                private final AccessPath<ISPO> accessPath;
                private final Advancer<SPO> bigMinAdvancer;
                private final GeoSpatialFilterBase filter;
                private final GeoSpatialServiceCallResolver resolver;
                private final BaseJoinStats stats;

                public GeoSpatialServiceCallSubRangeTask(BlockingBuffer<IBindingSet[]> backingBuffer, AccessPath<ISPO> accessPath, Advancer<SPO> bigMinAdvancer, GeoSpatialFilterBase filter, GeoSpatialServiceCallResolver resolver, int threadLocalBufferCapacity, BaseJoinStats stats) {
                    this.localBuffer = new UnsynchronizedArrayBuffer<IBindingSet>(backingBuffer, IBindingSet.class, threadLocalBufferCapacity);
                    this.accessPath = accessPath;
                    this.bigMinAdvancer = bigMinAdvancer;
                    this.filter = filter;
                    this.resolver = resolver;
                    this.stats = stats;
                }

                @Override
                public Void call() throws Exception {
                    IStriterator itr = new Striterator((Iterator)this.accessPath.getIndex().rangeIterator(this.accessPath.getFromKey(), this.accessPath.getToKey(), 0, 33, this.bigMinAdvancer)).addFilter((IFilter)this.filter).addFilter((IFilter)this.resolver);
                    this.stats.accessPathCount.increment();
                    while (itr.hasNext()) {
                        this.stats.accessPathUnitsIn.increment();
                        this.localBuffer.add((IBindingSet)itr.next());
                    }
                    this.localBuffer.flush();
                    return null;
                }
            }
        }
    }
}

