/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.cache;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.htree.HTree;
import com.bigdata.io.SerializerUtil;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionImpl;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;

public class DescribeCache
implements IDescribeCache {
    private static final transient Logger log = Logger.getLogger(CacheConnectionImpl.class);
    private HTree map;

    public DescribeCache(HTree map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.map = map;
    }

    public void close() {
        this.map.close();
    }

    @Override
    public void destroy() {
        this.map.removeAll();
    }

    private IKeyBuilder getKeyBuilder() {
        return this.map.getIndexMetadata().getKeyBuilder();
    }

    private byte[] iv2key(IKeyBuilder keyBuilder, IV<?, ?> iv) {
        if (keyBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (iv == null) {
            throw new IllegalArgumentException();
        }
        keyBuilder.reset();
        return iv.encode(keyBuilder).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(IV<?, ?> iv, Graph g) {
        byte[] key = this.iv2key(this.getKeyBuilder(), iv);
        byte[] val = SerializerUtil.serialize(g);
        HTree hTree = this.map;
        synchronized (hTree) {
            this.map.remove(key);
            this.map.insert(key, val);
        }
    }

    @Override
    public Graph lookup(IV<?, ?> iv) {
        byte[] key = this.iv2key(this.getKeyBuilder(), iv);
        byte[] val = this.map.lookupFirst(key);
        if (val == null) {
            return null;
        }
        Graph x = (Graph)SerializerUtil.deserialize(val);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Set<IV<?, ?>> ivs) {
        if (ivs == null) {
            throw new IllegalArgumentException();
        }
        int size = ivs.size();
        if (size == 0) {
            return;
        }
        Object[] a = ivs.toArray(new IV[size]);
        Arrays.sort(a);
        IKeyBuilder keyBuilder = this.getKeyBuilder();
        HTree hTree = this.map;
        synchronized (hTree) {
            for (Object iv : a) {
                byte[] key = this.iv2key(keyBuilder, (IV<?, ?>)iv);
                this.map.remove(key);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invalidated cache entries: n=" + size));
            }
        }
    }
}

