/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.PipelineOp;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import java.util.Map;

public class ASTContainer
extends ASTBase {
    private static final long serialVersionUID = 1L;

    public ASTContainer(ASTContainer op) {
        super(op);
    }

    public ASTContainer(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public ASTContainer(QueryRoot queryRoot) {
        super(BOp.NOARGS, null);
        this.setOriginalAST(queryRoot);
    }

    public ASTContainer(UpdateRoot updateRoot) {
        super(BOp.NOARGS, null);
        this.setOriginalUpdateAST(updateRoot);
    }

    public String getQueryString() {
        return (String)this.getProperty("queryString");
    }

    public void setQueryString(String queryString) {
        this.setProperty("queryString", queryString);
    }

    public Object getParseTree() {
        return this.getProperty("parseTree");
    }

    public void setParseTree(Object parseTree) {
        this.setProperty("parseTree", parseTree);
    }

    public boolean isUpdate() {
        return this.getProperty("originalAST") instanceof UpdateRoot;
    }

    public boolean isQuery() {
        return this.getProperty("originalAST") instanceof QueryRoot;
    }

    public UpdateRoot getOriginalUpdateAST() {
        return (UpdateRoot)this.getProperty("originalAST");
    }

    public void setOriginalUpdateAST(UpdateRoot updateRoot) {
        this.setProperty("originalAST", updateRoot);
    }

    public QueryRoot getOriginalAST() {
        return (QueryRoot)this.getProperty("originalAST");
    }

    public void setOptimizedASTBindingSets(IBindingSet[] bindingSets) {
        this.setProperty("optimizedASTBindingSets", bindingSets);
    }

    public IBindingSet[] getOptimizedASTBindingSets() {
        return (IBindingSet[])this.getProperty("optimizedASTBindingSets");
    }

    public void setOriginalAST(QueryRoot queryRoot) {
        this.setProperty("originalAST", queryRoot);
    }

    public QueryRoot getOptimizedAST() {
        return (QueryRoot)this.getProperty("optimizedAST");
    }

    public void setQueryParseTime(Long parseTime) {
        this.setProperty("queryParseTime", parseTime);
    }

    public Long getQueryParseTime() {
        return (Long)this.getProperty("queryParseTime");
    }

    public void setResolveValuesTime(Long nanos) {
        this.setProperty("resolveValuesTime", nanos);
    }

    public Long getResolveValuesTime() {
        return (Long)this.getProperty("resolveValuesTime");
    }

    public void setOptimizedAST(QueryRoot queryRoot) {
        this.setProperty("optimizedAST", queryRoot);
    }

    public void clearOptimizedAST() {
        this.clearProperty("optimizedAST");
    }

    public PipelineOp getQueryPlan() {
        return (PipelineOp)this.getProperty("queryPlan");
    }

    public void setQueryPlan(PipelineOp queryPlan) {
        this.setProperty("queryPlan", queryPlan);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String queryString = this.getQueryString();
        Object parseTree = this.getParseTree();
        ASTBase originalAST = (ASTBase)this.getProperty("originalAST");
        ASTBase optimizedAST = (ASTBase)this.getProperty("optimizedAST");
        PipelineOp queryPlan = this.getQueryPlan();
        if (queryString != null) {
            sb.append("\n");
            sb.append("queryString");
            sb.append("\n");
            sb.append(queryString);
            sb.append("\n");
        }
        if (parseTree != null) {
            sb.append("\n");
            sb.append("parseTree");
            sb.append("\n");
            if (parseTree instanceof SimpleNode) {
                sb.append(((SimpleNode)parseTree).dump(""));
            } else {
                sb.append(parseTree.toString());
                sb.append("\n");
            }
        }
        if (originalAST != null) {
            sb.append("\n");
            sb.append("originalAST");
            sb.append(originalAST);
        }
        if (optimizedAST != null) {
            sb.append("\n");
            sb.append("optimizedAST");
            sb.append(optimizedAST);
        }
        if (queryPlan != null) {
            sb.append("\n");
            sb.append("queryPlan");
            sb.append("\n");
            sb.append(BOpUtility.toString(queryPlan));
        }
        return sb.toString();
    }

    public static interface Annotations
    extends QueryBase.Annotations {
        public static final String QUERY_STRING = "queryString";
        public static final String PARSE_TREE = "parseTree";
        public static final String ORIGINAL_AST = "originalAST";
        public static final String OPTIMIZED_AST = "optimizedAST";
        public static final String QUERY_PLAN = "queryPlan";
        public static final String OPTIMIZED_AST_BINDING_SETS = "optimizedASTBindingSets";
        public static final String QUERY_PARSE_TIME = "queryParseTime";
        public static final String RESOLVE_VALUES_TIME = "resolveValuesTime";
        public static final String RESOLVED = "resolved";
    }
}

