/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.ShortPacker;
import com.bigdata.io.compression.NoCompressor;
import com.bigdata.io.compression.UnicodeHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class BigdataValueSerializer<V extends Value> {
    private static final short VERSION0 = 0;
    private static final short VERSION1 = 1;
    protected static final String ERR_VERSION = "Bad version";
    protected static final String ERR_CODE = "Bad term code";
    private final ValueFactory valueFactory;
    private final UnicodeHelper uc;

    private static final short getVersion(Value val) {
        if (BigdataValueSerializer.getStringLength(val) < 32767L) {
            return 0;
        }
        return 1;
    }

    public BigdataValueSerializer(ValueFactory valueFactory) {
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        this.valueFactory = valueFactory;
        this.uc = new UnicodeHelper(new NoCompressor());
    }

    private byte getTermCode(Value val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        if (val instanceof URI) {
            return 1;
        }
        if (val instanceof Literal) {
            Literal lit = (Literal)val;
            if (lit.getLanguage() != null) {
                return 3;
            }
            if (lit.getDatatype() != null) {
                return 4;
            }
            return 2;
        }
        if (val instanceof BNode) {
            return 5;
        }
        throw new IllegalArgumentException("class=" + val.getClass().getName());
    }

    public byte[] serialize(V val) {
        return this.serialize(val, new DataOutputBuffer(128), null);
    }

    public byte[] serialize(V val, DataOutputBuffer out, ByteArrayBuffer tmp) {
        this.serialize2(val, out, tmp);
        return out.toByteArray();
    }

    public void serialize2(V val, DataOutputBuffer out, ByteArrayBuffer tmp) {
        try {
            short version = BigdataValueSerializer.getVersion(val);
            ShortPacker.packShort(out, version);
            switch (version) {
                case 0: {
                    this.serializeVersion0(val, version, out);
                    break;
                }
                case 1: {
                    if (tmp == null) {
                        tmp = new ByteArrayBuffer(128);
                    }
                    this.serializeVersion1(val, version, out, tmp);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(ERR_VERSION);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public V deserialize(byte[] b) {
        return this.deserialize(new DataInputBuffer(b), new StringBuilder(b.length));
    }

    public V deserialize(DataInputBuffer in, StringBuilder tmp) {
        try {
            short version = ShortPacker.unpackShort(in);
            switch (version) {
                case 0: {
                    return this.deserializeVersion0(version, in);
                }
                case 1: {
                    return this.deserializeVersion1(version, in, tmp);
                }
            }
            throw new UnsupportedOperationException("Bad version : " + version);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void serializeVersion0(V val, short version, DataOutput out) throws IOException {
        byte termCode = this.getTermCode((Value)val);
        out.writeByte(termCode);
        switch (termCode) {
            case 5: {
                out.writeUTF(((BNode)val).getID());
                break;
            }
            case 1: {
                out.writeUTF(((URI)val).stringValue());
                break;
            }
            case 2: {
                out.writeUTF(((Literal)val).getLabel());
                break;
            }
            case 3: {
                out.writeUTF(((Literal)val).getLanguage());
                out.writeUTF(((Literal)val).getLabel());
                break;
            }
            case 4: {
                out.writeUTF(((Literal)val).getDatatype().stringValue());
                out.writeUTF(((Literal)val).getLabel());
                break;
            }
            default: {
                throw new IOException("Bad term code : " + termCode);
            }
        }
    }

    private V deserializeVersion0(short version, DataInput in) throws IOException {
        byte termCode = in.readByte();
        switch (termCode) {
            case 5: {
                return (V)this.valueFactory.createBNode(in.readUTF());
            }
            case 1: {
                return (V)this.valueFactory.createURI(in.readUTF());
            }
            case 2: {
                String label = in.readUTF();
                return (V)this.valueFactory.createLiteral(label);
            }
            case 3: {
                String language = in.readUTF();
                String label = in.readUTF();
                return (V)this.valueFactory.createLiteral(label, language);
            }
            case 4: {
                String datatype = in.readUTF();
                String label = in.readUTF();
                return (V)this.valueFactory.createLiteral(label, this.valueFactory.createURI(datatype));
            }
        }
        throw new IOException("Bad term code : " + termCode);
    }

    private void serializeVersion1(V val, short version, OutputStream out, ByteArrayBuffer tmp) throws IOException {
        byte termCode = this.getTermCode((Value)val);
        out.write(termCode);
        switch (termCode) {
            case 5: {
                this.uc.encode(((BNode)val).getID(), out, tmp);
                break;
            }
            case 1: {
                this.uc.encode(((URI)val).stringValue(), out, tmp);
                break;
            }
            case 2: {
                this.uc.encode(((Literal)val).getLabel(), out, tmp);
                break;
            }
            case 3: {
                this.uc.encode(((Literal)val).getLanguage(), out, tmp);
                this.uc.encode(((Literal)val).getLabel(), out, tmp);
                break;
            }
            case 4: {
                this.uc.encode(((Literal)val).getDatatype().stringValue(), out, tmp);
                this.uc.encode(((Literal)val).getLabel(), out, tmp);
                break;
            }
            default: {
                throw new IOException("Bad term code : " + termCode);
            }
        }
    }

    private V deserializeVersion1(short version, DataInputBuffer in, StringBuilder tmp) throws IOException {
        byte termCode = in.readByte();
        switch (termCode) {
            case 5: {
                return (V)this.valueFactory.createBNode(this.uc.decode1(in, tmp));
            }
            case 1: {
                return (V)this.valueFactory.createURI(this.uc.decode1(in, tmp));
            }
            case 2: {
                return (V)this.valueFactory.createLiteral(this.uc.decode1(in, tmp));
            }
            case 3: {
                String language = this.uc.decode1(in, tmp);
                String label = this.uc.decode1(in, tmp);
                return (V)this.valueFactory.createLiteral(label, language);
            }
            case 4: {
                String datatype = this.uc.decode1(in, tmp);
                String label = this.uc.decode1(in, tmp);
                return (V)this.valueFactory.createLiteral(label, this.valueFactory.createURI(datatype));
            }
        }
        throw new IOException("Bad term code : " + termCode);
    }

    public static long getStringLength(Value v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (v instanceof URI) {
            return ((URI)v).stringValue().length();
        }
        if (v instanceof Literal) {
            Literal value = (Literal)v;
            String label = value.getLabel();
            int datatypeLength = value.getDatatype() == null ? 0 : value.getDatatype().stringValue().length();
            int languageLength = value.getLanguage() == null ? 0 : value.getLanguage().length();
            long totalLength = label.length() + datatypeLength + languageLength;
            return totalLength;
        }
        if (v instanceof BNode) {
            return ((BNode)v).getID().length();
        }
        throw new UnsupportedOperationException();
    }
}

