/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.gis;

import com.bigdata.rdf.internal.gis.CoordinateDD;
import com.bigdata.rdf.internal.gis.CoordinateDMS;
import com.bigdata.rdf.internal.gis.CoordinateUtility;
import com.bigdata.rdf.internal.gis.ICoordinate;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordinateDDM
implements ICoordinate {
    public static Logger log = Logger.getLogger(CoordinateDDM.class.getName());
    public final int degreesNorth;
    public final int thousandthsOfMinutesNorth;
    public final int degreesEast;
    public final int thousandthsOfMinutesEast;
    static final String regex_lat = "((\\d{1,2})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2}|\\d{1,2}\\.\\d*)\\s?[:'\\s]?\\s?([NnSs\\s]))";
    static final String regex_long = "((\\d{1,3})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2}|\\d{1,2}\\.\\d*)\\s?[:'\\s]?\\s?([EeWw]))";
    static final Pattern pattern_ddm = Pattern.compile("^((((\\d{1,2})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2}|\\d{1,2}\\.\\d*)\\s?[:'\\s]?\\s?([NnSs\\s]))(\\s?[/,]?\\s?)((\\d{1,3})\\s?[:\ufffd*\\s]?\\s?(\\d{1,2}|\\d{1,2}\\.\\d*)\\s?[:'\\s]?\\s?([EeWw]))))$");
    static final int group_degreesNorth = 4;
    static final int group_minutesNorth = 5;
    static final int group_northSouth = 6;
    static final int group_degreesEast = 9;
    static final int group_minutesEast = 10;
    static final int group_eastWest = 11;

    public CoordinateDDM(int degreesNorth, int thousandthsOfMinutesNorth, int degreesEast, int thousandthsOfMinutesEast) {
        if (degreesNorth > 90 || degreesNorth < -90) {
            throw new IllegalArgumentException();
        }
        if (thousandthsOfMinutesNorth > 60000 || thousandthsOfMinutesNorth < -60000) {
            throw new IllegalArgumentException();
        }
        if (degreesEast > 180 || degreesEast < -180) {
            throw new IllegalArgumentException();
        }
        if (thousandthsOfMinutesEast > 60000 || thousandthsOfMinutesEast < -60000) {
            throw new IllegalArgumentException();
        }
        if (degreesNorth < 0 && thousandthsOfMinutesNorth > 0) {
            throw new IllegalArgumentException();
        }
        if (degreesEast < 0 && thousandthsOfMinutesEast > 0) {
            throw new IllegalArgumentException();
        }
        this.degreesNorth = degreesNorth;
        this.thousandthsOfMinutesNorth = thousandthsOfMinutesNorth;
        this.degreesEast = degreesEast;
        this.thousandthsOfMinutesEast = thousandthsOfMinutesEast;
    }

    public String toString() {
        boolean northSouth = this.degreesNorth > 0;
        boolean eastWest = this.degreesEast > 0;
        String north = "" + (northSouth ? this.degreesNorth : -this.degreesNorth) + " " + CoordinateDDM.formatThousandthsOfMinute(northSouth ? this.thousandthsOfMinutesNorth : -this.thousandthsOfMinutesNorth) + (northSouth ? "N" : "S");
        String east = (eastWest ? "" + this.degreesEast : Integer.valueOf(-this.degreesEast)) + " " + CoordinateDDM.formatThousandthsOfMinute(eastWest ? this.thousandthsOfMinutesEast : -this.thousandthsOfMinutesEast) + (eastWest ? "E" : "W");
        return north + " " + east;
    }

    static String formatThousandthsOfMinute(int thousandthsOfMinute) {
        int minutes = thousandthsOfMinute / 1000;
        int thousandths = thousandthsOfMinute - minutes * 1000;
        return minutes + "." + thousandths;
    }

    public static CoordinateDDM parse(String text) throws ParseException {
        Matcher m = pattern_ddm.matcher(text);
        if (m.matches()) {
            int degreesNorth;
            try {
                degreesNorth = Integer.parseInt(m.group(4));
            }
            catch (NumberFormatException ex) {
                log.log(Level.WARNING, "Parsing text: [" + text + "]", ex);
                throw ex;
            }
            int thousandthsOfMinutesNorth = (int)(Float.parseFloat(m.group(5)) * 1000.0f);
            boolean northSouth = !"S".equalsIgnoreCase(m.group(6));
            int degreesEast = Integer.parseInt(m.group(9));
            int thousandthsOfMinutesEast = (int)(Float.parseFloat(m.group(10)) * 1000.0f);
            boolean eastWest = !"W".equalsIgnoreCase(m.group(11));
            return new CoordinateDDM(northSouth ? degreesNorth : -degreesNorth, northSouth ? thousandthsOfMinutesNorth : -thousandthsOfMinutesNorth, eastWest ? degreesEast : -degreesEast, eastWest ? thousandthsOfMinutesEast : -thousandthsOfMinutesEast);
        }
        throw new ParseException("Not recognized: " + text, 0);
    }

    @Override
    public boolean equals(ICoordinate o) {
        if (o instanceof CoordinateDDM) {
            return this.equals((CoordinateDDM)o);
        }
        return false;
    }

    public boolean equals(CoordinateDDM o) {
        return this.degreesNorth == o.degreesNorth && this.thousandthsOfMinutesNorth == o.thousandthsOfMinutesNorth && this.degreesEast == o.degreesEast && this.thousandthsOfMinutesEast == o.thousandthsOfMinutesEast;
    }

    @Override
    public double distance(ICoordinate o, ICoordinate.UNITS units) {
        return CoordinateUtility.distance(this.toDD(), o.toDD(), units);
    }

    @Override
    public CoordinateDMS toDMS() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CoordinateDD toDD() {
        return new CoordinateDD((double)this.degreesNorth + (double)this.thousandthsOfMinutesNorth / 1000.0 / 60.0, (double)this.degreesEast + (double)this.thousandthsOfMinutesEast / 1000.0 / 60.0);
    }

    @Override
    public CoordinateDDM toDDM() {
        return this;
    }
}

