/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import java.util.LinkedList;
import java.util.List;

public class InlineNamespaceMultiURIHandler
extends InlineURIHandler {
    private final List<InlineURIHandler> inlineHandlers = new LinkedList<InlineURIHandler>();

    public InlineNamespaceMultiURIHandler(String namespace) {
        super(namespace);
    }

    public void addHandler(InlineURIHandler handler) {
        if (!this.getNamespace().equals(handler.getNamespace())) {
            throw new RuntimeException("Tring to add " + handler.getNamespace() + " to " + this.getClass().getCanonicalName() + " configured for " + this.getNamespace());
        }
        this.inlineHandlers.add(handler);
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        for (InlineURIHandler handler : this.inlineHandlers) {
            AbstractLiteralIV iv = handler.createInlineIV(localName);
            if (iv == null) continue;
            return iv;
        }
        return null;
    }
}

