/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.rdf.inf.IJustificationIterator;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.NoSuchElementException;

public class FullyBufferedJustificationIterator
implements IJustificationIterator {
    private final AbstractTripleStore db;
    private final ISPO head;
    private final IKeyBuilder keyBuilder;
    private final IIndex ndx;
    private final Justification[] justifications;
    private final int numJustifications;
    private boolean open = true;
    private int i = 0;
    private Justification current = null;

    public FullyBufferedJustificationIterator(AbstractTripleStore db, ISPO head) {
        assert (db != null);
        assert (head != null);
        this.db = db;
        this.head = head;
        this.ndx = db.getSPORelation().getJustificationIndex();
        this.keyBuilder = KeyBuilder.newInstance();
        head.s().encode(this.keyBuilder);
        head.p().encode(this.keyBuilder);
        head.o().encode(this.keyBuilder);
        byte[] fromKey = this.keyBuilder.getKey();
        byte[] toKey = SuccessorUtil.successor((byte[])fromKey.clone());
        long rangeCount = this.ndx.rangeCount(fromKey, toKey);
        if (rangeCount > 5000000L) {
            throw new RuntimeException("Too many justifications to materialize: " + rangeCount);
        }
        this.justifications = new Justification[(int)rangeCount];
        ITupleIterator itr = this.ndx.rangeIterator(fromKey, toKey, 0, 1, null);
        int i = 0;
        while (itr.hasNext()) {
            this.justifications[i++] = (Justification)itr.next().getObject();
        }
        this.numJustifications = i;
    }

    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        assert (this.i <= this.numJustifications);
        return this.i != this.numJustifications;
    }

    @Override
    public Justification next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.justifications[this.i++];
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.ndx.remove(Justification.getKey(this.keyBuilder, this.current));
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
    }

    public Justification[] nextChunk() {
        Justification[] ret;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.i == 0 && this.numJustifications == this.justifications.length) {
            ret = this.justifications;
        } else {
            int remaining = this.numJustifications - this.i;
            ret = new Justification[remaining];
            System.arraycopy(this.justifications, this.i, ret, 0, remaining);
        }
        this.i = this.numJustifications;
        return ret;
    }
}

