/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.changesets;

import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.striterator.ChunkedArrayIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class InMemChangeLog
implements IChangeLog {
    private static final Logger log = Logger.getLogger(InMemChangeLog.class);
    private final Map<ISPO, IChangeRecord> changeSet = new HashMap<ISPO, IChangeRecord>();
    private final Map<ISPO, IChangeRecord> committed = new HashMap<ISPO, IChangeRecord>();

    @Override
    public synchronized void changeEvent(IChangeRecord record) {
        if (log.isInfoEnabled()) {
            log.info((Object)record);
        }
        this.changeSet.put(record.getStatement(), record);
    }

    @Override
    public void transactionBegin() {
    }

    @Override
    public void transactionPrepare() {
    }

    @Override
    public synchronized void transactionCommited(long commitTime) {
        if (log.isInfoEnabled()) {
            log.info((Object)("transaction committed: " + commitTime));
        }
        this.committed.clear();
        this.committed.putAll(this.changeSet);
        this.changeSet.clear();
    }

    @Override
    public synchronized void transactionAborted() {
        if (log.isInfoEnabled()) {
            log.info((Object)"transaction aborted");
        }
        this.changeSet.clear();
    }

    @Override
    public void close() {
    }

    public Collection<IChangeRecord> getLastCommit() {
        return this.committed.values();
    }

    public Collection<IChangeRecord> getLastCommit(AbstractTripleStore db) {
        return this.resolve(db, this.committed.values());
    }

    private Collection<IChangeRecord> resolve(AbstractTripleStore db, Collection<IChangeRecord> unresolved) {
        LinkedList<IChangeRecord> resolved = new LinkedList<IChangeRecord>();
        ISPO[] spos = new ISPO[unresolved.size()];
        int i = 0;
        for (IChangeRecord rec : unresolved) {
            spos[i++] = rec.getStatement();
        }
        BigdataStatementIterator it = db.asStatementIterator(new ChunkedArrayIterator<ISPO>(i, spos, null));
        for (IChangeRecord rec : unresolved) {
            BigdataStatement stmt = (BigdataStatement)it.next();
            resolved.add(new ChangeRecord(stmt, rec.getChangeAction()));
        }
        return resolved;
    }
}

