/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rawstore;

import com.bigdata.counters.CounterSet;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.rawstore.AbstractRawWormStore;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SimpleMemoryRawStore
extends AbstractRawWormStore {
    private boolean open = true;
    private final UUID uuid = UUID.randomUUID();
    protected int nextOffset = 0;
    private final Map<Long, Integer> addrs;
    protected final ArrayList<byte[]> records;

    public SimpleMemoryRawStore() {
        this(1000);
    }

    public SimpleMemoryRawStore(int capacity) {
        super(31);
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity is negative");
        }
        this.records = new ArrayList(capacity);
        this.addrs = new HashMap<Long, Integer>((int)((double)capacity * 1.25));
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.open) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isFullyBuffered() {
        return true;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        return new ResourceMetadata(this.uuid);
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public void close() {
        if (!this.open) {
            throw new IllegalStateException();
        }
        this.open = false;
        this.records.clear();
    }

    @Override
    public void deleteResources() {
        if (this.open) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void destroy() {
        if (this.isOpen()) {
            this.close();
        }
        this.deleteResources();
    }

    @Override
    public ByteBuffer read(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException("Address is 0L");
        }
        int nbytes = this.getByteCount(addr);
        if (nbytes == 0) {
            throw new IllegalArgumentException("Address encodes record length of zero");
        }
        Integer index = this.addrs.get(addr);
        if (index == null) {
            throw new IllegalArgumentException("Address never written.");
        }
        byte[] b = this.records.get(index);
        if (b == null) {
            throw new IllegalArgumentException("Record was deleted");
        }
        if (b.length != nbytes) {
            throw new RuntimeException("Bad address / data");
        }
        return ByteBuffer.wrap(b).asReadOnlyBuffer();
    }

    @Override
    public long write(ByteBuffer data) {
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        int nbytes = data.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException("No bytes remaining in buffer");
        }
        byte[] b = new byte[nbytes];
        data.get(b);
        int offset = this.nextOffset;
        this.nextOffset += nbytes;
        int index = this.records.size();
        this.records.add(b);
        long addr = this.toAddr(nbytes, offset);
        this.addrs.put(addr, index);
        return addr;
    }

    @Override
    public void force(boolean metadata) {
    }

    @Override
    public long size() {
        return this.nextOffset;
    }

    @Override
    public CounterSet getCounters() {
        return new CounterSet();
    }

    private static class ResourceMetadata
    implements IResourceMetadata {
        private static final long serialVersionUID = -8333003625527191826L;
        private final UUID uuid;

        public ResourceMetadata(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public boolean equals(IResourceMetadata o) {
            return this == o;
        }

        @Override
        public long getCreateTime() {
            return 0L;
        }

        @Override
        public long getCommitTime() {
            return 0L;
        }

        @Override
        public String getFile() {
            return null;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public boolean isIndexSegment() {
            return false;
        }

        @Override
        public boolean isJournal() {
            return false;
        }
    }
}

